/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class FinanceDocumentsCommonVerifyShipmentsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Collection shipmentContainers = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINERS);
        if (shipmentContainers.size() == 0) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_createShipmentsEmpty).build());
            throw new Exception("verification failed");
        }
        for (EntityContainer shipmentContainer : shipmentContainers) {
            Shipment shipment = (Shipment)shipmentContainer.getEntity();
            EntityReference supplier = shipment.getSupplier();
            if (supplier == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_createSupplierNotDefined).parameters(new Object[]{shipmentContainer.toReference()}).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            EntityReference customer = shipment.getCustomer();
            if (customer == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_createCustomerNotDefined).parameters(new Object[]{shipmentContainer.toReference()}).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            EntityReference payer = shipment.getPayer();
            if (payer == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_createPayerNotDefined).parameters(new Object[]{shipmentContainer.toReference()}).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            NestedEntityReference contract = shipment.getContract();
            if (contract == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_createContractNotDefined).parameters(new Object[]{shipmentContainer.toReference()}).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            DictionaryReference currency = shipment.getCurrency();
            if (currency != null) continue;
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_createCurrencyNotDefined).parameters(new Object[]{shipmentContainer.toReference()}).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[0])).build());
            throw new Exception("verification failed");
        }
    }
}

