/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRules;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndex;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceDocumentsIbusHelper {
    private static final Logger log = LoggerFactory.getLogger(FinanceDocumentsIbusHelper.class);
    public static final DictionaryReference<ShipmentCategory> noShipmentCategory = new ShipmentCategoryReference("NO_SHIPMENT");
    public static final DictionaryReference<ShipmentCategory> bookingFileCategory = new ShipmentCategoryReference("BOOKING_FILE");
    public static final DictionaryReference<ShipmentCategory> productCategory = new ShipmentCategoryReference("PRODUCT");
    public static final DictionaryReference<ShipmentCategory> agentCategory = new ShipmentCategoryReference("AGENT");
    public static final DictionaryReference<ShipmentCategory> dayCategory = new ShipmentCategoryReference("DAY");
    public static final DictionaryReference<ShipmentCategory> paymentCodeCategory = new ShipmentCategoryReference("PAYMENT_CODE");
    public static final DictionaryReference<ShipmentCategory> costCodeCategory = new ShipmentCategoryReference("COST_CODE");
    public static final PersonalLocalizableNameFormatter nameFormatter = new PersonalLocalizableNameFormatter("L f m");

    public static NestedEntityReference<Organization, BankAccount> getBankAccount(EntityReference<Organization> organizationReference) {
        EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
        if (organizationContainer == null) {
            return null;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        FinanceDocumentsProperties financeDocumentsProperties = organization.getFinanceDocumentProperties();
        if (financeDocumentsProperties == null) {
            return null;
        }
        BankAccount bankAccount = financeDocumentsProperties.getBankAccount();
        if (bankAccount == null) {
            return null;
        }
        return new EntityStorageHelper.NestedEntity(organizationContainer, (BaseEntity)bankAccount).toReference();
    }

    public static NestedEntityReference<Organization, BankAccount> getBankAccount(EntityContainer<Contract> contractContainer) {
        if (contractContainer == null) {
            return null;
        }
        EntityReference supplier = ((Contract)contractContainer.getEntity()).getSupplier();
        if (supplier == null) {
            return null;
        }
        EntityContainer organizationContainer = EntityStorage.get().resolve(supplier);
        BankAccount bankAccount = ((Contract)contractContainer.getEntity()).getBankAccount();
        if (bankAccount != null && organizationContainer != null) {
            return new EntityStorageHelper.NestedEntity(organizationContainer, (BaseEntity)bankAccount).toReference();
        }
        return FinanceDocumentsIbusHelper.getBankAccount((EntityReference<Organization>)supplier);
    }

    public static String getAmountString(BigDecimal amount, String currency, Locale locale) {
        Number2WordsConverter converter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(locale, currency);
        if (converter != null) {
            try {
                return TextUtil.capitalize((String)converter.toCurrencyWords(amount, currency, false, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<MergedBillingItem> prepareBillingItems(FinanceDocument document, boolean hasColumnVatRate, boolean noPenaltyVat, Locale locale, EntityStorageContext storageContext) throws Exception {
        ArrayList<MergedBillingItem> preparedBillingItems = new ArrayList<MergedBillingItem>();
        Map billingItemShipmentBatches = FinanceDocumentHelper.getBillingItems(document.getBillingItems(), storageContext).stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getShipment()), () -> new TreeMap(FinanceDocumentsIbusHelper.getShipmentComparator(storageContext, locale)), Collectors.groupingBy(item -> Optional.ofNullable(document.isGroupByTraveller() ? item.getTraveller() : null), () -> new TreeMap(FinanceDocumentsIbusHelper.getTravellerComparator(storageContext, locale)), Collectors.groupingBy(item -> Optional.ofNullable(!document.isNotGroupByProduct() ? item.getProduct() : null), () -> new TreeMap(FinanceDocumentsIbusHelper.getProductComparator(storageContext, locale)), Collectors.groupingBy(item -> Optional.ofNullable(!document.isNotGroupByServiceType() ? item.getServiceType() : null), () -> new TreeMap(FinanceDocumentsIbusHelper.getServiceTypeComparator(storageContext, locale)), Collectors.toList())))));
        Boolean mergeBillingItems = Optional.ofNullable(document.getMergeBillingItems()).orElseGet(() -> Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getSupplier(), (EntityStorageContext)storageContext)).map(item -> ((Organization)item.getEntity()).isSimpleTaxed() ? Boolean.valueOf(true) : null).orElse(null));
        for (Map.Entry billingItemShipmentBatch : billingItemShipmentBatches.entrySet()) {
            EntityReference shipmentReference = ((Optional)billingItemShipmentBatch.getKey()).orElse(null);
            Map billingItemTravellerBatches = (Map)billingItemShipmentBatch.getValue();
            for (Map.Entry billingItemTravellerBatch : billingItemTravellerBatches.entrySet()) {
                NestedEntityReference travellerReference = ((Optional)billingItemTravellerBatch.getKey()).orElse(null);
                Map billingItemProductBatches = (Map)billingItemTravellerBatch.getValue();
                for (Map.Entry billingItemProductBatchEntry : billingItemProductBatches.entrySet()) {
                    Map billingItemServiceTypeBatches = (Map)billingItemProductBatchEntry.getValue();
                    for (Map.Entry billingItemServiceTypeBatchEntry : billingItemServiceTypeBatches.entrySet()) {
                        ServiceType type = ((Optional)billingItemServiceTypeBatchEntry.getKey()).orElse(null);
                        List billingItems = (List)billingItemServiceTypeBatchEntry.getValue();
                        ArrayList groupedBillingItemsList = new ArrayList();
                        for (BillingItem billingItem : billingItems) {
                            void var26_28;
                            Object var26_27 = null;
                            for (List list : groupedBillingItemsList) {
                                BillingItem billingItem2 = (BillingItem)CollectionUtil.find((Collection)list, (Object)billingItem, (o1, o2) -> {
                                    boolean vat2;
                                    if (!MiscUtil.equals((Object)o1.getName(), (Object)o2.getName())) {
                                        return false;
                                    }
                                    if (mergeBillingItems != null) {
                                        return mergeBillingItems;
                                    }
                                    NestedEntityReference productReference1 = o1.getProduct();
                                    BaseProduct product1 = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productReference1, (EntityStorageContext)storageContext);
                                    NestedEntityReference productReference2 = o2.getProduct();
                                    BaseProduct product2 = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productReference2, (EntityStorageContext)storageContext);
                                    boolean vat1 = hasColumnVatRate && product1 != null && ProductHandler.of((BaseProduct)product1).isVatIncludeBillingItem(product1, document.getVatViewMode(), o1);
                                    boolean bl = vat2 = hasColumnVatRate && product2 != null && ProductHandler.of((BaseProduct)product2).isVatIncludeBillingItem(product2, document.getVatViewMode(), o2);
                                    if (vat1 != vat2) {
                                        return false;
                                    }
                                    if (vat1 && vat2) {
                                        Double vatRate2;
                                        Double vatRate1 = o1.getServiceType() != ServiceType.PENALTY || !noPenaltyVat ? (Double)Optional.ofNullable(o1.getAmount()).map(VatAmount::getVat).orElse(null) : null;
                                        Double d = vatRate2 = o2.getServiceType() != ServiceType.PENALTY || !noPenaltyVat ? (Double)Optional.ofNullable(o2.getAmount()).map(VatAmount::getVat).orElse(null) : null;
                                        if (!MiscUtil.equals((Object)vatRate1, vatRate2)) {
                                            return false;
                                        }
                                    }
                                    return true;
                                });
                                if (billingItem2 == null) continue;
                                list.add(billingItem);
                                break;
                            }
                            if (var26_28 != null) continue;
                            ArrayList<BillingItem> groupedBillingItems = new ArrayList<BillingItem>();
                            groupedBillingItems.add(billingItem);
                            groupedBillingItemsList.add(groupedBillingItems);
                        }
                        ArrayList<MergedBillingItem> mergedBillingItems = new ArrayList<MergedBillingItem>();
                        for (List list : groupedBillingItemsList) {
                            mergedBillingItems.add(new MergedBillingItem(FinanceDocumentsIbusHelper.mergeBillingItems(list, noPenaltyVat), list));
                        }
                        mergedBillingItems.sort(MiscUtil.comparator(Arrays.asList(MiscUtil.comparator(item -> ((MergedBillingItem)item).mergedBillingItem.getFopComponents().stream().map(component -> (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)component, (EntityStorageContext)storageContext)).filter(Objects::nonNull).max(FinanceDocumentsHelper.fopComponentComparator).orElse(null), (Comparator)FinanceDocumentsHelper.fopComponentComparator), MiscUtil.comparator(item -> ((MergedBillingItem)item).mergedBillingItem.getName()))));
                        preparedBillingItems.addAll(mergedBillingItems);
                    }
                }
            }
        }
        return preparedBillingItems;
    }

    private static BillingItem mergeBillingItems(Collection<BillingItem> billingItems, boolean noPenaltyVat) throws Exception {
        BillingItem mergedBillingItem = null;
        for (BillingItem billingItem : billingItems) {
            Double vatRate;
            VatAmount mergedBillingItemAmount;
            if (mergedBillingItem == null) {
                mergedBillingItem = (BillingItem)billingItem.clone(true, new HashMap());
                mergedBillingItemAmount = (VatAmount)MiscUtil.computeIfNull((Object)mergedBillingItem, BillingItem::getAmount, BillingItem::setAmount, VatAmount::new);
                BigDecimal total = mergedBillingItemAmount.getTotal();
                BigDecimal vatAmount = null;
                Double vatRate2 = null;
                if (billingItem.getServiceType() != ServiceType.PENALTY || !noPenaltyVat) {
                    vatAmount = mergedBillingItemAmount.getVatAmount();
                    vatRate2 = mergedBillingItemAmount.getVat();
                }
                if (vatAmount != null) {
                    if (vatRate2 != null) {
                        mergedBillingItemAmount.setTotalVatAmount(total, vatAmount, vatRate2.doubleValue());
                        continue;
                    }
                    mergedBillingItemAmount.setTotalVatAmount(total, vatAmount);
                    continue;
                }
                mergedBillingItemAmount.setTotalNoVat(total);
                continue;
            }
            mergedBillingItemAmount = (VatAmount)MiscUtil.computeIfNull(mergedBillingItem, BillingItem::getAmount, BillingItem::setAmount, VatAmount::new);
            VatAmount billingItemAmount = (VatAmount)MiscUtil.computeIfNull((Object)billingItem, BillingItem::getAmount, BillingItem::setAmount, VatAmount::new);
            BigDecimal total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{mergedBillingItemAmount.getTotal(), billingItemAmount.getTotal()});
            BigDecimal vatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{mergedBillingItemAmount.getVatAmount(), billingItem.getServiceType() != ServiceType.PENALTY || !noPenaltyVat ? billingItemAmount.getVatAmount() : null});
            Double d = vatRate = Objects.equals(mergedBillingItemAmount.getVat(), billingItemAmount.getVat()) ? mergedBillingItemAmount.getVat() : null;
            if (vatAmount != null) {
                if (vatRate != null) {
                    mergedBillingItemAmount.setTotalVatAmount(total, vatAmount, vatRate.doubleValue());
                } else {
                    mergedBillingItemAmount.setTotalVatAmount(total, vatAmount);
                }
            } else {
                mergedBillingItemAmount.setTotalNoVat(total);
            }
            billingItem.getFopComponents().addAll(billingItem.getFopComponents());
        }
        return mergedBillingItem;
    }

    public static final Comparator<Optional<EntityReference<Shipment>>> getShipmentComparator(EntityStorageContext context, Locale locale) {
        return MiscUtil.comparator(item -> Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)item.orElse(null), (EntityStorageContext)context)).map(EntityContainer::getEntity).orElse(null), (Comparator)FinanceDocumentsHelper.shipmentComparator);
    }

    public static final Comparator<Optional<NestedEntityReference<BookingFile, Traveller>>> getTravellerComparator(final EntityStorageContext context, final Locale locale) {
        return MiscUtil.comparator(item -> (Traveller)EntityStorageHelper.resolve((NestedEntityReference)item.orElse(null), (EntityStorageContext)context), (Comparator)new Comparator<Traveller>(){

            @Override
            public int compare(Traveller o1, Traveller o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                return MiscUtil.compare((Comparable)((Object)this.getSortingTravellerName(o1)), (Comparable)((Object)this.getSortingTravellerName(o2)));
            }

            private String getSortingTravellerName(Traveller traveller) {
                String name = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)traveller.getPassenger(), (EntityStorageContext)context)).map(item -> new PersonalLocalizableNameFormatter("L F M").format((PersonalLocalizableName)item.getEntity(), locale, false)).orElse(traveller.getName());
                return name;
            }
        });
    }

    public static final Comparator<Optional<NestedEntityReference<BookingFile, BaseProduct>>> getProductComparator(EntityStorageContext context, Locale locale) {
        return MiscUtil.comparator(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.orElse(null), (EntityStorageContext)context), (Comparator)FinanceDocumentsHelper.productComparator);
    }

    public static Comparator<Optional<ServiceType>> getServiceTypeComparator(EntityStorageContext context, Locale locale) {
        return MiscUtil.comparator(item -> item.orElse(null), (Comparator)FinanceDocumentsHelper.serviceTypeComparator);
    }

    public static boolean isUseDelegate(MessageContext context, ShipmentHoldersBatch shipmentHoldersBatch) {
        Boolean value = (Boolean)context.getObject((Enum)IBusFinanceContextKeys.USE_DELEGATE);
        if (value != null) {
            return value;
        }
        return shipmentHoldersBatch.isUseDelegate();
    }

    public static boolean isUseFacsimile(MessageContext context, ShipmentHoldersBatch shipmentHoldersBatch) {
        Boolean value = (Boolean)context.getObject((Enum)IBusFinanceContextKeys.USE_FACSIMILE);
        if (value != null) {
            return value;
        }
        return shipmentHoldersBatch.isUseFacsimile();
    }

    public static boolean isPenaltyInPenalty(MCOCategory category) {
        return category == MCOCategory.REBOOKING;
    }

    public static BigDecimal getOrganizationVatRate(EntityReference<Organization> organization) {
        return Optional.ofNullable(EntityStorage.get().resolve(organization)).map(EntityContainer::getEntity).filter(item -> !item.isSimpleTaxed()).map(item -> DictHelper.getDefaultVat()).orElse(null);
    }

    public static EntityReference<Contract> createContractReference(NestedEntityReference<Contract, ContractCustomerInfo> contract) {
        return new EntityReference(contract.getUid(), Contract.class, null);
    }

    public static BaseProduct getCategoryProduct(BaseProduct product) {
        BaseProduct categoryProduct;
        HashSet<String> visitedProductsUids = new HashSet<String>();
        BaseProduct parentProduct = categoryProduct = product;
        while (true) {
            visitedProductsUids.add(parentProduct.getUid());
            Date issueDate = ProductHandler.of((BaseProduct)parentProduct).findIssueDate(parentProduct);
            parentProduct = ProductHandler.of((BaseProduct)parentProduct).getRelatedProducts(parentProduct).stream().findFirst().filter(prod -> !visitedProductsUids.contains(prod.getUid())).filter(item -> MiscUtil.isSameDay((Date)issueDate, (Date)ProductHandler.of((BaseProduct)item).findIssueDate(item))).orElse(Optional.ofNullable(ProductHandler.of((BaseProduct)parentProduct).getPreviousProduct(parentProduct)).filter(prod -> !visitedProductsUids.contains(prod.getUid())).filter(item -> issueDate != null && ProductHandler.of((BaseProduct)item).findIssueDate(item) != null && MiscUtil.isSameDay((Date)issueDate, (Date)ProductHandler.of((BaseProduct)item).findIssueDate(item))).orElse(null));
            if (parentProduct == null) break;
            if (!FinanceDocumentsHelper.allowedProductStatusesShipment.contains(ProductHandler.of((BaseProduct)parentProduct).getBaseStatus(parentProduct))) continue;
            categoryProduct = parentProduct;
        }
        return categoryProduct;
    }

    public static boolean isNegatePrices(BaseProduct product) {
        ProductStatus status = ProductHandler.of((BaseProduct)product).getBaseStatus(product);
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            return true;
        }
        return product instanceof AgencyMemoProduct && ((AgencyMemoProduct)product).getType() == AgencyMemoProductType.ACM;
    }

    private static String toString(ExtendedProductType productType) {
        return "productType -> " + productType.getProductType() + "\nproductDescription -> " + productType.getProductDescription();
    }

    private static String toString(BillingItem billingItem) {
        return "name -> " + billingItem.getName() + "\nserviceType -> " + billingItem.getServiceType() + "\npaymentType -> " + billingItem.getPaymentType() + "\nnomenclature -> " + billingItem.getNomenclature() + "\n" + DebugUtil.decorate((String)FinanceDocumentsIbusHelper.toString(billingItem.getAmount()), null, (String)"amount", (boolean)true) + "positionsCount -> " + billingItem.getPositionsCount();
    }

    private static String toString(VatAmount amount) {
        return "total -> " + amount.getTotal() + "\nvalue -> " + amount.getValue() + "\nvatAmount -> " + amount.getVatAmount() + "\nvat -> " + amount.getVat();
    }

    public static String toString(BillingItemHolder holder) {
        return "paymentType -> " + holder.getPaymentType() + "\nserviceType -> " + holder.getServiceType() + "\n" + DebugUtil.decorate((String)FinanceDocumentsIbusHelper.toString(holder.getProductType()), null, (String)"productType", (boolean)true) + "productStatus -> " + holder.getProductStatus() + "\nissuedInExchange -> " + holder.isIssuedInExchange() + "\nrefunded -> " + holder.isRefunded() + "\nnomenclature -> " + holder.getNomenclature() + "\n" + DebugUtil.decorate((String)FinanceDocumentsIbusHelper.toString(holder.getItem()), null, (String)"item", (boolean)true);
    }

    public static BigDecimal calculateShipmentUnpaidAmount(EntityContainer<Shipment> shipment, EntityStorageContext storageContext) {
        BigDecimal billingItemsAmount = FinanceDocumentsIbusHelper.calculateBillingItemsAmount(((Shipment)shipment.getEntity()).getBillingItems(), storageContext);
        BigDecimal paymentItemsAmount = FinanceDocumentsIbusHelper.calculatePaymentItemsAmount(((Shipment)shipment.getEntity()).getPaymentItems(), storageContext);
        return billingItemsAmount.subtract(paymentItemsAmount);
    }

    public static BigDecimal calculateFinanceDocumentUnpaidAmount(EntityContainer<FinanceDocument> financeDocument, EntityStorageContext storageContext) {
        BigDecimal billingItemsAmount = FinanceDocumentsIbusHelper.calculateBillingItemsAmount(((FinanceDocument)financeDocument.getEntity()).getBillingItems(), storageContext);
        BigDecimal paymentItemsAmount = FinanceDocumentsIbusHelper.calculatePaymentItemsAmount(((FinanceDocument)financeDocument.getEntity()).getPaymentItems(), storageContext);
        return billingItemsAmount.subtract(paymentItemsAmount);
    }

    public static BigDecimal calculatePaymentDocumentRemainAmount(EntityContainer<? extends BasePaymentDocument> paymentDocument, EntityStorageContext storageContext) {
        BigDecimal totalAmount = ((BasePaymentDocument)paymentDocument.getEntity()).getTotalAmount().getValue();
        BigDecimal paymentItemsAmount = FinanceDocumentsIbusHelper.calculatePaymentItemsAmount(((BasePaymentDocument)paymentDocument.getEntity()).getPaymentItems(), storageContext);
        return totalAmount.subtract(paymentItemsAmount);
    }

    private static BigDecimal calculateBillingItemsAmount(List<NestedEntityReference<BillingItemsList, BillingItem>> billingItems, EntityStorageContext storageContext) {
        return FinanceDocumentHelper.getBillingItems(billingItems, storageContext).stream().map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getTotal).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
    }

    private static BigDecimal calculatePaymentItemsAmount(List<NestedEntityReference<PaymentItemsList, PaymentItem>> paymentItems, EntityStorageContext storageContext) {
        return paymentItems.stream().map(item -> (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(PaymentItem::getAmount).filter(Objects::nonNull).map(Money::getValue).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
    }

    public static NestedEntityReference<PaymentItemsList, PaymentItem> createRemainPaymentItemReference(EntityContainer<PaymentItemsList> paymentItemsList, PaymentItem originalPaymentItem, BigDecimal remainAmount) throws Exception {
        PaymentItem remainPaymentItem = (PaymentItem)XCloneHelper.clone((XCloneable)originalPaymentItem, (boolean)true);
        remainPaymentItem.getAmount().setValue(remainAmount);
        ((PaymentItemsList)paymentItemsList.getEntity()).getData().add(remainPaymentItem);
        return new NestedEntityReference(paymentItemsList, (BaseEntity)remainPaymentItem);
    }

    public static Set<VendorData> getVendorDatas(ShipmentHolder shipmentHolder, FinanceDocumentType type, EntityStorageContext storageContext) {
        HashSet<VendorData> vendorDatas = new HashSet<VendorData>();
        List<BillingItem> billingItems = FinanceDocumentHelper.getBillingItems(((Shipment)shipmentHolder.getShipment().getEntity()).getBillingItems(), storageContext);
        for (BillingItem billingItem : billingItems) {
            VendorFinanceDocumentData vendorFinanceDocumentData;
            EntityContainer contract;
            EntityReference contractRef;
            GeneralProductContractRelationData contractRelation;
            BaseProduct product;
            if (!MiscUtil.equals((Object)shipmentHolder.getNomenclature(), (Object)billingItem.getNomenclature()) || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext)) == null) continue;
            EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
            if (!MiscUtil.equals((Object)shipmentHolder.getVendor(), (Object)supplier)) continue;
            if (product instanceof HotelProduct) {
                HotelProvider hotelProvider = ((HotelProduct)product).getProvider();
                Double hotelVatRate = HotelProductHelper.getHotelVatRate((HotelProduct)((HotelProduct)product));
                if (!MiscUtil.equals((Object)shipmentHolder.getHotelProvider(), (Object)hotelProvider) || !MiscUtil.equals((Object)shipmentHolder.getHotelVatRate(), (Object)hotelVatRate)) continue;
            }
            if ((contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product)) != null && (contractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (contract = EntityStorage.get().resolve(contractRef)) != null) {
                AgreementType agreementType = ((Contract)contract.getEntity()).getAgreementType();
                if (!MiscUtil.equals((Object)shipmentHolder.getVendorAgreementType(), (Object)agreementType)) continue;
            }
            if ((vendorFinanceDocumentData = (VendorFinanceDocumentData)product.getVendorFinanceDocumentsData().stream().filter(item -> type.equals((Object)item.getType())).filter(item -> TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorDate() != null).findFirst().orElse(null)) == null || supplier == null) continue;
            VendorData vendorData = new VendorData((EntityReference<Organization>)supplier, vendorFinanceDocumentData);
            vendorDatas.add(vendorData);
        }
        return vendorDatas;
    }

    public static List<AppliedRule> mergeAppliedRules(List<AppliedRule> appliedRules) {
        Map<String, List<AppliedRule>> appliedRulesMap = appliedRules.stream().collect(Collectors.groupingBy(item -> String.format("%s_%s", item.getProductUid(), item.getRuleUid())));
        return appliedRulesMap.values().stream().map(item -> item.stream().min((i1, i2) -> MiscUtil.compare((Date)i1.getCalculationDate(), (Date)i2.getCalculationDate())).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void createShipmentProductAppliedRules(List<AppliedRule> appliedRules, EntityReference<Shipment> shipmentReference, EntityStorageContext storageContext) {
        Set<EntityContainer<ShipmentProductAppliedRules>> shipmentAppliedRules = FinanceDocumentsIbusHelper.getShipmentProductAppliedRules(shipmentReference);
        ArrayList<AppliedRule> remainAppliedRules = new ArrayList<AppliedRule>(appliedRules);
        HashSet<EntityContainer> shipmentAppliedRulesToUpdate = new HashSet<EntityContainer>();
        for (AppliedRule appliedRule : appliedRules) {
            EntityContainer shipmentAppliedRulesCtr = shipmentAppliedRules.stream().filter(item -> ((String)CollectionUtil.single((Collection)((ShipmentProductAppliedRules)item.getEntity()).getAppliedRules().stream().map(AppliedRule::getProductUid).collect(Collectors.toSet()))).equals(appliedRule.getProductUid())).findFirst().orElse(null);
            if (shipmentAppliedRulesCtr == null) continue;
            List existAppliedRules = ((ShipmentProductAppliedRules)shipmentAppliedRulesCtr.getEntity()).getAppliedRules();
            if (existAppliedRules.stream().noneMatch(item -> MiscUtil.equals((Object)item.getRuleUid(), (Object)appliedRule.getRuleUid()))) {
                existAppliedRules.add(appliedRule);
                shipmentAppliedRulesToUpdate.add(shipmentAppliedRulesCtr);
            }
            remainAppliedRules.remove(appliedRule);
        }
        for (EntityContainer ctr : shipmentAppliedRulesToUpdate) {
            EntityStorage.get().save(ctr, true);
        }
        Map<String, List<AppliedRule>> appliedRulesMap = remainAppliedRules.stream().collect(Collectors.groupingBy(AppliedRule::getProductUid));
        for (Map.Entry<String, List<AppliedRule>> entry : appliedRulesMap.entrySet()) {
            ShipmentProductAppliedRules shipmentProductAppliedRules = new ShipmentProductAppliedRules();
            shipmentProductAppliedRules.getAppliedRules().addAll((Collection)entry.getValue());
            shipmentProductAppliedRules.setShipment(shipmentReference);
            EntityStorageHelper.createContainer((BaseEntity)shipmentProductAppliedRules, (EntityStorageContext)storageContext);
        }
    }

    public static Set<EntityContainer<ShipmentProductAppliedRules>> getShipmentProductAppliedRules(EntityReference<Shipment> shipment) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentProductAppliedRulesIndex.Property.shipment.name(), shipment));
        EntityStorage entityStorage = EntityStorage.get();
        return entityStorage.search(ShipmentProductAppliedRulesIndex.class, query).getData().stream().map(item -> entityStorage.resolve(item.getSource())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<BaseProduct> getProductsFromBillingItemsList(List<NestedEntityReference<BillingItemsList, BillingItem>> billingItems, Predicate<BillingItem> biPredicate, Predicate<NestedEntityReference<BookingFile, BaseProduct>> productPredicate, EntityStorageContext storageContext) {
        HashSet<BaseProduct> products = new HashSet<BaseProduct>();
        Map<String, List<NestedEntityReference>> productsMap = FinanceDocumentHelper.getBillingItems(billingItems, storageContext).stream().filter(bi -> biPredicate == null || biPredicate.test((BillingItem)bi)).map(BillingItem::getProduct).filter(product -> product != null && (productPredicate == null || productPredicate.test((NestedEntityReference<BookingFile, BaseProduct>)product))).distinct().collect(Collectors.groupingBy(EntityReference::getUid));
        for (Map.Entry<String, List<NestedEntityReference>> bfGroup : productsMap.entrySet()) {
            EntityContainer bookingFile = EntityStorage.get().load(BookingFile.class, bfGroup.getKey());
            if (bookingFile == null) continue;
            for (NestedEntityReference productRef : bfGroup.getValue()) {
                BaseProduct product2 = (BaseProduct)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFile.getEntity(), (NestedEntityReference)productRef);
                if (product2 == null) continue;
                products.add(product2);
            }
        }
        return products;
    }

    public static class MismatchedParameter {
        private final String parameterName;
        private final String requiredValue;
        private final String currentValue;
        private final Set<BaseProduct> products = new HashSet<BaseProduct>();
        private final List<EntityContainer<Shipment>> shipments = new ArrayList<EntityContainer<Shipment>>();

        public MismatchedParameter(String parameterName, String requiredValue, String currentValue) {
            this.parameterName = parameterName;
            this.requiredValue = requiredValue;
            this.currentValue = currentValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getRequiredValue() {
            return this.requiredValue;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public Set<BaseProduct> getProducts() {
            return this.products;
        }

        public List<EntityContainer<Shipment>> getShipments() {
            return this.shipments;
        }
    }

    public static class VendorData {
        private EntityReference<Organization> vendor;
        private VendorFinanceDocumentData vendorFinanceDocumentData;

        public VendorData(EntityReference<Organization> vendor, VendorFinanceDocumentData vendorFinanceDocumentData) {
            this.vendor = vendor;
            this.vendorFinanceDocumentData = vendorFinanceDocumentData;
        }

        public EntityReference<Organization> getVendor() {
            return this.vendor;
        }

        public void setVendor(EntityReference<Organization> vendor) {
            this.vendor = vendor;
        }

        public VendorFinanceDocumentData getVendorFinanceDocumentData() {
            return this.vendorFinanceDocumentData;
        }

        public void setVendorFinanceDocumentData(VendorFinanceDocumentData vendorFinanceDocumentData) {
            this.vendorFinanceDocumentData = vendorFinanceDocumentData;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VendorData)) {
                return false;
            }
            VendorData that = (VendorData)obj;
            return MiscUtil.equals(this.vendor, that.vendor) && MiscUtil.equals((Object)this.vendorFinanceDocumentData, (Object)that.vendorFinanceDocumentData);
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.vendor, this.vendorFinanceDocumentData});
        }
    }

    public static class MergedBillingItem {
        private final BillingItem mergedBillingItem;
        private final List<BillingItem> billingItems;

        public MergedBillingItem(BillingItem mergedBillingItem, List<BillingItem> billingItems) {
            this.mergedBillingItem = mergedBillingItem;
            this.billingItems = billingItems;
        }

        public BillingItem getMergedBillingItem() {
            return this.mergedBillingItem;
        }

        public List<BillingItem> getBillingItems() {
            return this.billingItems;
        }
    }

    public static class ProductHoldersBatch {
        private EntityReference<Organization> supplier;
        private EntityReference<Organization> customer;
        private EntityReference<Organization> payer;
        private EntityReference<Contract> contract;
        private DictionaryReference<CurrencyInfo> currency;
        private final List<ProductHolder> productHolders = new ArrayList<ProductHolder>();
        private final List<AppliedRule> appliedRules = new ArrayList<AppliedRule>();

        public EntityReference<Organization> getSupplier() {
            return this.supplier;
        }

        public void setSupplier(EntityReference<Organization> supplier) {
            this.supplier = supplier;
        }

        public EntityReference<Organization> getCustomer() {
            return this.customer;
        }

        public void setCustomer(EntityReference<Organization> customer) {
            this.customer = customer;
        }

        public EntityReference<Organization> getPayer() {
            return this.payer;
        }

        public void setPayer(EntityReference<Organization> payer) {
            this.payer = payer;
        }

        public EntityReference<Contract> getContract() {
            return this.contract;
        }

        public void setContract(EntityReference<Contract> contract) {
            this.contract = contract;
        }

        public DictionaryReference<CurrencyInfo> getCurrency() {
            return this.currency;
        }

        public void setCurrency(DictionaryReference<CurrencyInfo> currency) {
            this.currency = currency;
        }

        public List<ProductHolder> getProductHolders() {
            return this.productHolders;
        }

        public List<AppliedRule> getAppliedRules() {
            return this.appliedRules;
        }
    }

    public static class ProductHolder {
        private EntityContainer<BookingFile> bookingFile;
        private BaseProduct product;
        private ProductHolder previousProductHolder;
        private Boolean mergeBillingItemsWithDifferentVat;
        private Boolean mergeRefundBillingItems;
        private Boolean separateHiddenFopComponents;
        private Date shipmentPeriodBegin;
        private Date shipmentPeriodEnd;
        private final List<FopComponentHolder> fopComponentsHolders = new ArrayList<FopComponentHolder>();

        public EntityContainer<BookingFile> getBookingFile() {
            return this.bookingFile;
        }

        public void setBookingFile(EntityContainer<BookingFile> bookingFile) {
            this.bookingFile = bookingFile;
        }

        public BaseProduct getProduct() {
            return this.product;
        }

        public void setProduct(BaseProduct product) {
            this.product = product;
        }

        public ProductHolder getPreviousProductHolder() {
            return this.previousProductHolder;
        }

        public void setPreviousProductHolder(ProductHolder previousProductHolder) {
            this.previousProductHolder = previousProductHolder;
        }

        public Boolean getMergeBillingItemsWithDifferentVat() {
            return this.mergeBillingItemsWithDifferentVat;
        }

        public void setMergeBillingItemsWithDifferentVat(Boolean mergeBillingItemsWithDifferentVat) {
            this.mergeBillingItemsWithDifferentVat = mergeBillingItemsWithDifferentVat;
        }

        public Boolean getMergeRefundBillingItems() {
            return this.mergeRefundBillingItems;
        }

        public void setMergeRefundBillingItems(Boolean mergeRefundBillingItems) {
            this.mergeRefundBillingItems = mergeRefundBillingItems;
        }

        public Boolean getSeparateHiddenFopComponents() {
            return this.separateHiddenFopComponents;
        }

        public void setSeparateHiddenFopComponents(Boolean separateHiddenFopComponents) {
            this.separateHiddenFopComponents = separateHiddenFopComponents;
        }

        public Date getShipmentPeriodBegin() {
            return this.shipmentPeriodBegin;
        }

        public void setShipmentPeriodBegin(Date shipmentPeriodBegin) {
            this.shipmentPeriodBegin = shipmentPeriodBegin;
        }

        public Date getShipmentPeriodEnd() {
            return this.shipmentPeriodEnd;
        }

        public void setShipmentPeriodEnd(Date shipmentPeriodEnd) {
            this.shipmentPeriodEnd = shipmentPeriodEnd;
        }

        public List<FopComponentHolder> getFopComponentsHolders() {
            return this.fopComponentsHolders;
        }
    }

    public static class FopComponentHolder {
        private GeneralProductContractRelationData contractRelation;
        private GeneralProductFop fop;
        private FopComponent fopComponent;

        public GeneralProductContractRelationData getContractRelation() {
            return this.contractRelation;
        }

        public void setContractRelation(GeneralProductContractRelationData contractRelation) {
            this.contractRelation = contractRelation;
        }

        public GeneralProductFop getFop() {
            return this.fop;
        }

        public void setFop(GeneralProductFop fop) {
            this.fop = fop;
        }

        public FopComponent getFopComponent() {
            return this.fopComponent;
        }

        public void setFopComponent(FopComponent fopComponent) {
            this.fopComponent = fopComponent;
        }
    }

    public static class ShipmentHoldersBatch {
        private FinanceDocumentType type;
        private EntityReference<TemplateDocument> template;
        private BillingItemIncludeMode billingItemIncludeMode;
        private VatViewMode vatViewMode;
        private boolean useDelegate;
        private boolean useFacsimile;
        private boolean groupByTraveller;
        private boolean notGroupByProduct;
        private Boolean mergeBillingItems;
        private String captionTemplate;
        private final Collection<ShipmentHolder> shipmentHolders = new ArrayList<ShipmentHolder>();
        private boolean disableCustomerQuotes;
        private boolean displayContract;
        private boolean notDisplayTitleContractNumber;
        private boolean notGroupByServiceType;
        private boolean invertSign;
        private boolean vendorDocument;
        private EntityReference<Organization> vendor;
        private VendorFinanceDocumentData vendorFinanceDocumentData;
        private UniversalDocumentStatus universalDocumentStatus;
        private Map<String, String> customParameters = new HashMap<String, String>();

        public FinanceDocumentType getType() {
            return this.type;
        }

        public void setType(FinanceDocumentType type) {
            this.type = type;
        }

        public EntityReference<TemplateDocument> getTemplate() {
            return this.template;
        }

        public void setTemplate(EntityReference<TemplateDocument> template) {
            this.template = template;
        }

        public boolean isUseDelegate() {
            return this.useDelegate;
        }

        public void setUseDelegate(boolean useDelegate) {
            this.useDelegate = useDelegate;
        }

        public boolean isUseFacsimile() {
            return this.useFacsimile;
        }

        public void setUseFacsimile(boolean useFacsimile) {
            this.useFacsimile = useFacsimile;
        }

        public BillingItemIncludeMode getBillingItemIncludeMode() {
            return this.billingItemIncludeMode;
        }

        public void setBillingItemIncludeMode(BillingItemIncludeMode billingItemIncludeMode) {
            this.billingItemIncludeMode = billingItemIncludeMode;
        }

        public VatViewMode getVatViewMode() {
            return this.vatViewMode;
        }

        public void setVatViewMode(VatViewMode vatViewMode) {
            this.vatViewMode = vatViewMode;
        }

        public boolean isGroupByTraveller() {
            return this.groupByTraveller;
        }

        public boolean isDisableCustomerQuotes() {
            return this.disableCustomerQuotes;
        }

        public boolean isNotGroupByProduct() {
            return this.notGroupByProduct;
        }

        public void setNotGroupByProduct(boolean notGroupByProduct) {
            this.notGroupByProduct = notGroupByProduct;
        }

        public void setGroupByTraveller(boolean groupByTraveller) {
            this.groupByTraveller = groupByTraveller;
        }

        public void setDisableCustomerQuotes(boolean disableCustomerQuotes) {
            this.disableCustomerQuotes = disableCustomerQuotes;
        }

        public boolean isDisplayContract() {
            return this.displayContract;
        }

        public void setDisplayContract(boolean displayContract) {
            this.displayContract = displayContract;
        }

        public boolean isNotDisplayTitleContractNumber() {
            return this.notDisplayTitleContractNumber;
        }

        public void setNotDisplayTitleContractNumber(boolean notDisplayTitleContractNumber) {
            this.notDisplayTitleContractNumber = notDisplayTitleContractNumber;
        }

        public boolean isNotGroupByServiceType() {
            return this.notGroupByServiceType;
        }

        public void setNotGroupByServiceType(boolean notGroupByServiceType) {
            this.notGroupByServiceType = notGroupByServiceType;
        }

        public boolean isInvertSign() {
            return this.invertSign;
        }

        public void setInvertSign(boolean invertSign) {
            this.invertSign = invertSign;
        }

        public boolean isVendorDocument() {
            return this.vendorDocument;
        }

        public void setVendorDocument(boolean vendorDocument) {
            this.vendorDocument = vendorDocument;
        }

        public EntityReference<Organization> getVendor() {
            return this.vendor;
        }

        public void setVendor(EntityReference<Organization> vendor) {
            this.vendor = vendor;
        }

        public VendorFinanceDocumentData getVendorFinanceDocumentData() {
            return this.vendorFinanceDocumentData;
        }

        public void setVendorFinanceDocumentData(VendorFinanceDocumentData vendorFinanceDocumentData) {
            this.vendorFinanceDocumentData = vendorFinanceDocumentData;
        }

        public Boolean getMergeBillingItems() {
            return this.mergeBillingItems;
        }

        public void setMergeBillingItems(Boolean mergeBillingItems) {
            this.mergeBillingItems = mergeBillingItems;
        }

        public String getCaptionTemplate() {
            return this.captionTemplate;
        }

        public void setCaptionTemplate(String captionTemplate) {
            this.captionTemplate = captionTemplate;
        }

        public UniversalDocumentStatus getUniversalDocumentStatus() {
            return this.universalDocumentStatus;
        }

        public void setUniversalDocumentStatus(UniversalDocumentStatus universalDocumentStatus) {
            this.universalDocumentStatus = universalDocumentStatus;
        }

        public Collection<ShipmentHolder> getShipmentHolders() {
            return this.shipmentHolders;
        }

        public Map<String, String> getCustomParameters() {
            return this.customParameters;
        }
    }

    public static class ShipmentsBatch {
        private EntityReference<Organization> supplier;
        private EntityReference<Organization> customer;
        private EntityReference<? extends BaseProfile> payer;
        private EntityReference<Contract> contract;
        private DictionaryReference<CurrencyInfo> currency;
        private EntityReference<BookingFile> bookingFile;
        private NestedEntityReference<BookingFile, BaseProduct> product;
        private EntityReference<Person> agent;
        private Date periodBegin;
        private Date periodEnd;
        private String paymentCode;
        private final List<CostCode> costCodes = new ArrayList<CostCode>();
        private final Set<DictionaryReference<ShipmentCategory>> categories = new HashSet<DictionaryReference<ShipmentCategory>>();
        private final List<EntityContainer<Shipment>> shipments = new ArrayList<EntityContainer<Shipment>>();

        public EntityReference<Organization> getSupplier() {
            return this.supplier;
        }

        public void setSupplier(EntityReference<Organization> supplier) {
            this.supplier = supplier;
        }

        public EntityReference<Organization> getCustomer() {
            return this.customer;
        }

        public void setCustomer(EntityReference<Organization> customer) {
            this.customer = customer;
        }

        public EntityReference<? extends BaseProfile> getPayer() {
            return this.payer;
        }

        public void setPayer(EntityReference<? extends BaseProfile> payer) {
            this.payer = payer;
        }

        public EntityReference<Contract> getContract() {
            return this.contract;
        }

        public void setContract(EntityReference<Contract> contract) {
            this.contract = contract;
        }

        public DictionaryReference<CurrencyInfo> getCurrency() {
            return this.currency;
        }

        public void setCurrency(DictionaryReference<CurrencyInfo> currency) {
            this.currency = currency;
        }

        public EntityReference<BookingFile> getBookingFile() {
            return this.bookingFile;
        }

        public void setBookingFile(EntityReference<BookingFile> bookingFile) {
            this.bookingFile = bookingFile;
        }

        public NestedEntityReference<BookingFile, BaseProduct> getProduct() {
            return this.product;
        }

        public void setProduct(NestedEntityReference<BookingFile, BaseProduct> product) {
            this.product = product;
        }

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public void setAgent(EntityReference<Person> agent) {
            this.agent = agent;
        }

        public Date getPeriodBegin() {
            return this.periodBegin;
        }

        public void setPeriodBegin(Date periodBegin) {
            this.periodBegin = periodBegin;
        }

        public Date getPeriodEnd() {
            return this.periodEnd;
        }

        public void setPeriodEnd(Date periodEnd) {
            this.periodEnd = periodEnd;
        }

        public String getPaymentCode() {
            return this.paymentCode;
        }

        public void setPaymentCode(String paymentCode) {
            this.paymentCode = paymentCode;
        }

        public List<CostCode> getCostCodes() {
            return this.costCodes;
        }

        public Set<DictionaryReference<ShipmentCategory>> getCategories() {
            return this.categories;
        }

        public List<EntityContainer<Shipment>> getShipments() {
            return this.shipments;
        }
    }
}

