/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.create;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNameHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNumberHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCreateConsolidatedFinanceDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Organization organization;
        Optional<BankAccount> optionalBankAccount;
        EntityContainer organizationCtr;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Date date = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATE);
        Collection financeDocumentReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES);
        Collection financeDocumentContainers = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINERS);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        FinanceDocumentsIbusHelper.ShipmentHoldersBatch shipmentHoldersBatch = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCH);
        boolean useDelegate = FinanceDocumentsIbusHelper.isUseDelegate(context, shipmentHoldersBatch);
        boolean useFacsimile = FinanceDocumentsIbusHelper.isUseFacsimile(context, shipmentHoldersBatch);
        boolean vendorDocument = shipmentHoldersBatch.isVendorDocument();
        String captionTemplate = shipmentHoldersBatch.getCaptionTemplate();
        EntityReference<Organization> supplier = shipmentsBatch.getSupplier();
        EntityReference<Organization> customer = shipmentsBatch.getCustomer();
        EntityReference<? extends BaseProfile> payer = shipmentsBatch.getPayer();
        EntityReference<Contract> contract = shipmentsBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = shipmentsBatch.getCurrency();
        FinanceDocumentType type = shipmentHoldersBatch.getType();
        UniversalDocumentStatus universalDocumentStatus = shipmentHoldersBatch.getUniversalDocumentStatus();
        EntityReference<TemplateDocument> template = shipmentHoldersBatch.getTemplate();
        BillingItemIncludeMode billingItemIncludeMode = shipmentHoldersBatch.getBillingItemIncludeMode();
        VatViewMode vatViewMode = shipmentHoldersBatch.getVatViewMode();
        boolean groupByTraveller = shipmentHoldersBatch.isGroupByTraveller();
        boolean notGroupByProduct = shipmentHoldersBatch.isNotGroupByProduct();
        Boolean mergeBillingItems = shipmentHoldersBatch.getMergeBillingItems();
        boolean disableCustomerQuotes = shipmentHoldersBatch.isDisableCustomerQuotes();
        boolean displayContract = shipmentHoldersBatch.isDisplayContract();
        boolean notDisplayTitleContractNumber = shipmentHoldersBatch.isNotDisplayTitleContractNumber();
        boolean notGroupByServiceType = shipmentHoldersBatch.isNotGroupByServiceType();
        boolean invertSign = shipmentHoldersBatch.isInvertSign();
        Map<String, String> customParameters = shipmentHoldersBatch.getCustomParameters();
        VendorFinanceDocumentData vendorFinanceDocumentData = shipmentHoldersBatch.getVendorFinanceDocumentData();
        HashSet vendorFinanceDocumentsData = new HashSet();
        Collection<ShipmentHolder> shipmentHolders = shipmentHoldersBatch.getShipmentHolders();
        EntityReference agent = ProfileHelper.getCurrentUser();
        NestedEntityReference supplierBankAccount = FinanceDocumentsIbusHelper.getBankAccount((EntityContainer<Contract>)EntityStorage.get().resolve(contract));
        if (vendorDocument && (supplierBankAccount = FinanceDocumentsIbusHelper.getBankAccount(supplier = shipmentHoldersBatch.getVendor())) == null && (organizationCtr = EntityStorage.get().resolve(supplier)) != null && (optionalBankAccount = (organization = (Organization)organizationCtr.getEntity()).getBankAccounts().stream().filter(item -> TextUtil.nonBlank((String)item.getSettlementAccount()) && TextUtil.nonBlank((String)item.getCurrency())).findFirst()).isPresent()) {
            supplierBankAccount = new NestedEntityReference(organizationCtr, (BaseEntity)optionalBankAccount.get());
        }
        NestedEntityReference<Organization, BankAccount> payerBankAccount = FinanceDocumentsIbusHelper.getBankAccount(customer);
        HashSet<EntityContainer> relatedShipmentContainers = new HashSet<EntityContainer>();
        HashSet relatedBillingItemReferences = new HashSet();
        for (ShipmentHolder shipmentHolder : shipmentHolders) {
            ArrayList<NestedEntityReference> billingItemReferences = new ArrayList<NestedEntityReference>();
            Map<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem> billingItemMap = FinanceDocumentHelper.getBillingItemsMap(((Shipment)shipmentHolder.getShipment().getEntity()).getBillingItems(), storageContext);
            for (NestedEntityReference billingItemReference : ((Shipment)shipmentHolder.getShipment().getEntity()).getBillingItems()) {
                EntityContainer vendorContract;
                EntityReference vendorContractRef;
                GeneralProductContractRelationData contractRelation;
                BaseProduct product;
                BillingItem billingItem = billingItemMap.get(billingItemReference);
                if (billingItem == null || !MiscUtil.equals((Object)shipmentHolder.getNomenclature(), (Object)billingItem.getNomenclature()) || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext)) == null) continue;
                EntityReference vendor = GeneralProductHelper.getSupplier((BaseProduct)product);
                if (!MiscUtil.equals((Object)shipmentHolder.getVendor(), (Object)vendor)) continue;
                if (product instanceof HotelProduct) {
                    HotelProvider hotelProvider = ((HotelProduct)product).getProvider();
                    Double hotelVatRate = HotelProductHelper.getHotelVatRate((HotelProduct)((HotelProduct)product));
                    if (!MiscUtil.equals((Object)shipmentHolder.getHotelProvider(), (Object)hotelProvider) || !MiscUtil.equals((Object)shipmentHolder.getHotelVatRate(), (Object)hotelVatRate)) continue;
                }
                if ((contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product)) != null && (vendorContractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (vendorContract = EntityStorage.get().resolve(vendorContractRef)) != null) {
                    AgreementType agreementType = ((Contract)vendorContract.getEntity()).getAgreementType();
                    if (!MiscUtil.equals((Object)shipmentHolder.getVendorAgreementType(), (Object)agreementType)) continue;
                }
                if (vendorDocument) {
                    Set vendorDatas = product.getVendorFinanceDocumentsData().stream().filter(item -> vendorFinanceDocumentData.getType().equals((Object)item.getType())).filter(item -> vendorFinanceDocumentData.getVendorNumber().equals(item.getVendorNumber())).filter(item -> MiscUtil.compare((Date)vendorFinanceDocumentData.getVendorDate(), (Date)item.getVendorDate()) == 0).collect(Collectors.toSet());
                    if (!shipmentHolder.getVendor().equals((Object)GeneralProductHelper.getSupplier((BaseProduct)product)) || vendorDatas.isEmpty()) continue;
                    vendorFinanceDocumentsData.addAll(vendorDatas);
                }
                if (!ProductHandler.of((BaseProduct)product).isAppropriateBillingItem(product, type, universalDocumentStatus, billingItemIncludeMode, billingItem, Collections.emptyList(), Collections.emptyList())) continue;
                billingItemReferences.add(billingItemReference);
            }
            if (billingItemReferences.size() <= 0) continue;
            relatedShipmentContainers.add(shipmentHolder.getShipment());
            relatedBillingItemReferences.addAll(billingItemReferences);
        }
        if (relatedShipmentContainers.size() > 0 && relatedBillingItemReferences.size() > 0) {
            FinanceDocument financeDocument = new FinanceDocument();
            financeDocument.setType(type);
            financeDocument.setDate(vendorDocument ? vendorFinanceDocumentData.getVendorDate() : date);
            financeDocument.setAgency(shipmentsBatch.getSupplier());
            financeDocument.setSupplier(supplier);
            financeDocument.setCustomer(customer);
            financeDocument.setPayer(payer);
            financeDocument.setContract(contract);
            financeDocument.setCurrency(currency);
            financeDocument.setTemplate(template);
            financeDocument.setAgent(agent);
            financeDocument.setSupplierBankAccount(supplierBankAccount);
            financeDocument.setPayerBankAccount(payerBankAccount);
            financeDocument.setUseDelegate(useDelegate);
            financeDocument.setUseFacsimile(useFacsimile);
            financeDocument.setBillingItemIncludeMode(billingItemIncludeMode);
            financeDocument.setVatViewMode(vatViewMode);
            financeDocument.setGroupByTraveller(groupByTraveller);
            financeDocument.setNotGroupByProduct(notGroupByProduct);
            financeDocument.setMergeBillingItems(mergeBillingItems);
            financeDocument.setDisableCustomerQuotes(disableCustomerQuotes);
            financeDocument.setDisplayContract(displayContract);
            financeDocument.setNotDisplayTitleContractNumber(notDisplayTitleContractNumber);
            financeDocument.setNotGroupByServiceType(notGroupByServiceType);
            financeDocument.setInvertSign(invertSign);
            financeDocument.setVendorDocument(vendorDocument);
            financeDocument.setVendor(shipmentHoldersBatch.getVendor());
            financeDocument.setVendorFinanceDocumentData(vendorFinanceDocumentData);
            financeDocument.setUniversalDocumentStatus(universalDocumentStatus);
            financeDocument.getCustomParameters().putAll(customParameters);
            financeDocument.setCaptionTemplate(captionTemplate);
            financeDocument.getRelatedShipments().clear();
            financeDocument.getRelatedShipments().addAll(relatedShipmentContainers.stream().map(EntityContainer::toReference).collect(Collectors.toList()));
            financeDocument.getBillingItems().clear();
            financeDocument.getBillingItems().addAll(relatedBillingItemReferences);
            FinanceDocumentNumberHelper.generateNumber(financeDocument, storageContext);
            if (vendorDocument) {
                if (TextUtil.isBlank((String)financeDocument.getNumber())) {
                    financeDocument.setNumber(vendorFinanceDocumentData.getVendorNumber());
                }
                vendorFinanceDocumentsData.forEach(item -> {
                    item.setNumber(financeDocument.getNumber());
                    item.setDate(financeDocument.getDate());
                });
            }
            FinanceDocumentNameHelper.generateName(financeDocument);
            EntityContainer financeDocumentContainer = EntityStorageHelper.createContainer((BaseEntity)financeDocument, (EntityStorageContext)storageContext);
            financeDocumentReferences.add(financeDocumentContainer.toReference());
            financeDocumentContainers.add(financeDocumentContainer);
            for (EntityContainer relatedShipmentContainer : relatedShipmentContainers) {
                ((Shipment)relatedShipmentContainer.getEntity()).getFinanceDocuments().add(financeDocumentContainer.toReference());
            }
        }
    }
}

