/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.create;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNameHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNumberHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceDocumentsCreateFinanceDocumentsProcessor
extends BaseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FinanceDocumentsCreateFinanceDocumentsProcessor.class);

    public void process(MessageContext context) throws Exception {
        Organization organization;
        Optional<BankAccount> optionalBankAccount;
        EntityContainer organizationCtr;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Date date = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATE);
        Collection financeDocumentReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES);
        Collection financeDocumentContainers = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINERS);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        FinanceDocumentsIbusHelper.ShipmentHoldersBatch shipmentHoldersBatch = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCH);
        boolean vendorDocument = shipmentHoldersBatch.isVendorDocument();
        VendorFinanceDocumentData vendorFinanceDocumentData = shipmentHoldersBatch.getVendorFinanceDocumentData();
        HashSet vendorFinanceDocumentsData = new HashSet();
        EntityReference<Organization> supplier = shipmentsBatch.getSupplier();
        EntityContainer contract = EntityStorage.get().resolve(shipmentsBatch.getContract());
        NestedEntityReference bankAccount = FinanceDocumentsIbusHelper.getBankAccount((EntityContainer<Contract>)contract);
        if (vendorDocument && (bankAccount = FinanceDocumentsIbusHelper.getBankAccount(supplier = shipmentHoldersBatch.getVendor())) == null && (organizationCtr = EntityStorage.get().resolve(supplier)) != null && (optionalBankAccount = (organization = (Organization)organizationCtr.getEntity()).getBankAccounts().stream().filter(item -> TextUtil.nonBlank((String)item.getSettlementAccount()) && TextUtil.nonBlank((String)item.getCurrency())).findFirst()).isPresent()) {
            bankAccount = new NestedEntityReference(organizationCtr, (BaseEntity)optionalBankAccount.get());
        }
        EntityReference<Organization> customer = shipmentsBatch.getCustomer();
        FinanceDocumentType type = shipmentHoldersBatch.getType();
        UniversalDocumentStatus universalDocumentStatus = shipmentHoldersBatch.getUniversalDocumentStatus();
        BillingItemIncludeMode billingItemIncludeMode = shipmentHoldersBatch.getBillingItemIncludeMode();
        HashMap shipmentHoldersMap = new HashMap();
        shipmentHoldersBatch.getShipmentHolders().forEach(item -> shipmentHoldersMap.computeIfAbsent(item.getShipment(), k -> new ArrayList()).add(item));
        for (Map.Entry entry : shipmentHoldersMap.entrySet()) {
            Object shipmentHolder2;
            EntityContainer shipment = (EntityContainer)entry.getKey();
            List shipmentHolders = (List)entry.getValue();
            HashSet<EntityContainer> relatedShipmentContainers = new HashSet<EntityContainer>();
            HashSet relatedBillingItemReferences = new HashSet();
            HashSet<NestedEntityReference> resultBillingItemReferences = new HashSet<NestedEntityReference>();
            ArrayList<BillingItem> billingItems = new ArrayList<BillingItem>();
            HashSet<NestedEntityReference> billingItemReferences = new HashSet<NestedEntityReference>();
            HashMap<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem> billingItemMap = new HashMap<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem>();
            for (Object shipmentHolder2 : shipmentHolders) {
                billingItemMap.putAll(FinanceDocumentHelper.getBillingItemsMap(((Shipment)shipmentHolder2.getShipment().getEntity()).getBillingItems(), storageContext));
                for (NestedEntityReference billingItemReference : ((Shipment)shipmentHolder2.getShipment().getEntity()).getBillingItems()) {
                    EntityContainer vendorContract;
                    EntityReference vendorContractRef;
                    GeneralProductContractRelationData contractRelation;
                    BaseProduct product;
                    BillingItem billingItem = (BillingItem)billingItemMap.get(billingItemReference);
                    if (billingItem == null || !MiscUtil.equals((Object)shipmentHolder2.getNomenclature(), (Object)billingItem.getNomenclature()) || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext)) == null) continue;
                    EntityReference vendor = GeneralProductHelper.getSupplier((BaseProduct)product);
                    if (!MiscUtil.equals((Object)shipmentHolder2.getVendor(), (Object)vendor)) continue;
                    if (product instanceof HotelProduct) {
                        HotelProvider hotelProvider = ((HotelProduct)product).getProvider();
                        Double hotelVatRate = HotelProductHelper.getHotelVatRate((HotelProduct)((HotelProduct)product));
                        if (!MiscUtil.equals((Object)shipmentHolder2.getHotelProvider(), (Object)hotelProvider) || !MiscUtil.equals((Object)shipmentHolder2.getHotelVatRate(), (Object)hotelVatRate)) continue;
                    }
                    if ((contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product)) != null && (vendorContractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (vendorContract = EntityStorage.get().resolve(vendorContractRef)) != null) {
                        AgreementType agreementType = ((Contract)vendorContract.getEntity()).getAgreementType();
                        if (!MiscUtil.equals((Object)shipmentHolder2.getVendorAgreementType(), (Object)agreementType)) continue;
                    }
                    if (vendorDocument) {
                        Set vendorDatas = product.getVendorFinanceDocumentsData().stream().filter(item -> vendorFinanceDocumentData.getType().equals((Object)item.getType())).filter(item -> vendorFinanceDocumentData.getVendorNumber().equals(item.getVendorNumber())).filter(item -> MiscUtil.compare((Date)vendorFinanceDocumentData.getVendorDate(), (Date)item.getVendorDate()) == 0).collect(Collectors.toSet());
                        if (!shipmentHolder2.getVendor().equals((Object)vendor) || vendorDatas.isEmpty()) continue;
                        vendorFinanceDocumentsData.addAll(vendorDatas);
                    }
                    billingItemReferences.add(billingItemReference);
                    billingItems.add(billingItem);
                }
            }
            HashMap<BaseProduct, List> billingItemsToProducts = new HashMap<BaseProduct, List>();
            shipmentHolder2 = billingItemReferences.iterator();
            while (shipmentHolder2.hasNext()) {
                NestedEntityReference billingItemReference = (NestedEntityReference)shipmentHolder2.next();
                BillingItem billingItem = (BillingItem)billingItemMap.get(billingItemReference);
                BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
                if (product == null) continue;
                List prepaymentBillingItems = billingItemsToProducts.computeIfAbsent(product, p -> product.getPrepaymentDocuments().stream().map(item -> EntityStorageHelper.resolve((EntityReference)item, (EntityStorageContext)storageContext)).filter(Objects::nonNull).flatMap(item -> FinanceDocumentHelper.getBillingItems(((FinanceDocument)item.getEntity()).getBillingItems(), storageContext).stream()).collect(Collectors.toList()));
                if (!ProductHandler.of((BaseProduct)product).isAppropriateBillingItem(product, type, universalDocumentStatus, billingItemIncludeMode, billingItem, billingItems, prepaymentBillingItems)) continue;
                resultBillingItemReferences.add(billingItemReference);
            }
            if (resultBillingItemReferences.size() > 0) {
                relatedShipmentContainers.add(shipment);
                relatedBillingItemReferences.addAll(resultBillingItemReferences);
            }
            if (relatedShipmentContainers.size() <= 0 || relatedBillingItemReferences.size() <= 0) continue;
            FinanceDocument financeDocument = new FinanceDocument();
            financeDocument.setType(type);
            financeDocument.setDate(vendorDocument ? vendorFinanceDocumentData.getVendorDate() : date);
            financeDocument.setAgency(shipmentsBatch.getSupplier());
            financeDocument.setSupplier(supplier);
            financeDocument.setCustomer(customer);
            financeDocument.setPayer(shipmentsBatch.getPayer());
            financeDocument.setContract(shipmentsBatch.getContract());
            financeDocument.setCurrency(shipmentsBatch.getCurrency());
            financeDocument.setTemplate(shipmentHoldersBatch.getTemplate());
            financeDocument.setAgent(ProfileHelper.getCurrentUser());
            financeDocument.setSupplierBankAccount(bankAccount);
            BankAccount payerBankAccount = null;
            if (contract != null) {
                payerBankAccount = this.getClientBankAccountFromContractPreferences((Contract)contract.getEntity());
            }
            financeDocument.setPayerBankAccount(payerBankAccount != null ? new NestedEntityReference(customer, (BaseEntity)payerBankAccount) : FinanceDocumentsIbusHelper.getBankAccount(customer));
            financeDocument.setUseDelegate(FinanceDocumentsIbusHelper.isUseDelegate(context, shipmentHoldersBatch));
            financeDocument.setUseFacsimile(FinanceDocumentsIbusHelper.isUseFacsimile(context, shipmentHoldersBatch));
            financeDocument.setBillingItemIncludeMode(billingItemIncludeMode);
            financeDocument.setVatViewMode(shipmentHoldersBatch.getVatViewMode());
            financeDocument.setGroupByTraveller(shipmentHoldersBatch.isGroupByTraveller());
            financeDocument.setNotGroupByProduct(shipmentHoldersBatch.isNotGroupByProduct());
            financeDocument.setMergeBillingItems(shipmentHoldersBatch.getMergeBillingItems());
            financeDocument.setDisableCustomerQuotes(shipmentHoldersBatch.isDisableCustomerQuotes());
            financeDocument.setDisplayContract(shipmentHoldersBatch.isDisplayContract());
            financeDocument.setNotDisplayTitleContractNumber(shipmentHoldersBatch.isNotDisplayTitleContractNumber());
            financeDocument.setNotGroupByServiceType(shipmentHoldersBatch.isNotGroupByServiceType());
            financeDocument.setInvertSign(shipmentHoldersBatch.isInvertSign());
            financeDocument.setVendorDocument(vendorDocument);
            financeDocument.setVendor(shipmentHoldersBatch.getVendor());
            financeDocument.setVendorFinanceDocumentData(vendorFinanceDocumentData);
            financeDocument.setCaptionTemplate(shipmentHoldersBatch.getCaptionTemplate());
            financeDocument.setUniversalDocumentStatus(universalDocumentStatus);
            financeDocument.getCustomParameters().putAll(shipmentHoldersBatch.getCustomParameters());
            financeDocument.getRelatedShipments().clear();
            financeDocument.getRelatedShipments().addAll(relatedShipmentContainers.stream().map(EntityContainer::toReference).collect(Collectors.toList()));
            financeDocument.getBillingItems().clear();
            financeDocument.getBillingItems().addAll(relatedBillingItemReferences);
            if (vendorDocument) {
                FinanceDocumentNumberHelper.generateNumber(financeDocument, storageContext);
                if (TextUtil.isBlank((String)financeDocument.getNumber())) {
                    financeDocument.setNumber(vendorFinanceDocumentData.getVendorNumber());
                }
                vendorFinanceDocumentsData.forEach(item -> {
                    item.setNumber(financeDocument.getNumber());
                    item.setDate(financeDocument.getDate());
                });
            } else {
                financeDocument.setNumber(((Shipment)shipment.getEntity()).getNumber());
            }
            FinanceDocumentNameHelper.generateName(financeDocument);
            EntityContainer financeDocumentContainer = EntityStorageHelper.createContainer((BaseEntity)financeDocument, (EntityStorageContext)storageContext);
            logger.info(String.format("Finance document container with uid %s created. Shipments uid: %s", financeDocumentContainer.getUid(), ((FinanceDocument)financeDocumentContainer.getEntity()).getRelatedShipments().stream().map(EntityReference::getUid).collect(Collectors.joining(", "))));
            financeDocumentReferences.add(financeDocumentContainer.toReference());
            financeDocumentContainers.add(financeDocumentContainer);
            for (EntityContainer relatedShipmentContainer : relatedShipmentContainers) {
                ((Shipment)relatedShipmentContainer.getEntity()).getFinanceDocuments().add(financeDocumentContainer.toReference());
                logger.info(String.format("Finance document (uid %s) added to shipment (uid %s)", financeDocumentContainer.getUid(), relatedShipmentContainer.getUid()));
            }
        }
    }

    private BankAccount getClientBankAccountFromContractPreferences(Contract contract) {
        BankAccount bankAccount = null;
        if (contract.getClientBankAccount() != null) {
            bankAccount = contract.getClientBankAccount();
        }
        return bankAccount;
    }
}

