/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.create;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCreatePrepaymentDocumentBillingItemsListProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItemHoldersBatch batch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        Set shipmentHoldersBatches = (Set)context.getObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCHES);
        EntityContainer billingItemsListContainer = EntityStorageHelper.createContainer(BillingItemsList.class, null, (EntityStorageContext)storageContext);
        BillingItemsList billingItemsList = (BillingItemsList)billingItemsListContainer.getEntity();
        billingItemsList.getData().addAll(batch.getBillingItemHolders().stream().map(BillingItemHolder::getItem).filter(billingItem -> {
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
            if (product != null) {
                EntityContainer vendorContract;
                EntityReference vendorContractRef;
                EntityReference vendor = GeneralProductHelper.getSupplier((BaseProduct)product);
                HotelProvider hotelProvider = null;
                if (product instanceof HotelProduct) {
                    hotelProvider = ((HotelProduct)product).getProvider();
                }
                AgreementType agreementType = null;
                GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
                if (contractRelation != null && (vendorContractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (vendorContract = EntityStorage.get().resolve(vendorContractRef)) != null) {
                    agreementType = ((Contract)vendorContract.getEntity()).getAgreementType();
                }
                HotelProvider finalHotelProvider = hotelProvider;
                AgreementType finalAgreementType = agreementType;
                Set shipmentHolders = shipmentHoldersBatches.stream().flatMap(item -> item.getShipmentHolders().stream()).filter(item -> MiscUtil.equals((Object)item.getNomenclature(), (Object)billingItem.getNomenclature())).filter(item -> MiscUtil.equals((Object)item.getVendor(), (Object)vendor)).filter(item -> MiscUtil.equals((Object)item.getHotelProvider(), (Object)finalHotelProvider)).filter(item -> MiscUtil.equals((Object)item.getVendorAgreementType(), (Object)finalAgreementType)).collect(Collectors.toSet());
                return !shipmentHolders.isEmpty();
            }
            return true;
        }).collect(Collectors.toList()));
        context.putObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER, (Object)billingItemsListContainer);
    }
}

