/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.create;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNameHelper;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNumberHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCreatePrepaymentDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Organization organization;
        Optional<BankAccount> optionalBankAccount;
        EntityContainer organizationCtr;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Date date = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATE);
        Collection financeDocumentReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        FinanceDocumentsIbusHelper.ShipmentHoldersBatch fakeShipmentHoldersBatch = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCH);
        boolean useDelegate = FinanceDocumentsIbusHelper.isUseDelegate(context, fakeShipmentHoldersBatch);
        boolean useFacsimile = FinanceDocumentsIbusHelper.isUseFacsimile(context, fakeShipmentHoldersBatch);
        boolean vendorDocument = fakeShipmentHoldersBatch.isVendorDocument();
        UniversalDocumentStatus universalDocumentStatus = fakeShipmentHoldersBatch.getUniversalDocumentStatus();
        String captionTemplate = fakeShipmentHoldersBatch.getCaptionTemplate();
        EntityReference<Organization> supplier = productHoldersBatch.getSupplier();
        EntityReference<Organization> customer = productHoldersBatch.getCustomer();
        EntityReference<Organization> payer = productHoldersBatch.getPayer();
        EntityReference<Contract> contract = productHoldersBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = productHoldersBatch.getCurrency();
        FinanceDocumentType type = fakeShipmentHoldersBatch.getType();
        EntityReference<TemplateDocument> template = fakeShipmentHoldersBatch.getTemplate();
        BillingItemIncludeMode billingItemIncludeMode = fakeShipmentHoldersBatch.getBillingItemIncludeMode();
        VatViewMode vatViewMode = fakeShipmentHoldersBatch.getVatViewMode();
        boolean groupByTraveller = fakeShipmentHoldersBatch.isGroupByTraveller();
        boolean notGroupByProduct = fakeShipmentHoldersBatch.isNotGroupByProduct();
        Boolean mergeBillingItems = fakeShipmentHoldersBatch.getMergeBillingItems();
        boolean disableCustomerQuotes = fakeShipmentHoldersBatch.isDisableCustomerQuotes();
        boolean displayContract = fakeShipmentHoldersBatch.isDisplayContract();
        boolean notDisplayTitleContractNumber = fakeShipmentHoldersBatch.isNotDisplayTitleContractNumber();
        boolean notGroupByServiceType = fakeShipmentHoldersBatch.isNotGroupByServiceType();
        boolean invertSign = fakeShipmentHoldersBatch.isInvertSign();
        Map<String, String> customParameters = fakeShipmentHoldersBatch.getCustomParameters();
        VendorFinanceDocumentData vendorFinanceDocumentData = fakeShipmentHoldersBatch.getVendorFinanceDocumentData();
        HashSet vendorFinanceDocumentsData = new HashSet();
        EntityReference agent = ProfileHelper.getCurrentUser();
        NestedEntityReference supplierBankAccount = FinanceDocumentsIbusHelper.getBankAccount((EntityContainer<Contract>)EntityStorage.get().resolve(contract));
        if (vendorDocument && (supplierBankAccount = FinanceDocumentsIbusHelper.getBankAccount(supplier = fakeShipmentHoldersBatch.getVendor())) == null && (organizationCtr = EntityStorage.get().resolve(supplier)) != null && (optionalBankAccount = (organization = (Organization)organizationCtr.getEntity()).getBankAccounts().stream().filter(item -> TextUtil.nonBlank((String)item.getSettlementAccount()) && TextUtil.nonBlank((String)item.getCurrency())).findFirst()).isPresent()) {
            supplierBankAccount = new NestedEntityReference(organizationCtr, (BaseEntity)optionalBankAccount.get());
        }
        NestedEntityReference<Organization, BankAccount> payerBankAccount = FinanceDocumentsIbusHelper.getBankAccount(customer);
        ArrayList relatedBillingItemReferences = new ArrayList();
        ArrayList<NestedEntityReference> billingItemReferences = new ArrayList<NestedEntityReference>();
        HashSet<BaseProduct> products = new HashSet<BaseProduct>();
        Set nomenclatures = fakeShipmentHoldersBatch.getShipmentHolders().stream().map(ShipmentHolder::getNomenclature).collect(Collectors.toSet());
        for (BillingItem billingItem : ((BillingItemsList)billingItemsListContainer.getEntity()).getData()) {
            EntityContainer vendorContract;
            EntityReference vendorContractRef;
            NestedEntityReference billingItemReference = new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem);
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
            if (product == null) continue;
            EntityReference vendor = GeneralProductHelper.getSupplier((BaseProduct)product);
            HotelProvider hotelProvider = null;
            if (product instanceof HotelProduct) {
                hotelProvider = ((HotelProduct)product).getProvider();
            }
            AgreementType agreementType = null;
            GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
            if (contractRelation != null && (vendorContractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (vendorContract = EntityStorage.get().resolve(vendorContractRef)) != null) {
                agreementType = ((Contract)vendorContract.getEntity()).getAgreementType();
            }
            HotelProvider finalHotelProvider = hotelProvider;
            AgreementType finalAgreementType = agreementType;
            Set shipmentHolders = fakeShipmentHoldersBatch.getShipmentHolders().stream().filter(item -> MiscUtil.equals((Object)item.getNomenclature(), (Object)billingItem.getNomenclature())).filter(item -> MiscUtil.equals((Object)item.getVendor(), (Object)vendor)).filter(item -> MiscUtil.equals((Object)item.getHotelProvider(), (Object)finalHotelProvider)).filter(item -> MiscUtil.equals((Object)item.getVendorAgreementType(), (Object)finalAgreementType)).collect(Collectors.toSet());
            if (shipmentHolders.isEmpty()) continue;
            if (vendorDocument) {
                Set vendorDatas = product.getVendorFinanceDocumentsData().stream().filter(item -> vendorFinanceDocumentData.getType().equals((Object)item.getType())).filter(item -> vendorFinanceDocumentData.getVendorNumber().equals(item.getVendorNumber())).filter(item -> MiscUtil.compare((Date)vendorFinanceDocumentData.getVendorDate(), (Date)item.getVendorDate()) == 0).collect(Collectors.toSet());
                if (!fakeShipmentHoldersBatch.getVendor().equals((Object)GeneralProductHelper.getSupplier((BaseProduct)product)) || vendorDatas.isEmpty()) continue;
                vendorFinanceDocumentsData.addAll(vendorDatas);
            }
            if (!ProductHandler.of((BaseProduct)product).isAppropriateBillingItem(product, type, universalDocumentStatus, billingItemIncludeMode, billingItem, Collections.emptyList(), Collections.emptyList())) continue;
            billingItemReferences.add(billingItemReference);
            products.add(product);
        }
        if (billingItemReferences.size() > 0) {
            relatedBillingItemReferences.addAll(billingItemReferences);
        }
        if (relatedBillingItemReferences.size() > 0) {
            FinanceDocument financeDocument = new FinanceDocument();
            financeDocument.setType(type);
            financeDocument.setDate(date);
            financeDocument.setAgency(productHoldersBatch.getSupplier());
            financeDocument.setSupplier(supplier);
            financeDocument.setCustomer(customer);
            financeDocument.setPayer(payer);
            financeDocument.setContract(contract);
            financeDocument.setCurrency(currency);
            financeDocument.setTemplate(template);
            financeDocument.setAgent(agent);
            financeDocument.setSupplierBankAccount(supplierBankAccount);
            financeDocument.setPayerBankAccount(payerBankAccount);
            financeDocument.setUseDelegate(useDelegate);
            financeDocument.setUseFacsimile(useFacsimile);
            financeDocument.setBillingItemIncludeMode(billingItemIncludeMode);
            financeDocument.setVatViewMode(vatViewMode);
            financeDocument.setGroupByTraveller(groupByTraveller);
            financeDocument.setNotGroupByProduct(notGroupByProduct);
            financeDocument.setMergeBillingItems(mergeBillingItems);
            financeDocument.setDisableCustomerQuotes(disableCustomerQuotes);
            financeDocument.setDisplayContract(displayContract);
            financeDocument.setNotDisplayTitleContractNumber(notDisplayTitleContractNumber);
            financeDocument.setNotGroupByServiceType(notGroupByServiceType);
            financeDocument.setInvertSign(invertSign);
            financeDocument.setVendorDocument(vendorDocument);
            financeDocument.setVendor(fakeShipmentHoldersBatch.getVendor());
            financeDocument.setVendorFinanceDocumentData(vendorFinanceDocumentData);
            financeDocument.setUniversalDocumentStatus(universalDocumentStatus);
            financeDocument.getCustomParameters().putAll(customParameters);
            financeDocument.setCaptionTemplate(captionTemplate);
            financeDocument.getBillingItems().clear();
            financeDocument.getBillingItems().addAll(relatedBillingItemReferences);
            FinanceDocumentNumberHelper.generateNumber(financeDocument, storageContext);
            if (vendorDocument) {
                if (TextUtil.isBlank((String)financeDocument.getNumber())) {
                    financeDocument.setNumber(vendorFinanceDocumentData.getVendorNumber());
                }
                vendorFinanceDocumentsData.forEach(item -> {
                    item.setNumber(financeDocument.getNumber());
                    item.setDate(financeDocument.getDate());
                });
            }
            FinanceDocumentNameHelper.generateName(financeDocument);
            EntityContainer financeDocumentContainer = EntityStorageHelper.createContainer((BaseEntity)financeDocument, (EntityStorageContext)storageContext);
            EntityReference financeDocumentReference = financeDocumentContainer.toReference();
            financeDocumentReferences.add(financeDocumentReference);
            List productHolders = productHoldersBatch.getProductHolders().stream().filter(item -> products.contains(item.getProduct())).filter(item -> item.getFopComponentsHolders().stream().anyMatch(componentHolder -> nomenclatures.contains(componentHolder.getFopComponent().getNomenclature()))).collect(Collectors.toList());
            for (FinanceDocumentsIbusHelper.ProductHolder productHolder : productHolders) {
                if (productHolder.getProduct().getPrepaymentDocuments().contains(financeDocumentReference)) continue;
                productHolder.getProduct().getPrepaymentDocuments().add(financeDocumentReference);
            }
        }
    }
}

