/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.create;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class FinanceDocumentsCreatePrepaymentLockAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        Collection productReferences = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_REFERENCES);
        ArrayList<NamedLock> namedLocks = new ArrayList<NamedLock>();
        try {
            Set bookingFileReferences = productReferences.stream().map(productReference -> new EntityReference(productReference.getUid(), productReference.getType(), null)).collect(Collectors.toCollection(LinkedHashSet::new));
            for (EntityReference reference : bookingFileReferences) {
                namedLocks.add(this.lock((EntityReference<BookingFile>)reference));
            }
            ctx.putObject((Enum)IBusFinanceContextKeys.LOCKS_LIST, namedLocks);
        }
        catch (Throwable t) {
            for (NamedLock namedLock : namedLocks) {
                this.unlock(namedLock);
            }
            throw t;
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Collection namedLocks = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.LOCKS_LIST);
        for (NamedLock namedLock : namedLocks) {
            this.unlock(namedLock);
        }
        ctx.removeObject((Enum)IBusFinanceContextKeys.LOCKS_LIST);
    }

    private NamedLock lock(EntityReference<BookingFile> reference) throws Exception {
        NamedLock namedLock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey(reference), TimeUnit.MINUTES.toMillis(5L));
        if (!namedLock.tryLock(5L, TimeUnit.MINUTES)) {
            throw new Exception("unable to get lock for " + namedLock.getName());
        }
        return namedLock;
    }

    private void unlock(NamedLock lock) {
        try {
            lock.unlock();
        }
        catch (Exception e) {
            this.log.error("unable to unlock " + lock.getName(), (Throwable)e);
        }
        finally {
            try {
                lock.close();
            }
            catch (Exception e) {
                this.log.error("unable to close lock for " + lock.getName(), (Throwable)e);
            }
        }
    }
}

