/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.delete;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class FinanceDocumentsDeleteUpdateProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        BaseProduct product;
        NestedEntityReference productReference;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer financeDocumentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        NestedEntityReference billingItemReference = (NestedEntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_REFERENCE);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        EntityReference financeDocumentReference = financeDocumentContainer.toReference();
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        VendorFinanceDocumentData vendorFinanceDocumentData = financeDocument.getVendorFinanceDocumentData();
        EntityReference vendor = financeDocument.getVendor();
        boolean prepayment = FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)financeDocument.getType());
        BillingItem billingItem = ((BillingItemsList)billingItemsListContainer.getEntity()).getData().stream().filter(item -> item.getUid().equals(billingItemReference.getNestedEntityUid())).findFirst().orElse(null);
        if (billingItem != null && (productReference = billingItem.getProduct()) != null && (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productReference, (EntityStorageContext)storageContext)) != null) {
            if (prepayment) {
                product.getPrepaymentDocuments().remove(financeDocumentReference);
            }
            if (financeDocument.isVendorDocument() && product.getVendorFinanceDocumentsData() != null && vendor != null && vendor.equals((Object)GeneralProductHelper.getSupplier((BaseProduct)product))) {
                product.getVendorFinanceDocumentsData().stream().filter(item -> item.getType() == vendorFinanceDocumentData.getType() && TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorNumber().equals(vendorFinanceDocumentData.getVendorNumber()) && MiscUtil.compare((Date)item.getVendorDate(), (Date)vendorFinanceDocumentData.getVendorDate()) == 0).forEach(item -> {
                    item.setNumber(null);
                    item.setDate(null);
                    item.setSequenceNumber(null);
                });
            }
        }
    }
}

