/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.detach;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsDetachPrepaymentDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityReference prepaymentDocumentReference = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_REFERENCE);
        EntityContainer prepaymentDocumentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_CONTAINER);
        EntityReference shipmentReference = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_REFERENCE);
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        FinanceDocument prepaymentDocument = (FinanceDocument)prepaymentDocumentContainer.getEntity();
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        shipment.getPrepaymentFinanceDocuments().remove(prepaymentDocumentReference);
        prepaymentDocument.getRelatedShipments().remove(shipmentReference);
        Set paymentItems = prepaymentDocument.getPaymentItems().stream().filter(shipment.getPaymentItems()::contains).collect(Collectors.toSet());
        shipment.getPaymentItems().removeAll(paymentItems);
        for (EntityReference orderReference : prepaymentDocument.getPaymentDocuments()) {
            EntityContainer orderContainer = EntityStorageHelper.resolve((EntityReference)orderReference, (EntityStorageContext)storageContext);
            if (orderContainer == null || !shipment.getPaymentItems().stream().noneMatch(((BasePaymentDocument)orderContainer.getEntity()).getPaymentItems()::contains)) continue;
            shipment.getPaymentDocuments().remove(orderReference);
            ((BasePaymentDocument)orderContainer.getEntity()).getRelatedShipments().remove(shipmentReference);
        }
        for (EntityReference financeDocumentReference : shipment.getFinanceDocuments()) {
            EntityContainer financeDocumentContainer = EntityStorageHelper.resolve((EntityReference)financeDocumentReference, (EntityStorageContext)storageContext);
            if (financeDocumentContainer == null) continue;
            ((FinanceDocument)financeDocumentContainer.getEntity()).getPaymentItems().removeAll(paymentItems);
            for (EntityReference orderReference : prepaymentDocument.getPaymentDocuments()) {
                EntityContainer orderContainer = EntityStorageHelper.resolve((EntityReference)orderReference, (EntityStorageContext)storageContext);
                if (orderContainer == null || !((FinanceDocument)financeDocumentContainer.getEntity()).getPaymentItems().stream().noneMatch(((BasePaymentDocument)orderContainer.getEntity()).getPaymentItems()::contains)) continue;
                ((FinanceDocument)financeDocumentContainer.getEntity()).getPaymentDocuments().remove(orderReference);
                ((BasePaymentDocument)orderContainer.getEntity()).getFinanceDocuments().remove(financeDocumentReference);
            }
        }
    }
}

