/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.render;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class FinanceDocumentsRenderFillDataSourceCommonProcessor
extends BaseProcessor {
    private static final String FIELD_BILLING_ITEM_NUMBER = "NUMBER";
    private static final String FIELD_BILLING_ITEM_NAME = "NAME";
    private static final String FIELD_BILLING_ITEM_COUNT = "COUNT";
    private static final String FIELD_BILLING_ITEM_QUANTITY = "QUANTITY";
    private static final String FIELD_BILLING_ITEM_VAT = "VAT";
    private static final String FIELD_BILLING_ITEM_VAT_AMOUNT = "VAT_AMOUNT";
    private static final String FIELD_BILLING_ITEM_VAT_WITHOUT_FEES = "VAT_WITHOUT_FEES";
    private static final String FIELD_BILLING_ITEM_FIRST_PRODUCT_VAT = "FIRST_PRODUCT_VAT";
    private static final String FIELD_BILLING_ITEM_FIRST_PRODUCT_MAX_VAT_PERCENT = "FIRST_PRODUCT_MAX_VAT_PERCENT";
    private static final String FIELD_BILLING_ITEM_VAT_PERCENT = "VAT_PERCENT";
    private static final String FIELD_BILLING_ITEM_MAX_VAT_PERCENT = "MAX_VAT_PERCENT";
    private static final String FIELD_BILLING_ITEM_TOTAL = "TOTAL";
    private static final String FIELD_BILLING_ITEM_TOTAL_AMOUNT = "TOTAL_AMOUNT";
    private static final String FIELD_BILLING_ITEM_TOTAL_WITHOUT_FEES = "TOTAL_WITHOUT_FEES";
    private static final String FIELD_BILLING_ITEM_FIRST_PRODUCT_TOTAL = "FIRST_PRODUCT_TOTAL";
    private static final String FIELD_BILLING_ITEM_FEE_TOTAL = "FEE_TOTAL";
    private static final String FIELD_BILLING_ITEM_FEE_VAT = "FEE_VAT";
    private static final String FIELD_BILLING_ITEM_IS_SERVICE = "IS_SERVICE";
    private static final String FIELD_IS_OWN_FEES = "IS_OWN_FEES";
    private static final String FIELD_BILLING_ITEM_IS_VAT = "IS_VAT";
    private static final String FIELD_BILLING_ITEM_IS_REFUND = "IS_REFUND";
    private static final String FIELD_BILLING_ITEM_IS_PENALTY = "IS_PENALTY";
    private static final String FIELD_BILLING_ITEM_ISSUE_DATE = "ISSUE_DATE";
    private static final String FIELD_SHIPMENT_NUMBER = "SHIPMENT_NUMBER";
    private static final String FIELD_SHIPMENT_DATE = "SHIPMENT_DATE";
    private static final String FIELD_COST_CODES = "COST_CODES";
    private static final String FIELD_PRODUCT_COST_CODES_MAP = "PRODUCT_COST_CODES_MAP";
    private static final String IS_HOTEL_PRODUCT = "IS_HOTEL_PRODUCT";
    private static final String BOOKING_FILE_NUMBER = "BOOKING_FILE_NUMBER";
    private static final String BOOKING_FILE_CREATE_DATE = "BOOKING_FILE_CREATE_DATE";
    private static final String FIELD_PRODUCT_START_DATE = "PRODUCT_START_DATE";
    private static final String FIELD_PRODUCT_END_DATE = "PRODUCT_END_DATE";
    private static final String FIELD_PRODUCT_PENALTY = "PRODUCT_PENALTY";
    private static final String FIELD_PRODUCT_EQUIVALENT_FARE_AMOUNT = "PRODUCT_EQUIVALENT_FARE_AMOUNT";
    private static final String FIELD_PRODUCT_EQUIVALENT_TAXES_AMOUNT = "PRODUCT_EQUIVALENT_TAXES_AMOUNT";
    private static final String FIELD_FIRST_PRODUCT_EQUIVALENT_FARE_AMOUNT = "FIRST_PRODUCT_EQUIVALENT_FARE_AMOUNT";
    private static final String FIELD_FIRST_PRODUCT_EQUIVALENT_TAXES_AMOUNT = "FIRST_PRODUCT_EQUIVALENT_TAXES_AMOUNT";
    private static final String FIELD_FIRST_PRODUCT_HIDDEN_FEES_AMOUNT = "FIRST_PRODUCT_HIDDEN_FEES_AMOUNT";

    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        FinanceDocument document = (FinanceDocument)documentContainer.getEntity();
        List dataSource = (List)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATA_SOURCE);
        Locale locale = (Locale)context.getMandatoryObject((Enum)IBusFinanceContextKeys.LOCALE);
        Boolean hasColumnVatRate = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.HAS_COLUMN_VAT_RATE);
        Boolean noPenaltyVat = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.NO_PENALTY_VAT);
        if (document.getType() == FinanceDocumentType.CASH_ORDER) {
            return;
        }
        List<CostCodeProperties> customerCostCodeProperties = this.getCustomerCostCodeProperties(document, storageContext);
        Collection<FinanceDocumentsIbusHelper.MergedBillingItem> mergedBillingItems = FinanceDocumentsIbusHelper.prepareBillingItems(document, hasColumnVatRate, noPenaltyVat, locale, storageContext);
        AtomicInteger count = new AtomicInteger();
        for (FinanceDocumentsIbusHelper.MergedBillingItem mergedBillingItem : mergedBillingItems) {
            this.fillData(count, storageContext, document, dataSource, hasColumnVatRate, customerCostCodeProperties, mergedBillingItem);
        }
    }

    private void fillData(AtomicInteger count, EntityStorageContext storageContext, FinanceDocument document, List<Map<String, ?>> dataSource, Boolean hasColumnVatRate, List<CostCodeProperties> customerCostCodeProperties, FinanceDocumentsIbusHelper.MergedBillingItem mergedBillingItem) {
        Set categories;
        HashMap<String, Object> record = new HashMap<String, Object>();
        BillingItem billingItem = mergedBillingItem.getMergedBillingItem();
        boolean isInvertSign = document.isInvertSign();
        Shipment shipment = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)billingItem.getShipment(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
        boolean vat = hasColumnVatRate;
        int size = 1;
        int hotelSize = 1;
        boolean isProduct = false;
        boolean isOwnFees = false;
        Map<String, List<NestedEntityReference>> groupedFopComponents = billingItem.getFopComponents().stream().collect(Collectors.groupingBy(EntityReference::getUid));
        block0: for (Map.Entry<String, List<NestedEntityReference>> bfGroup : groupedFopComponents.entrySet()) {
            EntityContainer bookingFile = EntityStorage.get().load(BookingFile.class, bfGroup.getKey());
            if (bookingFile == null) continue;
            for (NestedEntityReference fopComponentRef : bfGroup.getValue()) {
                FopComponent fopComponent = (FopComponent)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFile.getEntity(), (NestedEntityReference)fopComponentRef);
                if (fopComponent != null) {
                    if (fopComponent.getType() == FopComponentType.PRODUCT) {
                        isProduct = true;
                    }
                    if (fopComponent.getType() == FopComponentType.OWN_FEES) {
                        isOwnFees = true;
                    }
                }
                if (!isProduct || !isOwnFees) continue;
                continue block0;
            }
        }
        record.put(FIELD_IS_OWN_FEES, isOwnFees);
        boolean isHotelProduct = false;
        if (product != null) {
            ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
            boolean refundProduct = ProductStatus.REFUND == productHandler.getStatus(product);
            record.put(FIELD_BILLING_ITEM_IS_REFUND, refundProduct);
            record.put(FIELD_BILLING_ITEM_ISSUE_DATE, productHandler.findIssueDate(product));
            vat = hasColumnVatRate != false && productHandler.isVatIncludeBillingItem(product, document.getVatViewMode(), billingItem);
            BaseProduct firstProduct = productHandler.getPreviousProduct(product);
            if (firstProduct != null) {
                while (productHandler.getPreviousProduct(firstProduct) != null) {
                    firstProduct = productHandler.getPreviousProduct(firstProduct);
                }
                VatAmount firstProductPrice = GeneralProductHelper.calculateProductPrice((BaseProduct)firstProduct, (ContractType)ContractType.CLIENT);
                record.put(FIELD_BILLING_ITEM_FIRST_PRODUCT_TOTAL, firstProductPrice.getTotal());
                record.put(FIELD_BILLING_ITEM_FIRST_PRODUCT_VAT, firstProductPrice.getVatAmount());
                record.put(FIELD_BILLING_ITEM_FIRST_PRODUCT_MAX_VAT_PERCENT, this.getMaxVatPercent(firstProduct));
                if (refundProduct) {
                    record.put(FIELD_BILLING_ITEM_ISSUE_DATE, productHandler.findIssueDate(firstProduct));
                }
                record.put(FIELD_FIRST_PRODUCT_EQUIVALENT_FARE_AMOUNT, productHandler.getEquivalentFare(firstProduct));
                if (firstProduct instanceof Product) {
                    record.put(FIELD_FIRST_PRODUCT_EQUIVALENT_TAXES_AMOUNT, AirProductTaxHelper.getEquivalentTaxesAmount((Product)((Product)firstProduct)));
                }
                ProductStatus status = productHandler.getStatus(firstProduct);
                if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                    Collection firstProductHiddenCommissions = GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getClientCommissions((BaseProduct)firstProduct), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories);
                    boolean negate = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
                    BigDecimal value = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)firstProductHiddenCommissions);
                    record.put(FIELD_FIRST_PRODUCT_HIDDEN_FEES_AMOUNT, negate ? value.negate() : value);
                }
            }
            record.put(FIELD_BILLING_ITEM_MAX_VAT_PERCENT, this.getMaxVatPercent(product));
            record.put(FIELD_PRODUCT_PENALTY, productHandler.getPenalty(product));
            record.put(FIELD_PRODUCT_EQUIVALENT_FARE_AMOUNT, productHandler.getEquivalentFare(product));
            if (product instanceof Product) {
                record.put(FIELD_PRODUCT_EQUIVALENT_TAXES_AMOUNT, AirProductTaxHelper.getEquivalentTaxesAmount((Product)((Product)product)));
            }
            if (isProduct && product instanceof HotelProduct) {
                Room room;
                int nights;
                isHotelProduct = true;
                List rooms = ((HotelProduct)product).getRooms();
                if (CollectionUtil.isNotEmpty((Collection)rooms) && (nights = HotelProductHelper.calculateNights((Date)(room = (Room)rooms.get(0)).getCheckInDate(), (Date)room.getCheckOutDate())) != 0) {
                    hotelSize = nights;
                }
                DictionaryReference currency = null;
                EntityContainer shipmentCtr = EntityStorage.get().resolve(billingItem.getShipment());
                if (shipmentCtr != null) {
                    currency = ((Shipment)shipmentCtr.getEntity()).getCurrency();
                }
                String currencyCode = currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
                BigDecimal penaltyAmount = ((HotelProduct)product).getCancellationCharges().stream().filter(item -> item.getPenalty() != null).map(item -> item.getPenalty().getMoney()).filter(Objects::nonNull).filter(item -> currencyCode.equals(item.getCurrency()) || item.getCurrency() == null).map(Money::getValue).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
                List fopComponents = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).collect(Collectors.toList());
                BigDecimal totalProductFopAmount = fopComponents.stream().filter(item -> FopComponentType.PRODUCT.equals((Object)item.getType())).map(FopComponent::getAmount).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
                if (fopComponents.stream().noneMatch(item -> FopComponentType.PENALTY.equals((Object)item.getType())) && MiscUtil.compare((Comparable)penaltyAmount, (Comparable)totalProductFopAmount) == 0) {
                    isHotelProduct = false;
                }
            }
            record.put(BOOKING_FILE_NUMBER, product.getReservation().getBookingFile().getNumber());
            record.put(BOOKING_FILE_CREATE_DATE, product.getReservation().getBookingFile().getCreateDate());
            record.put(FIELD_PRODUCT_START_DATE, productHandler.getFirstStartDate(product));
            record.put(FIELD_PRODUCT_END_DATE, productHandler.getLastEndDate(product));
            record.put(FIELD_COST_CODES, this.getCostCodes(product, customerCostCodeProperties));
            record.put(FIELD_PRODUCT_COST_CODES_MAP, this.getProductCostCodes(product, customerCostCodeProperties));
        }
        record.put(FIELD_BILLING_ITEM_IS_PENALTY, (categories = mergedBillingItem.getBillingItems().stream().map(BillingItem::getProduct).filter(Objects::nonNull).distinct().map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(bp -> ProductHandler.of((BaseProduct)bp).getMCOCategory(bp)).collect(Collectors.toSet())).size() == 1 && categories.contains(MCOCategory.PENALTY));
        BigDecimal coefficient = BigDecimal.ONE;
        if (isInvertSign) {
            coefficient = coefficient.negate();
        }
        if (shipment != null) {
            record.put(FIELD_SHIPMENT_NUMBER, shipment.getNumber());
            record.put(FIELD_SHIPMENT_DATE, shipment.getDate());
        }
        record.put(FIELD_BILLING_ITEM_NUMBER, count.incrementAndGet());
        record.put(FIELD_BILLING_ITEM_COUNT, size);
        record.put(FIELD_BILLING_ITEM_NAME, billingItem.getName());
        int quantity = isHotelProduct ? hotelSize : size;
        record.put(FIELD_BILLING_ITEM_QUANTITY, quantity);
        if (billingItem.getAmount() != null) {
            Collection billingItemsWithoutFees = mergedBillingItem.getBillingItems().stream().filter(item -> ServiceType.FEE != item.getServiceType()).collect(Collectors.toList());
            if (vat) {
                if (billingItem.getAmount().getVatAmount() != null) {
                    BigDecimal vatAmount = billingItem.getAmount().getVatAmount().divide(BigDecimal.valueOf(size), 4, RoundingMode.HALF_UP).multiply(coefficient);
                    record.put(FIELD_BILLING_ITEM_VAT, vatAmount);
                    record.put(FIELD_BILLING_ITEM_VAT_AMOUNT, billingItem.getAmount().getVatAmount().divide(BigDecimal.valueOf(quantity), 4, RoundingMode.HALF_UP).multiply(coefficient));
                }
                record.put(FIELD_BILLING_ITEM_VAT_WITHOUT_FEES, billingItemsWithoutFees.stream().map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getVatAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).divide(BigDecimal.valueOf(quantity), 4, RoundingMode.HALF_UP).multiply(coefficient));
                if (billingItem.getAmount().getVat() != null) {
                    record.put(FIELD_BILLING_ITEM_VAT_PERCENT, BigDecimal.valueOf(billingItem.getAmount().getVat()).divide(BigDecimal.ONE, 4, RoundingMode.HALF_UP).doubleValue());
                }
            }
            if (billingItem.getAmount().getTotal() != null) {
                BigDecimal total = billingItem.getAmount().getTotal().divide(BigDecimal.valueOf(size), 4, RoundingMode.HALF_UP).multiply(coefficient);
                record.put(FIELD_BILLING_ITEM_TOTAL, total);
                record.put(FIELD_BILLING_ITEM_TOTAL_AMOUNT, billingItem.getAmount().getTotal().divide(BigDecimal.valueOf(quantity), 4, RoundingMode.HALF_UP).multiply(coefficient));
                record.put(FIELD_BILLING_ITEM_TOTAL_WITHOUT_FEES, billingItemsWithoutFees.stream().map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getTotal).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).divide(BigDecimal.valueOf(quantity), 4, RoundingMode.HALF_UP).multiply(coefficient));
            }
        }
        Collection fees = mergedBillingItem.getBillingItems().stream().filter(item -> ServiceType.FEE == item.getServiceType()).collect(Collectors.toList());
        record.put(FIELD_BILLING_ITEM_FEE_VAT, fees.stream().map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getVatAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).divide(BigDecimal.valueOf(quantity), 4, RoundingMode.HALF_UP).multiply(coefficient));
        record.put(FIELD_BILLING_ITEM_FEE_TOTAL, fees.stream().map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getTotal).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).divide(BigDecimal.valueOf(quantity), 4, RoundingMode.HALF_UP).multiply(coefficient));
        record.put(FIELD_BILLING_ITEM_IS_SERVICE, mergedBillingItem.getBillingItems().stream().noneMatch(bi -> bi.getServiceType() == ServiceType.TICKET));
        record.put(FIELD_BILLING_ITEM_IS_VAT, vat);
        record.put(IS_HOTEL_PRODUCT, isHotelProduct);
        dataSource.add(record);
    }

    private boolean isRefundFinanceDocument(FinanceDocument financeDocument, EntityStorageContext storageContext) {
        Map<String, List<NestedEntityReference>> productsMap = FinanceDocumentHelper.getBillingItems(financeDocument.getBillingItems(), storageContext).stream().map(BillingItem::getProduct).filter(Objects::nonNull).distinct().collect(Collectors.groupingBy(EntityReference::getUid));
        for (Map.Entry<String, List<NestedEntityReference>> bfGroup : productsMap.entrySet()) {
            EntityContainer bookingFile = EntityStorage.get().load(BookingFile.class, bfGroup.getKey());
            if (bookingFile == null) continue;
            for (NestedEntityReference productRef : bfGroup.getValue()) {
                ProductHandler handler;
                BaseProduct product = (BaseProduct)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFile.getEntity(), (NestedEntityReference)productRef);
                if (product == null || (handler = GeneralProductHelper.getHandler((BaseProduct)product)) == null) continue;
                ProductStatus status = handler.getStatus(product);
                if (status == ProductStatus.REFUND || ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                    return true;
                }
                if (handler.getMCOCategory(product) == null || !handler.getMCOCategory(product).equals((Object)MCOCategory.RETURN_FARE_DIFFERENCE)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Map<CostCodeProperties, String>> getCostCodes(BaseProduct product, List<CostCodeProperties> costCodeProperties) {
        ArrayList<Map<CostCodeProperties, String>> result = new ArrayList<Map<CostCodeProperties, String>>();
        if (product == null) {
            return result;
        }
        costCodeProperties.forEach(item -> {
            HashMap<CostCodeProperties, Object> map = new HashMap<CostCodeProperties, Object>();
            map.put((CostCodeProperties)item, null);
            result.add(map);
        });
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        StatisticalData statisticalData = productHandler.getStatisticalData(product);
        if (statisticalData != null) {
            StatisticsHelper.getAllCostCodes((StatisticalData)statisticalData).stream().filter(costCode -> TextUtil.nonBlank((String)costCode.getValue()) && costCodeProperties.contains(costCode.getCostCodeProperties())).forEach(costCode -> result.stream().filter(item -> item.containsKey(costCode.getCostCodeProperties())).forEach(item -> item.put(costCode.getCostCodeProperties(), costCode.getValue())));
        }
        return result;
    }

    private Map<String, CostCode> getProductCostCodes(BaseProduct product, List<CostCodeProperties> costCodeProperties) {
        HashMap<String, CostCode> result = new HashMap<String, CostCode>();
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        StatisticalData statisticalData = productHandler.getStatisticalData(product);
        if (statisticalData != null) {
            List costCodes = StatisticsHelper.getAllCostCodes((StatisticalData)statisticalData).stream().filter(costCode -> costCodeProperties.contains(costCode.getCostCodeProperties())).collect(Collectors.toList());
            for (CostCode costCode2 : costCodes) {
                CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCode2.getCostCodeProperties().getCategory());
                if (costCodeCategory == null) continue;
                result.put(costCodeCategory.getShortName(), costCode2);
            }
        }
        return result;
    }

    private List<CostCodeProperties> getCustomerCostCodeProperties(FinanceDocument document, EntityStorageContext storageContext) {
        Organization customer = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getCustomer(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        if (customer == null) {
            return Collections.emptyList();
        }
        return customer.getCostCodeProperties().stream().filter(item -> TextUtil.nonBlank((String)item.getName())).collect(Collectors.toList());
    }

    private Double getMaxVatPercent(BaseProduct product) {
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        OptionalDouble max = productHandler.getUnmodifiableContractRelations(product).stream().filter(data -> GeneralProductHelper.getContractType((EntityReference)data.getDescription()) == ContractType.CLIENT).map(GeneralProductHelper::getVatComponents).filter(Objects::nonNull).flatMap(Collection::stream).mapToDouble(VatComponent::getRate).max();
        if (max.isPresent()) {
            return max.getAsDouble();
        }
        return null;
    }
}

