/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.render;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectPersonProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.OrganizationLogotypeHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AuthorityLetter;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.ImageUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsRenderFillParametersCommonProcessor
extends BaseProcessor {
    private static final String KEY_CURRENT_DATE = "CURRENT_DATE";
    private static final String KEY_CURRENT_PERSON = "CURRENT_PERSON";
    private static final String KEY_CUSTOMER = "CUSTOMER";
    private static final String KEY_CUSTOMER_CODE = "CUSTOMER_CODE";
    private static final String KEY_CUSTOMER_SHORT_NAME_L10N = "CUSTOMER_SHORT_NAME_L10N";
    private static final String KEY_CUSTOMER_FULL_NAME_L10N = "CUSTOMER_FULL_NAME_L10N";
    private static final String KEY_CUSTOMER_LEGAL_FORM = "CUSTOMER_LEGAL_FORM";
    private static final String KEY_AGENCY_FULLNAME = "AGENCY_FULLNAME";
    private static final String KEY_AGENCY_FULLNAME_FACTUAL = "AGENCY_FULLNAME_FACTUAL";
    private static final String KEY_AGENCY = "AGENCY";
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_FULL_LEGAL_FORM = "AGENCY_FULL_LEGAL_FORM";
    private static final String KEY_AGENCY_LOGOTYPE = "AGENCY_LOGOTYPE";
    private static final String KEY_AGENCY_LOGOTYPE_WIDTH = "AGENCY_LOGOTYPE_WIDTH";
    private static final String KEY_AGENCY_LOGOTYPE_HEIGHT = "AGENCY_LOGOTYPE_HEIGHT";
    private static final String KEY_AGENCY_CODE = "AGENCY_CODE";
    private static final String KEY_AGENCY_SHORT_NAME_L10N = "AGENCY_SHORT_NAME_L10N";
    private static final String KEY_AGENCY_FULL_NAME_L10N = "AGENCY_FULL_NAME_L10N";
    private static final String KEY_AGENCY_LEGAL_FORM = "AGENCY_LEGAL_FORM";
    private static final String KEY_CONTRACT_NUMBER = "CONTRACT_NUMBER";
    private static final String KEY_CONTRACT_START_DATE = "CONTRACT_START_DATE";
    private static final String KEY_CONTRACT_END_DATE = "CONTRACT_END_DATE";
    private static final String KEY_CONTRACT_ISSUE_DATE = "CONTRACT_ISSUE_DATE_DATE";
    private static final String KEY_CUSTOMER_FULLNAME = "CUSTOMER_FULLNAME";
    private static final String KEY_CUSTOMER_NAME = "CUSTOMER_NAME";
    private static final String KEY_CUSTOMER_FULLNAME_FACTUAL = "CUSTOMER_FULLNAME_FACTUAL";
    private static final String KEY_CUSTOMER_DIRECTOR = "CUSTOMER_DIRECTOR";
    private static final String KEY_TOTAL_PRICE_STRING = "TOTAL_PRICE_STRING";
    private static final String KEY_TOTAL_VAT_STRING = "TOTAL_VAT_STRING";
    private static final String KEY_TOTAL_VAT = "TOTAL_VAT";
    private static final String KEY_TOTAL_PRICE = "TOTAL_PRICE";
    private static final String KEY_TOTAL_COMMISSION = "TOTAL_COMMISSION";
    private static final String KEY_TOTAL_COMMISSION_STRING = "TOTAL_COMMISSION_STRING";
    private static final String KEY_CARRIER_STRING = "CARRIER_STRING";
    private static final String KEY_MONEY_CODE = "MONEY_CODE";
    private static final String KEY_MONEY_SYMBOL = "MONEY_SYMBOL";
    private static final String KEY_FIN_DOC_NUMBER = "FIN_DOC_NUMBER";
    private static final String KEY_FIN_DOC_DATE = "FIN_DOC_DATE";
    private static final String KEY_CORRECTION_FIN_DOC_NUMBER = "CORRECTION_FIN_DOC_NUMBER";
    private static final String KEY_CORRECTION_FIN_DOC_DATE = "CORRECTION_FIN_DOC_DATE";
    private static final String KEY_AGENCY_ADDRESS = "AGENCY_ADDRESS";
    private static final String KEY_AGENCY_LEGAL_ADDRESS = "AGENCY_LEGAL_ADDRESS";
    private static final String KEY_AGENCY_PHONE = "AGENCY_PHONE";
    private static final String KEY_AGENCY_FAX = "AGENCY_FAX";
    private static final String KEY_CUSTOMER_ADDRESS = "CUSTOMER_ADDRESS";
    private static final String KEY_CUSTOMER_LEGAL_ADDRESS = "CUSTOMER_LEGAL_ADDRESS";
    private static final String KEY_CUSTOMER_PHONE = "CUSTOMER_PHONE";
    private static final String KEY_CUSTOMER_FAX = "CUSTOMER_FAX";
    private static final String KEY_AGENCY_INN = "AGENCY_INN";
    private static final String KEY_AGENCY_KPP = "AGENCY_KPP";
    private static final String KEY_AGENCY_BIN = "AGENCY_BIN";
    private static final String KEY_AGENCY_OKPO = "AGENCY_OKPO";
    private static final String KEY_AGENCY_BENEFICIARY_CODE = "AGENCY_BENEFICIARY_CODE";
    private static final String KEY_AGENCY_TAX_LICENSE_NUMBER = "AGENCY_TAX_LICENSE_NUMBER";
    private static final String KEY_AGENCY_BANK_BIK = "AGENCY_BANK_BIK";
    private static final String KEY_AGENCY_BANK_LORO_ACCAUNT = "AGENCY_BANK_LORO_ACCAUNT";
    private static final String KEY_AGENCY_BANK_SETTLEMENT_ACCAUNT = "AGENCY_BANK_SETTLEMENT_ACCAUNT";
    private static final String KEY_AGENCY_BANK_CITY = "AGENCY_BANK_CITY";
    private static final String KEY_AGENCY_BANK_NAME = "AGENCY_BANK_NAME";
    private static final String KEY_AGENT_NAME = "AGENT_NAME";
    private static final String KEY_AGENT_SIGNATURE = "AGENT_SIGNATURE";
    private static final String KEY_AGENT_SIGNATURE_WIDTH = "AGENT_SIGNATURE_WIDTH";
    private static final String KEY_AGENT_SIGNATURE_HEIGHT = "AGENT_SIGNATURE_HEIGHT";
    private static final String KEY_PAYMENT_CODE = "PAYMENT_CODE";
    private static final String KEY_COST_CODE = "COST_CODE";
    private static final String KEY_CUSTOMER_INN = "CUSTOMER_INN";
    private static final String KEY_CUSTOMER_KPP = "CUSTOMER_KPP";
    private static final String KEY_CUSTOMER_OKPO = "CUSTOMER_OKPO";
    private static final String KEY_CUSTOMER_BIN = "CUSTOMER_BIN";
    private static final String KEY_CUSTOMER_BANK_NAME = "CUSTOMER_BANK_NAME";
    private static final String KEY_CUSTOMER_BANK_CITY = "CUSTOMER_BANK_CITY";
    private static final String KEY_CUSTOMER_BANK_BIK = "CUSTOMER_BANK_BIK";
    private static final String KEY_CUSTOMER_BANK_LORO_ACCOUNT = "CUSTOMER_BANK_LORO_ACCOUNT";
    private static final String KEY_CUSTOMER_BANK_SETTLEMENT_ACCOUNT = "CUSTOMER_BANK_SETTLEMENT_ACCOUNT";
    private static final String KEY_CUSTOMER_SIGNER = "CUSTOMER_SIGNER";
    private static final String KEY_CUSTOMER_SIGNER_TITLE = "CUSTOMER_SIGNER_TITLE";
    private static final String KEY_CUSTOMER_SIGNER_NAME = "CUSTOMER_SIGNER_NAME";
    private static final String KEY_CUSTOMER_SIGNATURE_TITLE = "CUSTOMER_SIGNATURE_TITLE";
    private static final String KEY_CUSTOMER_DELEGATE = "CUSTOMER_DELEGATE";
    private static final String KEY_CUSTOMER_DELEGATE_NAME = "CUSTOMER_DELEGATE_NAME";
    private static final String KEY_CUSTOMER_DELEGATE_AUTHORITY_LETTER_NAME = "CUSTOMER_DELEGATE_AUTHORITY_LETTER_NAME";
    private static final String KEY_CUSTOMER_DELEGATE_AUTHORITY_LETTER_NUMBER = "CUSTOMER_DELEGATE_AUTHORITY_LETTER_NUMBER";
    private static final String KEY_CUSTOMER_DELEGATE_AUTHORITY_LETTER_DATE = "CUSTOMER_DELEGATE_AUTHORITY_LETTER_DATE";
    private static final String KEY_CUSTOMER_SIGNATURE = "CUSTOMER_SIGNATURE";
    private static final String KEY_CUSTOMER_SIGNATURE_WIDTH = "CUSTOMER_SIGNATURE_WIDTH";
    private static final String KEY_CUSTOMER_SIGNATURE_HEIGHT = "CUSTOMER_SIGNATURE_HEIGHT";
    private static final String KEY_CUSTOMER_STAMP = "CUSTOMER_STAMP";
    private static final String KEY_CASH_ORDER_TOTAL = "CASH_ORDER_TOTAL";
    private static final String KEY_CASH_ORDER_TOTAL_STRING = "CASH_ORDER_TOTAL_STRING";
    private static final String KEY_CASH_ORDER_SUBJECT = "CASH_ORDER_SUBJECT";
    private static final String KEY_IS_REFUND = "IS_REFUND";
    private static final String KEY_STAMP = "STAMP";
    private static final String KEY_PAYER_NAME = "PAYER_NAME";
    private static final String KEY_PAYER_NAME_EN = "PAYER_NAME_EN";
    private static final String KEY_PAYER_FULLNAME = "PAYER_FULLNAME";
    private static final String KEY_PAYER_FULLNAME_FACTUAL = "PAYER_FULLNAME_FACTUAL";
    private static final String KEY_PAYER_ADDRESS = "PAYER_ADDRESS";
    private static final String KEY_PAYER_LEGAL_ADDRESS = "PAYER_LEGAL_ADDRESS";
    private static final String KEY_PAYER_PHONE = "PAYER_PHONE";
    private static final String KEY_PAYER_FAX = "PAYER_FAX";
    private static final String KEY_PAYER_INN = "PAYER_INN";
    private static final String KEY_PAYER_KPP = "PAYER_KPP";
    private static final String KEY_PAYER_BIN = "PAYER_BIN";
    private static final String KEY_PAYER_HOLDING_NAME = "PAYER_HOLDING_NAME";
    private static final String KEY_VAT_INCLUDED = "VAT_INCLUDED";
    private static final String KEY_DISPLAY_CONTRACT = "DISPLAY_CONTRACT";
    private static final String KEY_NOT_DISPLAY_TITLE_CONTRACT_NUMBER = "NOT_DISPLAY_TITLE_CONTRACT_NUMBER";
    private static final String KEY_DISPLAY_VAT_COLUMNS = "DISPLAY_VAT_COLUMNS";
    private static final String KEY_DISPLAY_COST_CODE = "DISPLAY_COST_CODE";
    private static final String KEY_CAPTION_TEMPLATE = "CAPTION_TEMPLATE";
    private static final String KEY_CONTAINS_HOTEL_PRODUCT = "CONTAINS_HOTEL_PRODUCT";
    private static final String KEY_DECIMAL_FORMAT = "DECIMAL_FORMAT";
    private static final String KEY_IS_VENDOR_DOCUMENT = "IS_VENDOR_DOCUMENT";
    private static final String KEY_VENDOR_SHIPPING_DOCUMENT_NUMBER = "VENDOR_SHIPPING_DOCUMENT_NUMBER";
    private static final String KEY_VENDOR_SHIPPING_DOCUMENT_DATE = "VENDOR_SHIPPING_DOCUMENT_DATE";
    private static final String KEY_COMMISSION_AGENT = "COMMISSION_AGENT";
    private static final String KEY_COMMISSION_AGENT_ADDRESS = "COMMISSION_AGENT_ADDRESS";
    private static final String KEY_COMMISSION_AGENT_INN = "COMMISSION_AGENT_INN";
    private static final String KEY_COMMISSION_AGENT_KPP = "COMMISSION_AGENT_KPP";
    private static final String KEY_UNIVERSAL_DOCUMENT_STATUS = "UNIVERSAL_DOCUMENT_STATUS";
    private static final String KEY_PREVIOUS_RELATED_SHIPMENTS_NUMBERS = "PREVIOUS_RELATED_SHIPMENTS_NUMBERS";
    private static final PersonalLocalizableNameFormatter nameFormatter = new PersonalLocalizableNameFormatter("L f m");

    /*
     * WARNING - void declaration
     */
    public void process(MessageContext context) throws Exception {
        Organization payer;
        Person agent;
        BankAccount bankAccount;
        List bankAccounts;
        void var36_43;
        String string;
        Person person;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        FinanceDocument document = (FinanceDocument)documentContainer.getEntity();
        FinanceDocumentSettings settings = (FinanceDocumentSettings)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_SETTINGS);
        Map parameters = (Map)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PARAMETERS);
        Locale locale = (Locale)context.getMandatoryObject((Enum)IBusFinanceContextKeys.LOCALE);
        Boolean noPenaltyVat = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.NO_PENALTY_VAT);
        Boolean hideColumnsVat = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.HIDE_COLUMNS_VAT);
        boolean vendorDocument = document.isVendorDocument();
        parameters.put(KEY_IS_VENDOR_DOCUMENT, vendorDocument);
        UniversalDocumentStatus universalDocumentStatus = document.getUniversalDocumentStatus();
        if (universalDocumentStatus != null) {
            parameters.put(KEY_UNIVERSAL_DOCUMENT_STATUS, universalDocumentStatus.toString(locale));
        }
        Boolean hasCostCode = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.HAS_COST_CODE);
        Organization agency = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getSupplier(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        Organization commissionAgent = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getAgency(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        if (commissionAgent != null) {
            parameters.put(KEY_COMMISSION_AGENT, ProfileHelper.getFullName((String)commissionAgent.getCode(), (L10nString)commissionAgent.getShortName(), (L10nString)commissionAgent.getFullName(), (DictionaryReference)commissionAgent.getLegalForm(), (Locale)locale, (boolean)false, (!document.isDisableCustomerQuotes() ? 1 : 0) != 0));
            parameters.put(KEY_COMMISSION_AGENT_ADDRESS, this.buildAddress(ProfileHelper.getOrganizationAddresses((Organization)commissionAgent, (Date)document.getDate()), AddressType.LEGAL, locale));
            parameters.put(KEY_COMMISSION_AGENT_INN, HistoricalValueHelper.getValue((List)commissionAgent.getRegistrationIdHistory(), (Date)document.getDate()));
            parameters.put(KEY_COMMISSION_AGENT_KPP, HistoricalValueHelper.getValue((List)commissionAgent.getKppHistory(), (Date)document.getDate()));
        }
        if (document.getVendorFinanceDocumentData() != null) {
            parameters.put(KEY_VENDOR_SHIPPING_DOCUMENT_NUMBER, document.getVendorFinanceDocumentData().getVendorShippingDocumentNumber());
            parameters.put(KEY_VENDOR_SHIPPING_DOCUMENT_DATE, document.getVendorFinanceDocumentData().getVendorShippingDocumentDate());
        }
        if (agency == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderSupplierNotFound).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_organizationLoadFailed, (Object[])new Object[]{document.getSupplier()})).build());
            throw new Exception("rendering failed");
        }
        Organization customer = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getCustomer(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        if (customer == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderCustomerNotFound).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_organizationLoadFailed, (Object[])new Object[]{document.getCustomer()})).build());
            throw new Exception("rendering failed");
        }
        BaseProfile payerBaseProfile = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getPayer(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        if (payerBaseProfile == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderPayerNotFound).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_profileLoadFailed, (Object[])new Object[]{document.getPayer()})).build());
            throw new Exception("rendering failed");
        }
        Contract contract = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getContract(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        if (contract == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderContractNotFound).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_contractLoadFailed, (Object[])new Object[]{document.getContract()})).build());
            throw new Exception("rendering failed");
        }
        List<BillingItem> billingItems = FinanceDocumentHelper.getBillingItems(document.getBillingItems(), storageContext);
        List products = billingItems.stream().map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList());
        List customerAddresses = ProfileHelper.getOrganizationAddresses((Organization)customer, (Date)document.getDate());
        List agencyAddresses = ProfileHelper.getOrganizationAddresses((Organization)agency, (Date)document.getDate());
        parameters.put(KEY_CUSTOMER, ProfileHelper.getFullName((String)customer.getCode(), (L10nString)customer.getShortName(), (L10nString)customer.getFullName(), (DictionaryReference)customer.getLegalForm(), (Locale)locale, (boolean)false, (!document.isDisableCustomerQuotes() ? 1 : 0) != 0));
        parameters.put(KEY_CUSTOMER_CODE, customer.getCode());
        parameters.put(KEY_CUSTOMER_SHORT_NAME_L10N, customer.getShortName());
        parameters.put(KEY_CUSTOMER_FULL_NAME_L10N, customer.getFullName());
        parameters.put(KEY_CUSTOMER_LEGAL_FORM, customer.getLegalForm());
        parameters.put(KEY_CUSTOMER_NAME, ProfileHelper.getFullName((String)customer.getCode(), (L10nString)customer.getShortName(), (L10nString)customer.getFullName(), null, (Locale)locale, (boolean)false, (!document.isDisableCustomerQuotes() ? 1 : 0) != 0));
        parameters.put(KEY_CUSTOMER_FULLNAME, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)customer.getLegalForm(), (Locale)locale), customer.getFullName(), (String)HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)document.getDate()), (String)HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)document.getDate()), customerAddresses, AddressType.LEGAL, customer.getBankAccounts(), locale, false));
        parameters.put(KEY_CUSTOMER_FULLNAME_FACTUAL, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)customer.getLegalForm(), (Locale)locale), customer.getFullName(), (String)HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)document.getDate()), (String)HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)document.getDate()), customerAddresses, AddressType.FACTUAL, customer.getBankAccounts(), locale, false));
        Date date = new Date();
        parameters.put(KEY_CURRENT_DATE, date);
        parameters.put("REPORT_LOCALE", locale);
        String user = UserData.get().getCurrentUser();
        if (user != null && (person = (Person)Optional.ofNullable(EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)user)).map(EntityContainer::getEntity).orElse(null)) != null) {
            parameters.put(KEY_CURRENT_PERSON, nameFormatter.format((PersonalLocalizableName)person, locale, false));
        }
        boolean refund = this.isRefundFinanceDocument(document, storageContext);
        boolean isInvertSign = document.isInvertSign();
        parameters.put(KEY_IS_REFUND, refund);
        parameters.put(KEY_FIN_DOC_NUMBER, TextUtil.buildFullNumber((CompositeNumber)document));
        parameters.put(KEY_FIN_DOC_DATE, document.getDate());
        document.getRelatedShipments().stream().map(shipmentReference -> EntityStorageHelper.resolve((EntityReference)shipmentReference, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(EntityContainer::getEntity).findFirst().ifPresent(shipment -> {
            EntityContainer originalShipmentReference;
            if (TextUtil.nonBlank((String)shipment.getCategoryPaymentCode())) {
                parameters.put(KEY_PAYMENT_CODE, shipment.getCategoryPaymentCode());
            }
            if (!shipment.getCostCodes().isEmpty()) {
                StringBuilder costCodesKey = new StringBuilder();
                shipment.getCostCodes().forEach(cc -> {
                    costCodesKey.append(cc.getCostCodeProperties().getName());
                    costCodesKey.append(": ");
                    costCodesKey.append(TextUtil.nonBlank((String)cc.getValue()) ? cc.getValue() : "?");
                    costCodesKey.append(", ");
                });
                parameters.put(KEY_COST_CODE, costCodesKey.substring(0, costCodesKey.length() < 2 ? 0 : costCodesKey.length() - 2));
            }
            if (shipment.getOriginalShipment() != null && (originalShipmentReference = EntityStorageHelper.resolve((EntityReference)shipment.getOriginalShipment(), (EntityStorageContext)storageContext)) != null) {
                parameters.put(KEY_CORRECTION_FIN_DOC_NUMBER, ((Shipment)originalShipmentReference.getEntity()).getNumber());
                parameters.put(KEY_CORRECTION_FIN_DOC_DATE, ((Shipment)originalShipmentReference.getEntity()).getDate());
            }
        });
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        parameters.put(KEY_DISPLAY_CONTRACT, document.isDisplayContract());
        parameters.put(KEY_NOT_DISPLAY_TITLE_CONTRACT_NUMBER, document.isNotDisplayTitleContractNumber());
        parameters.put(KEY_DISPLAY_VAT_COLUMNS, hideColumnsVat == null || hideColumnsVat == false);
        parameters.put(KEY_DISPLAY_COST_CODE, hasCostCode);
        parameters.put(KEY_CONTRACT_NUMBER, contract.getNumber());
        parameters.put(KEY_CONTRACT_ISSUE_DATE, contract.getIssueDate());
        parameters.put(KEY_CONTRACT_START_DATE, contract.getStartDate() != null ? format.format(contract.getStartDate()) : null);
        parameters.put(KEY_CONTRACT_END_DATE, contract.getEndDate() != null ? format.format(contract.getEndDate()) : null);
        boolean vatIncluded = billingItems.stream().flatMap(item -> item.getFopComponents().stream()).map(item -> (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)storageContext)).anyMatch(item -> item != null && item.getVatRate() != null);
        parameters.put(KEY_VAT_INCLUDED, vatIncluded);
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal totalVat = BigDecimal.ZERO;
        BigDecimal totalCashOrder = BigDecimal.ZERO;
        Set ticketProducts = billingItems.stream().map(item -> {
            boolean productIncludedInOtherShipment;
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext);
            if (product == null) {
                return null;
            }
            if (item.getServiceType() == ServiceType.TICKET) {
                return product;
            }
            GeneralProductContractRelationData contractRelation = ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations(product).stream().filter(relationData -> MiscUtil.equals((Object)relationData.getGeneralData().getContractData().getContract(), (Object)document.getContract())).findFirst().orElse(null);
            if (contractRelation != null && !(productIncludedInOtherShipment = contractRelation.getFops().stream().map(fop -> (FopDetalization)product.getFopDetalizations().get(fop.getUid())).filter(Objects::nonNull).flatMap(fopDetalization -> fopDetalization.getComponents().stream()).filter(fopComponent -> fopComponent.getType() == FopComponentType.PRODUCT || fopComponent.getType() == FopComponentType.TAXES || fopComponent.getType() == FopComponentType.SERVICE || fopComponent.isHidden()).map(FopComponent::getShipment).filter(Objects::nonNull).anyMatch(shipment -> !document.getRelatedShipments().contains(shipment)))) {
                return product;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        BigDecimal totalCommission = BigDecimal.ZERO;
        for (BaseProduct ticketProduct : ticketProducts) {
            GeneralProductContractRelationData contractRelation = ProductHandler.of((BaseProduct)ticketProduct).getUnmodifiableContractRelations(ticketProduct).stream().filter(item -> MiscUtil.equals((Object)item.getGeneralData().getContractData().getContract(), (Object)document.getContract())).findFirst().orElse(null);
            if (contractRelation == null) continue;
            BigDecimal bigDecimal = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null));
            ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)ticketProduct);
            totalCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalCommission, status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)bigDecimal) : bigDecimal});
        }
        if (isInvertSign) {
            totalCommission = totalCommission.negate();
        }
        HashSet<String> returnedTicketNumbers = new HashSet<String>();
        HashSet<EntityReference> returnedBlankOwners = new HashSet<EntityReference>();
        for (BillingItem billingItem : billingItems) {
            BaseTicketProduct baseTicketProduct;
            BaseProduct baseProduct2;
            if (billingItem.getAmount() == null || billingItem.getAmount().getTotal() == null) continue;
            totalPrice = totalPrice.add(billingItem.getAmount().getTotal());
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
            if (product != null) {
                boolean vat = ProductHandler.of((BaseProduct)product).isVatIncludeBillingItem(product, document.getVatViewMode(), billingItem);
                if (!(billingItem.getAmount().getVatAmount() == null || billingItem.getServiceType() == ServiceType.PENALTY && noPenaltyVat.booleanValue() || !vat && (billingItem.getServiceType() != ServiceType.FEE || agency.isSimpleTaxed()))) {
                    totalVat = totalVat.add(billingItem.getAmount().getVatAmount());
                }
            }
            if (document.getType() != FinanceDocumentType.CASH_ORDER) continue;
            if (billingItem.getServiceType() == ServiceType.TICKET && (baseProduct2 = (BaseProduct)products.stream().filter(item -> TextUtil.isSame((String)item.getUid(), (String)billingItem.getProduct().getNestedEntityUid())).findFirst().orElse(null)) instanceof BaseTicketProduct && (baseTicketProduct = (BaseTicketProduct)baseProduct2).getStatus() == ProductStatus.REFUND) {
                if (baseTicketProduct.getBlankOwnerRef() != null) {
                    returnedBlankOwners.add(baseTicketProduct.getBlankOwnerRef());
                }
                if (!TextUtil.isBlank((String)baseTicketProduct.getSystemNumber())) {
                    returnedTicketNumbers.add(baseTicketProduct.getSystemNumber());
                }
            }
            totalCashOrder = totalCashOrder.subtract(billingItem.getAmount().getTotal());
        }
        if (isInvertSign) {
            totalPrice = totalPrice.negate();
            totalVat = totalVat.negate();
        }
        HashSet<EntityContainer<Shipment>> previousRelatedShipments = new HashSet<EntityContainer<Shipment>>();
        for (BaseProduct product : products) {
            BaseProduct previousProduct;
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            if (ProductStatus.REFUND != handler.getStatus(product) || (previousProduct = handler.getPreviousProduct(product)) == null) continue;
            if (contract.getContractType() == ContractType.CLIENT) {
                previousRelatedShipments.addAll(ShipmentHelper.getClientRelatedShipments(previousProduct));
            }
            if (contract.getContractType() != ContractType.SUBAGENCY) continue;
            previousRelatedShipments.addAll(ShipmentHelper.getSubagentRelatedShipments(previousProduct));
        }
        if (!previousRelatedShipments.isEmpty()) {
            parameters.put(KEY_PREVIOUS_RELATED_SHIPMENTS_NUMBERS, previousRelatedShipments.stream().map(s -> String.format("%s \u043e\u0442 %s", ((Shipment)s.getEntity()).getNumber(), ((Shipment)s.getEntity()).getDate() != null ? new SimpleDateFormat("dd.MM.yyyy").format(((Shipment)s.getEntity()).getDate()) : "")).collect(Collectors.joining(", ")));
        }
        String string2 = string = document.getCurrency() != null ? document.getCurrency().getCode() : null;
        if (TextUtil.isBlank((String)string)) {
            String string3 = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        }
        parameters.put(KEY_MONEY_CODE, var36_43);
        parameters.put(KEY_MONEY_SYMBOL, var36_43 != null ? MiscUtil.getCurrencySymbol((String)var36_43) : null);
        parameters.put(KEY_TOTAL_PRICE, totalPrice);
        parameters.put(KEY_TOTAL_VAT, totalVat);
        parameters.put(KEY_TOTAL_PRICE_STRING, FinanceDocumentsHelper.getMoneyStr((BigDecimal)totalPrice.subtract(totalCommission), (Locale)locale, (String)var36_43));
        parameters.put(KEY_TOTAL_VAT_STRING, FinanceDocumentsHelper.getMoneyStr((BigDecimal)totalVat, (Locale)locale, (String)var36_43));
        parameters.put(KEY_TOTAL_COMMISSION, totalCommission);
        parameters.put(KEY_TOTAL_COMMISSION_STRING, FinanceDocumentsHelper.getMoneyStr((BigDecimal)totalCommission, (Locale)locale, (String)var36_43));
        String airlineString = products.stream().map(item -> (Airline)DictionaryCache.get().resolveReference(ProductHandler.of((BaseProduct)item).getCarrier(item))).filter(Objects::nonNull).distinct().map(item -> {
            StringBuilder result = new StringBuilder();
            result.append(item.toString(locale));
            if (DictionaryCache.get().resolveReference(item.getLegalForm()) != null) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append(((LegalForm)DictionaryCache.get().resolveReference(item.getLegalForm())).toString(locale));
            }
            if (TextUtil.nonBlank((String)item.getBin())) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append("\u0411\u0418\u041d: ").append(item.getBin());
            }
            if (TextUtil.nonBlank((String)item.getVatSeriesNumber())) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append("\u2116").append(item.getVatSeriesNumber());
                if (item.getVatSeriesDate() != null) {
                    result.append(" \u043e\u0442 ").append(format.format(item.getVatSeriesDate()));
                }
            }
            return result.toString();
        }).filter(TextUtil::nonBlank).collect(Collectors.joining("\n"));
        String principalString = products.stream().map(item -> (Principal)DictionaryCache.get().resolveReference(ProductHandler.of((BaseProduct)item).getPrincipal(item))).filter(Objects::nonNull).distinct().map(item -> {
            StringBuilder result = new StringBuilder();
            result.append(item.toString(locale));
            if (TextUtil.nonBlank((String)item.getBin())) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append("\u0411\u0418\u041d: ").append(item.getBin());
            }
            if (TextUtil.nonBlank((String)item.getVatSeriesNumber())) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append("\u2116").append(item.getVatSeriesNumber());
            }
            return result.toString();
        }).filter(TextUtil::nonBlank).collect(Collectors.joining("\n"));
        String carrierString = airlineString.concat(TextUtil.nonBlank((String)airlineString) ? "\n".concat(principalString) : principalString);
        parameters.put(KEY_CARRIER_STRING, TextUtil.nonBlank((String)carrierString) ? carrierString : null);
        if (document.getType() == FinanceDocumentType.CASH_ORDER) {
            parameters.put(KEY_CASH_ORDER_TOTAL, totalCashOrder);
            parameters.put(KEY_CASH_ORDER_TOTAL_STRING, FinanceDocumentsHelper.getMoneyStr((BigDecimal)totalCashOrder, (Locale)locale, (String)var36_43));
            StringBuilder sb = new StringBuilder("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432");
            if (!returnedBlankOwners.isEmpty()) {
                sb.append(" ");
            }
            boolean first = true;
            for (EntityReference bo : returnedBlankOwners) {
                sb.append(first ? " " : ", ");
                sb.append(bo.toString());
                first = false;
            }
            first = true;
            for (String tn : returnedTicketNumbers) {
                sb.append(first ? " " : ", ");
                sb.append(tn);
                first = false;
            }
            parameters.put(KEY_CASH_ORDER_SUBJECT, sb.toString());
        }
        Branch branch = products.stream().map(item -> EntityStorageHelper.resolve((EntityReference)GeneralProductHelper.getHandler((BaseProduct)item).getBranch(item), (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(EntityContainer::getEntity).findFirst().orElse(null);
        parameters.put(KEY_AGENCY, ProfileHelper.getFullName((String)agency.getCode(), (L10nString)agency.getShortName(), (L10nString)agency.getFullName(), (DictionaryReference)agency.getLegalForm(), (Locale)locale, (boolean)false));
        parameters.put(KEY_AGENCY_NAME, ProfileHelper.getFullName((String)agency.getCode(), (L10nString)agency.getShortName(), (L10nString)agency.getFullName(), null, (Locale)locale, (boolean)false));
        parameters.put(KEY_AGENCY_FULL_LEGAL_FORM, this.getFullLegalForm((DictionaryReference<LegalForm>)agency.getLegalForm(), locale));
        parameters.put(KEY_AGENCY_FULLNAME, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)agency.getLegalForm(), (Locale)locale), agency.getFullName(), (String)HistoricalValueHelper.getValue((List)agency.getRegistrationIdHistory(), (Date)document.getDate()), (String)HistoricalValueHelper.getValue((List)agency.getKppHistory(), (Date)document.getDate()), agencyAddresses, AddressType.LEGAL, agency.getBankAccounts(), locale, false));
        parameters.put(KEY_AGENCY_FULLNAME_FACTUAL, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)agency.getLegalForm(), (Locale)locale), agency.getFullName(), (String)HistoricalValueHelper.getValue((List)agency.getRegistrationIdHistory(), (Date)document.getDate()), (String)HistoricalValueHelper.getValue((List)agency.getKppHistory(), (Date)document.getDate()), agencyAddresses, AddressType.FACTUAL, agency.getBankAccounts(), locale, false));
        parameters.put(KEY_AGENCY_CODE, agency.getCode());
        parameters.put(KEY_AGENCY_SHORT_NAME_L10N, agency.getShortName());
        parameters.put(KEY_AGENCY_FULL_NAME_L10N, agency.getFullName());
        parameters.put(KEY_AGENCY_LEGAL_FORM, agency.getLegalForm());
        parameters.put(KEY_AGENCY_ADDRESS, branch != null ? this.buildAddress(branch.getAddresses(), AddressType.LEGAL, locale) : this.buildAddress(agencyAddresses, AddressType.LEGAL, locale));
        parameters.put(KEY_AGENCY_LEGAL_ADDRESS, branch != null ? branch.getAddresses().stream().filter(item -> AddressType.LEGAL == item.getAddressType()).findFirst().orElse(null) : agencyAddresses.stream().filter(item -> AddressType.LEGAL == item.getAddressType()).findFirst().orElse(null));
        parameters.put(KEY_AGENCY_PHONE, branch != null ? this.buildPhone(branch.getCommunications(), CommunicationType.WORK_PHONE) : this.buildPhone(agency.getCommunications(), CommunicationType.WORK_PHONE));
        parameters.put(KEY_AGENCY_FAX, branch != null ? this.buildPhone(branch.getCommunications(), CommunicationType.FAX) : this.buildPhone(agency.getCommunications(), CommunicationType.FAX));
        parameters.put(KEY_AGENCY_INN, HistoricalValueHelper.getValue((List)agency.getRegistrationIdHistory(), (Date)document.getDate()));
        parameters.put(KEY_AGENCY_KPP, branch != null ? HistoricalValueHelper.getValue((List)branch.getKppHistory(), (Date)document.getDate()) : HistoricalValueHelper.getValue((List)agency.getKppHistory(), (Date)document.getDate()));
        parameters.put(KEY_AGENCY_OKPO, agency.getOkpoCode());
        parameters.put(KEY_AGENCY_BIN, HistoricalValueHelper.getValue((List)agency.getBinHistory(), (Date)document.getDate()));
        if (agency.getBeneficiaryCode() != null) {
            parameters.put(KEY_AGENCY_BENEFICIARY_CODE, agency.getBeneficiaryCode().toString(locale));
        }
        parameters.put(KEY_AGENCY_TAX_LICENSE_NUMBER, HistoricalValueHelper.getValue((List)agency.getVatLicenseNumberHistory(), (Date)document.getDate()));
        byte[] agencyLogoData = OrganizationLogotypeHelper.getLogoData((Organization)agency);
        if (agencyLogoData != null) {
            ImageUtil.ImageData agencyLogoImageData = new ImageUtil.ImageData(agencyLogoData);
            parameters.put(KEY_AGENCY_LOGOTYPE, new ByteArrayInputStream(agencyLogoData));
            parameters.put(KEY_AGENCY_LOGOTYPE_WIDTH, agencyLogoImageData.getWidth());
            parameters.put(KEY_AGENCY_LOGOTYPE_HEIGHT, agencyLogoImageData.getHeight());
        }
        parameters.put(KEY_CUSTOMER_ADDRESS, this.buildAddress(customerAddresses, AddressType.LEGAL, locale));
        parameters.put(KEY_CUSTOMER_LEGAL_ADDRESS, customerAddresses.stream().filter(item -> AddressType.LEGAL == item.getAddressType()).findFirst().orElse(null));
        parameters.put(KEY_CUSTOMER_PHONE, this.buildPhone(customer.getCommunications(), CommunicationType.WORK_PHONE));
        parameters.put(KEY_CUSTOMER_FAX, this.buildPhone(customer.getCommunications(), CommunicationType.FAX));
        parameters.put(KEY_CUSTOMER_INN, HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)document.getDate()));
        parameters.put(KEY_CUSTOMER_KPP, HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)document.getDate()));
        parameters.put(KEY_CUSTOMER_OKPO, customer.getOkpoCode());
        parameters.put(KEY_CUSTOMER_BIN, HistoricalValueHelper.getValue((List)customer.getBinHistory(), (Date)document.getDate()));
        BankAccount customerBankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)document.getPayerBankAccount(), (EntityStorageContext)storageContext);
        if (customerBankAccount == null && (bankAccounts = customer.getBankAccounts()) != null && bankAccounts.size() > 0) {
            customerBankAccount = (BankAccount)bankAccounts.get(0);
        }
        if (customerBankAccount != null) {
            parameters.put(KEY_CUSTOMER_BANK_NAME, customerBankAccount.getBankName());
            parameters.put(KEY_CUSTOMER_BANK_BIK, customerBankAccount.getBik());
            parameters.put(KEY_CUSTOMER_BANK_CITY, customerBankAccount.getCity() != null ? customerBankAccount.getCity().toString() : null);
            parameters.put(KEY_CUSTOMER_BANK_LORO_ACCOUNT, customerBankAccount.getCorrespondentAccount());
            parameters.put(KEY_CUSTOMER_BANK_SETTLEMENT_ACCOUNT, customerBankAccount.getSettlementAccount());
        }
        if ((bankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)document.getSupplierBankAccount(), (EntityStorageContext)storageContext)) == null) {
            bankAccount = agency.getFinanceDocumentProperties().getBankAccount();
        }
        if (bankAccount == null && !agency.getBankAccounts().isEmpty()) {
            bankAccount = (BankAccount)agency.getBankAccounts().get(0);
        }
        if (bankAccount != null) {
            parameters.put(KEY_AGENCY_BANK_NAME, bankAccount.getBankName());
            parameters.put(KEY_AGENCY_BANK_BIK, bankAccount.getBik());
            parameters.put(KEY_AGENCY_BANK_CITY, bankAccount.getCity() != null ? bankAccount.getCity().toString() : null);
            parameters.put(KEY_AGENCY_BANK_LORO_ACCAUNT, bankAccount.getCorrespondentAccount());
            parameters.put(KEY_AGENCY_BANK_SETTLEMENT_ACCAUNT, bankAccount.getSettlementAccount());
        }
        parameters.put(KEY_AGENT_NAME, (agent = (Person)Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getAgent(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null)) != null ? nameFormatter.format((PersonalLocalizableName)agent, locale, false) : null);
        if (settings != null) {
            for (Signature signature : settings.getSignatures()) {
                AuthorityLetter authorityLetter;
                if (signature.getPosition() == null) continue;
                Person signer = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)signature.getSigner(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
                if (signer != null && signer.getEmployments().stream().filter(item -> item.getOrganization() != null && item.getOrganization().equals((Object)document.getSupplier())).anyMatch(item -> MiscUtil.isBetween((Date)item.getOpened(), (Date)item.getClosed(), (Date)(document.getDate() != null ? document.getDate() : new Date())))) {
                    String name = nameFormatter.format((PersonalLocalizableName)signer, locale, false);
                    parameters.put(String.format("AGENCY_%s_NAME", signature.getPosition().getCode()), name);
                    String title = signature.getTitle().toString(locale);
                    if (TextUtil.isBlank((String)title)) {
                        title = signature.getPosition().toString(locale);
                    }
                    parameters.put(String.format("AGENCY_%s_TITLE", signature.getPosition().getCode()), title);
                    parameters.put(String.format("AGENCY_%s_COMMENT", signature.getPosition().getCode()), signature.getComment());
                    parameters.put(String.format("AGENCY_%s_SIGNER", signature.getPosition().getCode()), signer);
                    parameters.put(String.format("AGENCY_%s_SIGNER_SIGNATURE_POSITION", signature.getPosition().getCode()), DictionaryCache.get().resolveReference(signature.getPosition()));
                    parameters.put(String.format("AGENCY_%s_SIGNER_SIGNATURE_TITLE", signature.getPosition().getCode()), signature.getTitle());
                }
                Person delegate = Optional.ofNullable(document.isUseDelegate() ? EntityStorageHelper.resolve((EntityReference)document.getAgent(), (EntityStorageContext)storageContext) : null).map(EntityContainer::getEntity).orElse(null);
                AuthorityLetter authorityLetter2 = authorityLetter = delegate != null ? FinanceDocumentHelper.getAuthorityLetter(delegate, (DictionaryReference<PersonPosition>)signature.getPosition(), document.getType(), document.getDate()) : null;
                if (delegate != null && authorityLetter != null) {
                    String name = nameFormatter.format((PersonalLocalizableName)delegate, locale, false);
                    parameters.put(String.format("AGENCY_%s_DELEGATE_NAME", signature.getPosition().getCode()), name);
                    parameters.put(String.format("AGENCY_%s_DELEGATE_AUTHORITY_LETTER_NAME", signature.getPosition().getCode()), authorityLetter.getName());
                    parameters.put(String.format("AGENCY_%s_DELEGATE_AUTHORITY_LETTER_NUMBER", signature.getPosition().getCode()), authorityLetter.getNumber());
                    parameters.put(String.format("AGENCY_%s_DELEGATE_AUTHORITY_LETTER_DATE", signature.getPosition().getCode()), authorityLetter.getDate());
                    parameters.put(String.format("AGENCY_%s_DELEGATE_SIGNER", signature.getPosition().getCode()), delegate);
                    delegate.getEmployments().stream().filter(item -> MiscUtil.equals((Object)item.getOrganization(), (Object)document.getSupplier(), (boolean)false) && MiscUtil.isBetween((Date)item.getOpened(), (Date)item.getClosed(), (Date)(document.getDate() != null ? document.getDate() : new Date())) && item.getPosition() != null).map(item -> (PersonPosition)DictionaryCache.get().resolveReference(item.getPosition())).filter(Objects::nonNull).findFirst().ifPresent(item -> parameters.put(String.format("AGENCY_%s_DELEGATE_POSITION", signature.getPosition().getCode()), MiscUtil.findByLocale((Map)item.getTranslations(), (Locale)LocaleUtil.createNormalizedLocale((Locale)locale))));
                    if (!document.isUseFacsimile() || delegate.getSignatureImage() == null) continue;
                    ImageUtil.ImageData imageData = new ImageUtil.ImageData(delegate.getSignatureImage());
                    parameters.put(String.format("AGENCY_%s_SIGNATURE_BYTES", signature.getPosition().getCode()), delegate.getSignatureImage());
                    parameters.put(String.format("AGENCY_%s_SIGNATURE", signature.getPosition().getCode()), imageData.getData());
                    parameters.put(String.format("AGENCY_%s_SIGNATURE_WIDTH", signature.getPosition().getCode()), imageData.getWidth());
                    parameters.put(String.format("AGENCY_%s_SIGNATURE_HEIGHT", signature.getPosition().getCode()), imageData.getHeight());
                    continue;
                }
                if (signer == null || !document.isUseFacsimile() || signer.getSignatureImage() == null) continue;
                parameters.put(String.format("AGENCY_%s_SIGNATURE_BYTES", signature.getPosition().getCode()), signer.getSignatureImage());
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(signer.getSignatureImage());
                parameters.put(String.format("AGENCY_%s_SIGNATURE", signature.getPosition().getCode()), new ByteArrayInputStream(signer.getSignatureImage()));
                parameters.put(String.format("AGENCY_%s_SIGNATURE_WIDTH", signature.getPosition().getCode()), imageData.getWidth());
                parameters.put(String.format("AGENCY_%s_SIGNATURE_HEIGHT", signature.getPosition().getCode()), imageData.getHeight());
            }
            if (document.isUseFacsimile()) {
                if (settings.getStamp() != null) {
                    parameters.put(KEY_STAMP, new ByteArrayInputStream(settings.getStamp()));
                }
                if (agent != null && agent.getSignatureImage() != null) {
                    ImageUtil.ImageData imageData = new ImageUtil.ImageData(agent.getSignatureImage());
                    parameters.put(KEY_AGENT_SIGNATURE, imageData.getData());
                    parameters.put(KEY_AGENT_SIGNATURE_WIDTH, imageData.getWidth());
                    parameters.put(KEY_AGENT_SIGNATURE_HEIGHT, imageData.getHeight());
                }
            }
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.organization.name(), (Object)document.getCustomer()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.position.name(), (Object)new PersonPositionReference(ManagerType.DIRECTOR.name())));
        query.setLimit(1);
        List data = EntityStorage.get().search(PersonEmploymentIndex.class, query).getData();
        if (!data.isEmpty()) {
            Person employee = (Person)EntityStorage.get().resolve(((PersonEmploymentIndex)data.get(0)).getSource()).getEntity();
            String fullName = ProfileHelper.getFullName((Person)employee, (Locale)locale, (boolean)false);
            parameters.put(KEY_CUSTOMER_DIRECTOR, fullName);
        }
        this.fillCustomerSignerParameters(parameters, document, storageContext, locale);
        if (payerBaseProfile instanceof Organization) {
            payer = (Organization)payerBaseProfile;
            List payerAddresses = ProfileHelper.getOrganizationAddresses((Organization)payer, (Date)document.getDate());
            parameters.put(KEY_PAYER_NAME, ProfileHelper.getFullName((String)payer.getCode(), (L10nString)payer.getShortName(), (L10nString)payer.getFullName(), (DictionaryReference)payer.getLegalForm(), (Locale)locale, (boolean)false, (!document.isDisableCustomerQuotes() ? 1 : 0) != 0));
            parameters.put(KEY_PAYER_NAME_EN, ProfileHelper.getFullName((String)payer.getCode(), (L10nString)payer.getShortName(), (L10nString)payer.getFullName(), (DictionaryReference)payer.getLegalForm(), (Locale)LocaleHelper.EN_LOCALE, (boolean)true, (!document.isDisableCustomerQuotes() ? 1 : 0) != 0));
            parameters.put(KEY_PAYER_FULLNAME, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)payer.getLegalForm(), (Locale)locale), payer.getFullName(), (String)HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)document.getDate()), (String)HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)document.getDate()), payerAddresses, AddressType.LEGAL, payer.getBankAccounts(), locale, false));
            parameters.put(KEY_PAYER_FULLNAME_FACTUAL, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)payer.getLegalForm(), (Locale)locale), payer.getFullName(), (String)HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)document.getDate()), (String)HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)document.getDate()), payerAddresses, AddressType.FACTUAL, payer.getBankAccounts(), locale, false));
            parameters.put(KEY_PAYER_ADDRESS, this.buildAddress(payerAddresses, AddressType.LEGAL, locale));
            parameters.put(KEY_PAYER_LEGAL_ADDRESS, payerAddresses.stream().filter(item -> item.getAddressType() == AddressType.LEGAL).findFirst().orElse(null));
            parameters.put(KEY_PAYER_PHONE, this.buildPhone(payer.getCommunications(), CommunicationType.WORK_PHONE));
            parameters.put(KEY_PAYER_FAX, this.buildPhone(payer.getCommunications(), CommunicationType.FAX));
            parameters.put(KEY_PAYER_INN, HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)document.getDate()));
            parameters.put(KEY_PAYER_KPP, HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)document.getDate()));
            parameters.put(KEY_PAYER_BIN, HistoricalValueHelper.getValue((List)payer.getBinHistory(), (Date)document.getDate()));
            Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)payer.getHolding(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).ifPresent(holding -> parameters.put(KEY_PAYER_HOLDING_NAME, ProfileHelper.getFullName((String)holding.getCode(), (L10nString)holding.getShortName(), (L10nString)holding.getFullName(), (DictionaryReference)holding.getLegalForm(), (Locale)locale, (boolean)false, (!document.isDisableCustomerQuotes() ? 1 : 0) != 0)));
        } else if (payerBaseProfile instanceof Person) {
            payer = (Person)payerBaseProfile;
            String name = this.getPersonName((Person)payer, locale, storageContext);
            parameters.put(KEY_PAYER_NAME, name);
            parameters.put(KEY_PAYER_NAME_EN, this.getPersonName((Person)payer, LocaleHelper.EN_LOCALE, storageContext));
            parameters.put(KEY_PAYER_FULLNAME, name);
            parameters.put(KEY_PAYER_FULLNAME_FACTUAL, name);
            parameters.put(KEY_PAYER_ADDRESS, this.buildAddress(payer.getAddresses(), AddressType.LEGAL, locale));
            parameters.put(KEY_PAYER_LEGAL_ADDRESS, payer.getAddresses().stream().filter(item -> item.getAddressType() == AddressType.LEGAL).findFirst().orElse(null));
            parameters.put(KEY_PAYER_PHONE, this.buildPhone(payer.getCommunications(), CommunicationType.WORK_PHONE));
            parameters.put(KEY_PAYER_FAX, this.buildPhone(payer.getCommunications(), CommunicationType.FAX));
            parameters.put(KEY_PAYER_INN, null);
            parameters.put(KEY_PAYER_KPP, null);
            parameters.put(KEY_PAYER_BIN, null);
        }
        String captionTemplate = document.getCaptionTemplate();
        if (TextUtil.nonBlank((String)captionTemplate)) {
            parameters.put(KEY_CAPTION_TEMPLATE, Format.of((String)captionTemplate).format(Format.FormatObjectDataBuilder.get().object((Object)document, ModelFormatObjects.FINANCE_DOCUMENT.getId()).build(), storageContext));
        }
        parameters.put(KEY_CONTAINS_HOTEL_PRODUCT, products.stream().anyMatch(baseProduct -> baseProduct instanceof HotelProduct));
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(LocaleHelper.RU_LOCALE.equals(locale) ? (char)' ' : ',');
        dfs.setDecimalSeparator(LocaleHelper.RU_LOCALE.equals(locale) ? (char)',' : '.');
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00", dfs);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        parameters.put(KEY_DECIMAL_FORMAT, decimalFormat);
        parameters.putAll(document.getCustomParameters());
    }

    private void fillCustomerSignerParameters(Map<String, Object> parameters, FinanceDocument document, EntityStorageContext storageContext, Locale locale) {
        Person delegate = null;
        AuthorityLetter authorityLetter = null;
        Object imageData = null;
        FinanceDocumentsProperties properties = FinanceDocumentHelper.getFinanceDocumentsProperties((EntityReference<Organization>)document.getCustomer(), true);
        if (properties == null) {
            return;
        }
        FinanceDocumentSettings settings = properties.getFinanceDocumentsSettings().stream().filter(item -> item.getType() == document.getType()).findFirst().orElse(null);
        if (settings == null) {
            return;
        }
        Signature signature = settings.getSignatures().stream().filter(item -> TextUtil.nonBlank((String)item.getTitle().toString(locale))).filter(item -> item.getSigner() != null).findFirst().orElse(null);
        if (signature == null) {
            return;
        }
        Person signer = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)signature.getSigner(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
        if (signer != null) {
            if (signer.getEmployments().stream().filter(item -> item.getOrganization() != null && item.getOrganization().equals((Object)document.getCustomer())).anyMatch(item -> MiscUtil.isBetween((Date)item.getOpened(), (Date)item.getClosed(), (Date)(document.getDate() != null ? document.getDate() : new Date())))) {
                String name = nameFormatter.format((PersonalLocalizableName)signer, locale, false);
                parameters.put(KEY_CUSTOMER_SIGNER_NAME, name);
                parameters.put(KEY_CUSTOMER_SIGNER_TITLE, signature.getTitle().toString(locale));
                parameters.put(KEY_CUSTOMER_SIGNER, signer);
                parameters.put(KEY_CUSTOMER_SIGNATURE_TITLE, signature.getTitle());
            }
            if (signer.getSignatureImage() != null) {
                imageData = new ImageUtil.ImageData(signer.getSignatureImage());
            }
        }
        if (document.isUseDelegate()) {
            Date date = new Date();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.organization.name(), (Object)document.getCustomer()));
            ArrayList<SearchCriterion> criterionsStartDate = new ArrayList<SearchCriterion>();
            criterionsStartDate.add(SearchCriterion.le((String)PersonEmploymentIndex.Property.workStartDate.name(), (Object)(document.getDate() != null ? document.getDate() : date)));
            criterionsStartDate.add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.workStartDate.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterionsStartDate.toArray(new SearchCriterion[0])));
            ArrayList<SearchCriterion> criterionsEndDate = new ArrayList<SearchCriterion>();
            criterionsEndDate.add(SearchCriterion.ge((String)PersonEmploymentIndex.Property.workEndDate.name(), (Object)(document.getDate() != null ? document.getDate() : date)));
            criterionsEndDate.add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.workEndDate.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterionsEndDate.toArray(new SearchCriterion[0])));
            query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)PersonEmploymentIndex.Property.authorityLettersUids.name()));
            List data = EntityStorage.get().search(PersonEmploymentIndex.class, query).getData();
            for (PersonEmploymentIndex index : data) {
                delegate = (Person)EntityStorage.get().resolve(index.getSource()).getEntity();
                if (delegate != null) {
                    authorityLetter = this.getCustomerAuthorityLetter(delegate, document);
                }
                if (authorityLetter == null) continue;
                break;
            }
            if (authorityLetter != null) {
                String name = nameFormatter.format(delegate, locale, false);
                parameters.put(KEY_CUSTOMER_DELEGATE_NAME, name);
                parameters.put(KEY_CUSTOMER_DELEGATE_AUTHORITY_LETTER_NAME, authorityLetter.getName());
                parameters.put(KEY_CUSTOMER_DELEGATE_AUTHORITY_LETTER_NUMBER, authorityLetter.getNumber());
                parameters.put(KEY_CUSTOMER_DELEGATE_AUTHORITY_LETTER_DATE, authorityLetter.getDate());
                parameters.put(KEY_CUSTOMER_DELEGATE, delegate);
                imageData = delegate.getSignatureImage() != null ? new ImageUtil.ImageData(delegate.getSignatureImage()) : null;
            }
        }
        if (document.isUseFacsimile()) {
            if (imageData != null) {
                parameters.put(KEY_CUSTOMER_SIGNATURE, imageData.getData());
                parameters.put(KEY_CUSTOMER_SIGNATURE_WIDTH, imageData.getWidth());
                parameters.put(KEY_CUSTOMER_SIGNATURE_HEIGHT, imageData.getHeight());
            }
            if (settings.getStamp() != null) {
                parameters.put(KEY_CUSTOMER_STAMP, new ByteArrayInputStream(settings.getStamp()));
            }
        }
    }

    private boolean isRefundFinanceDocument(FinanceDocument financeDocument, EntityStorageContext storageContext) {
        for (BillingItem item : FinanceDocumentHelper.getBillingItems(financeDocument.getBillingItems(), storageContext)) {
            ProductHandler productHandler;
            BaseProduct baseProduct;
            if (item.getProduct() == null || (baseProduct = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext)) == null || (productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass())) == null) continue;
            ProductStatus status = productHandler.getStatus(baseProduct);
            if (status == ProductStatus.REFUND || ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                return true;
            }
            if (productHandler.getMCOCategory(baseProduct) == null || !productHandler.getMCOCategory(baseProduct).equals((Object)MCOCategory.RETURN_FARE_DIFFERENCE)) continue;
            return true;
        }
        return false;
    }

    private String buildOrganizationFullName(String legalForm, L10nString fullName, String inn, String kpp, List<Address> addresses, AddressType addressType, List<BankAccount> accounts, Locale locale, boolean strict) {
        String bankAccounts;
        String address;
        StringBuilder sb = new StringBuilder();
        String name = this.buildOrganizationName(legalForm, fullName, locale, strict);
        if (!TextUtil.isBlank((String)name)) {
            sb.append(name);
        }
        if (!TextUtil.isBlank((String)(address = this.buildAddress(addresses, addressType, locale)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(address);
        }
        if (!TextUtil.isBlank((String)inn) && !TextUtil.isBlank((String)kpp)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(String.format("\u0418\u041d\u041d/\u041a\u041f\u041f %s/%s", inn.trim(), kpp.trim()));
        }
        if (!TextUtil.isBlank((String)(bankAccounts = this.buildBankAccounts(accounts)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bankAccounts);
        }
        return sb.toString();
    }

    private String buildOrganizationName(String legalForm, L10nString fullName, Locale locale, boolean strict) {
        String fullNameString;
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)legalForm)) {
            sb.append(legalForm);
        }
        if (!TextUtil.isBlank((String)(fullNameString = L10nStringHelper.getValue((L10nString)fullName, (Locale)locale, (boolean)strict)))) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(fullNameString.trim());
        }
        return sb.toString();
    }

    private String buildAddress(List<? extends Address> addresses, AddressType addressType, Locale locale) {
        for (Address address : addresses) {
            if (address.getAddressType() != addressType) continue;
            return ProfileHelper.buildFullAddress((Address)address, (Locale)locale, (boolean)false);
        }
        return null;
    }

    private String buildBankAccounts(List<BankAccount> bankAccounts) {
        if (bankAccounts.isEmpty()) {
            return null;
        }
        BankAccount account = bankAccounts.get(0);
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank((String)account.getBankName())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(account.getBankName());
        }
        if (!TextUtil.isBlank((String)account.getSettlementAccount())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u0440\u0430\u0441\u0447.\u0441\u0447\u0435\u0442:").append(account.getSettlementAccount());
        }
        if (!TextUtil.isBlank((String)account.getBik())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u0411\u0418\u041a:").append(account.getBik());
        }
        if (!TextUtil.isBlank((String)account.getCorrespondentAccount())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u043a\u043e\u0440.\u0441\u0447\u0435\u0442:").append(account.getCorrespondentAccount());
        }
        return result.toString();
    }

    private String getFullLegalForm(DictionaryReference<LegalForm> legalForm, Locale loc) {
        Locale locale;
        LegalForm form = (LegalForm)DictionaryCache.get().resolveReference(legalForm);
        if (form == null || form.getTranslations().isEmpty()) {
            return null;
        }
        Locale locale2 = locale = loc != null ? loc : LocaleManager.get().getCurrentLocale();
        if (form.getTranslations().containsKey(locale)) {
            return (String)form.getTranslations().get(locale);
        }
        return (String)form.getTranslations().values().iterator().next();
    }

    private String buildPhone(List<? extends Communication> communications, CommunicationType communicationType) {
        StringBuilder builder = new StringBuilder();
        for (Communication communication : communications) {
            if (communication.getType() != communicationType) continue;
            if (TextUtil.nonBlank((String)communication.getCountryCode()) && TextUtil.nonBlank((String)communication.getCityCode())) {
                builder.append("+").append(communication.getCountryCode().replaceAll("\\D", "")).append(" (").append(communication.getCityCode().replaceAll("\\D", "")).append(") ");
            }
            if (TextUtil.nonBlank((String)communication.getSense())) {
                builder.append(communication.getSense().trim());
            }
            if (builder.length() == 0) continue;
            return builder.toString();
        }
        return null;
    }

    private AuthorityLetter getCustomerAuthorityLetter(Person person, FinanceDocument document) {
        return person.getAuthorityLetters().stream().filter(item -> item.getPositions().size() == 0 && TextUtil.nonBlank((String)item.getNumber()) && item.getDate() != null && (item.getFinanceDocumentTypes().size() == 0 || item.getFinanceDocumentTypes().contains(document.getType())) && MiscUtil.isBetween((Date)item.getStartDate(), (Date)item.getEndDate(), (Date)document.getDate())).findFirst().orElse(null);
    }

    private String getPersonName(Person person, Locale locale, EntityStorageContext storageContext) {
        return Format.of((String)String.format("[value={id=%s:%s}][padding= |value={id=%s:%s}][padding= |value={id=%s:%s}][padding= |value={id=%s:%s}]", ModelFormatObjects.PERSON.getId(), ModelFormatObjectPersonProperties.LAST_NAME.getId(), ModelFormatObjects.PERSON.getId(), ModelFormatObjectPersonProperties.FIRST_NAME.getId(), ModelFormatObjects.PERSON.getId(), ModelFormatObjectPersonProperties.MIDDLE_NAME.getId(), ModelFormatObjects.PERSON.getId(), ModelFormatObjectPersonProperties.SECOND_NAME.getId())).format(Format.FormatObjectDataBuilder.get().object((Object)person, ModelFormatObjects.PERSON.getId()).build(), storageContext, locale);
    }
}

