/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.render;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;

public class FinanceDocumentsRenderLoadFinanceDocumentsSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        FinanceDocument document = (FinanceDocument)documentContainer.getEntity();
        EntityReference supplierReference = document.getSupplier();
        FinanceDocumentsProperties properties = FinanceDocumentHelper.getFinanceDocumentsProperties((EntityReference<Organization>)supplierReference, false);
        if (properties == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.FinanceDocuments_renderFinanceDocumentsPropertiesNotDefined, (String)L10nResourcesManager.getStr((String)Messages.FinanceDocuments_renderFinanceDocumentsPropertiesNotFound, (Object[])new Object[]{supplierReference}), (Object[])new Object[0]));
            throw new Exception("preparing failed");
        }
        FinanceDocumentType type = document.getType();
        FinanceDocumentSettings financeDocumentsSettings = properties.getFinanceDocumentsSettings().stream().filter(item -> item.getType() == type).findFirst().orElse(null);
        if (financeDocumentsSettings == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.FinanceDocuments_renderFinanceDocumentsSettingsNotDefined, (String)L10nResourcesManager.getStr((String)Messages.FinanceDocuments_renderFinanceDocumentsSettingsNotFound, (Object[])new Object[]{type, supplierReference}), (Object[])new Object[0]));
            throw new Exception("preparing failed");
        }
        context.putObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_SETTINGS, (Object)financeDocumentsSettings);
    }
}

