/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.render;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class FinanceDocumentsRenderLoadTemplateProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        FinanceDocument document = (FinanceDocument)documentContainer.getEntity();
        EntityReference templateReference = document.getTemplate();
        if (templateReference == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderTemplateNotDefined).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_renderTemplateEmpty, (Object[])new Object[0])).build());
            throw new Exception("preparing failed");
        }
        EntityContainer templateContainer = EntityStorageHelper.resolve((EntityReference)templateReference, (EntityStorageContext)storageContext);
        if (templateContainer == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderTemplateNotFound).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_renderTemplateLoadFailed, (Object[])new Object[]{templateReference})).build());
            throw new Exception("preparing failed");
        }
        context.putObject((Enum)IBusFinanceContextKeys.TEMPLATE_CONTAINER, (Object)templateContainer);
    }
}

