/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents.render;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class FinanceDocumentsRenderVerifyFinanceDocumentCommonProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        FinanceDocument document = (FinanceDocument)documentContainer.getEntity();
        EntityReference supplier = document.getSupplier();
        if (supplier == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderSupplierNotDefined).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[]{documentContainer.toReference()})).build());
            throw new Exception("verification failed");
        }
        EntityReference customer = document.getCustomer();
        if (customer == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderCustomerNotDefined).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[]{documentContainer.toReference()})).build());
            throw new Exception("verification failed");
        }
        EntityReference payer = document.getPayer();
        if (payer == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderPayerNotDefined).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[]{documentContainer.toReference()})).build());
            throw new Exception("verification failed");
        }
        EntityReference contract = document.getContract();
        if (contract == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderContractNotDefined).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[]{documentContainer.toReference()})).build());
            throw new Exception("verification failed");
        }
        DictionaryReference currency = document.getCurrency();
        if (currency == null) {
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceDocuments_renderCurrencyNotDefined).details(L10nResourcesManager.getStr((String)Messages.FinanceDocuments_valueEmpty, (Object[])new Object[]{documentContainer.toReference()})).build());
            throw new Exception("verification failed");
        }
    }
}

