/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class FinDocsCalculateContractProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityReference supplier = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SUPPLIER_REFERENCE);
        EntityReference customer = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CUSTOMER_REFERENCE);
        EntityReference ref = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)GeneralProductHelper.getContractType((EntityReference)ref)));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer));
        List contractIdx = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        if (!contractIdx.isEmpty()) {
            ContractCustomerIndex info = (ContractCustomerIndex)contractIdx.get(0);
            shipment.setContract(new NestedEntityReference(info.getSource(), info.getNavigationKey(), ContractCustomerInfo.class, info.getNumber()));
        }
    }
}

