/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class FinDocsCalculateCustomerProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List productsRefs = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        EntityReference relationDescriptionRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityReference customerDescriptionRef = ((ContractRelationDescription)EntityStorage.get().resolve(relationDescriptionRef).getEntity()).getCustomer();
        EntityReference result = null;
        for (NestedEntityReference productRef : productsRefs) {
            EntityReference customer;
            BaseProduct bp = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)sc);
            if (GeneralProductHelper.getContractType((EntityReference)relationDescriptionRef) == ContractType.CLIENT) {
                customer = bp.getReservation().getBookingFile().getCustomerProfile();
            } else {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                SalesChain chain = handler.getSalesChain(bp);
                customer = GeneralProductHelper.getContractor((SalesChain)chain, (EntityReference)customerDescriptionRef);
            }
            if (result != null && customer != null && !result.equals((Object)customer)) {
                throw Xeption.forEndUser((String)"FinDocsCalculateCustomerProcessor_different\u0421ounterparties", (Object[])new Object[0]);
            }
            result = customer;
        }
        if (result == null) {
            throw Xeption.forEndUser((String)"FinDocsCalculateCustomerProcessor_failedToIdentifyThe\u0421ounterparty", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_CUSTOMER_REFERENCE, result);
    }
}

