/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Iterator;
import java.util.List;

public class FinDocsCalculatePayerProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List productsRefs = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        EntityReference relationDescriptionRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityReference customerDescriptionRef = ((ContractRelationDescription)EntityStorage.get().resolve(relationDescriptionRef).getEntity()).getCustomer();
        EntityReference result = null;
        BaseProduct resultProduct = null;
        for (NestedEntityReference productRef : productsRefs) {
            BaseProduct bp = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)sc);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            EntityReference payer = null;
            for (GeneralProductContractRelationData data : handler.getUnmodifiableContractRelations(bp)) {
                Iterator iterator;
                if (!relationDescriptionRef.equals((Object)data.getDescription()) || !(iterator = data.getFops().iterator()).hasNext()) continue;
                payer = ((GeneralProductFop)iterator.next()).getPayer();
            }
            if (null == payer) {
                if (GeneralProductHelper.getContractType((EntityReference)relationDescriptionRef) == ContractType.CLIENT) {
                    payer = bp.getReservation().getBookingFile().getCustomerProfile();
                } else {
                    SalesChain chain = handler.getSalesChain(bp);
                    payer = GeneralProductHelper.getContractor((SalesChain)chain, (EntityReference)customerDescriptionRef);
                }
            }
            if (result != null && payer != null && !result.equals(payer)) {
                EntityContainer payerOrganization = EntityStorage.get().resolve(payer);
                String payerOrganizationString = payerOrganization != null ? ((Organization)payerOrganization.getEntity()).toString() : payer.getCaption();
                EntityContainer resultOrganization = EntityStorage.get().resolve(result);
                String resultOrganizationString = resultOrganization != null ? ((Organization)resultOrganization.getEntity()).toString() : result.getCaption();
                ProductHandler resultHandler = GeneralProductHelper.getHandler((BaseProduct)resultProduct);
                throw Xeption.forEndUser((String)"FinDocsCalculatePayerProcessor_differentPayers", (Object[])new Object[]{payerOrganizationString, handler.generateShortProductName(bp), resultOrganizationString, resultHandler.generateShortProductName(resultProduct)});
            }
            if (payer == null) continue;
            result = payer;
            resultProduct = bp;
        }
        if (result == null) {
            throw Xeption.forEndUser((String)"FinDocsCalculatePayerProcessor_failedToIdentifyThePayer", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_PAYER_REFERENCE, result);
    }
}

