/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class FinDocsCalculateSupplierProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List productsRefs = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        EntityReference relationDescriptionRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityReference supplierDescriptionRef = ((ContractRelationDescription)EntityStorage.get().resolve(relationDescriptionRef).getEntity()).getSupplier();
        EntityReference result = null;
        for (NestedEntityReference productRef : productsRefs) {
            BaseProduct bp = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)sc);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            SalesChain chain = handler.getSalesChain(bp);
            EntityReference contractor = GeneralProductHelper.getContractor((SalesChain)chain, (EntityReference)supplierDescriptionRef);
            if (result != null && contractor != null && !result.equals((Object)contractor)) {
                throw Xeption.forEndUser((String)"FinDocsCalculateSupplierProcessor_differentSuppliers", (Object[])new Object[0]);
            }
            result = contractor;
        }
        if (result == null) {
            throw Xeption.forEndUser((String)"FinDocsCalculateSupplierProcessor_failedToIdentifyTheSupplier", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SUPPLIER_REFERENCE, result);
    }
}

