/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Iterator;

public class FinDocsCheckCashOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean isRefund = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_REFUND_DOCUMENTS_FLAG);
        ServiceType serviceType = (ServiceType)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_SERVICE_TYPE);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItem billingItem = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        boolean accept = isRefund;
        if (accept && serviceType == ServiceType.FEE) {
            BigDecimal amount;
            BigDecimal bigDecimal = amount = billingItem.getAmount() != null ? billingItem.getAmount().getTotal() : null;
            if (amount != null && amount.compareTo(BigDecimal.ZERO) >= 0) {
                accept = false;
            } else {
                EntityContainer commissionPropertiesContainer = null;
                block0: for (NestedEntityReference fopRef : billingItem.getFops()) {
                    BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                    ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                    for (GeneralProductContractRelationData data : productHandler.getUnmodifiableContractRelations(baseProduct)) {
                        Iterator iterator = data.getCommissions().iterator();
                        if (!iterator.hasNext()) continue;
                        GeneralProductCommission commission = (GeneralProductCommission)iterator.next();
                        commissionPropertiesContainer = EntityStorageHelper.resolve((EntityReference)commission.getCommissionProperties(), (EntityStorageContext)sc);
                        break block0;
                    }
                }
                accept = false;
                if (commissionPropertiesContainer != null) {
                    BaseCommissionProperties commissionProperties = (BaseCommissionProperties)commissionPropertiesContainer.getEntity();
                    if (commissionProperties instanceof FeeProperties) {
                        FeeProperties fee = (FeeProperties)commissionProperties;
                        accept = fee.getOperation() != Operation.REFUND;
                    } else if (commissionProperties instanceof PaymentFeeProperties) {
                        accept = true;
                    }
                }
            }
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_ACCEPTED_FLAG, (Object)accept);
    }
}

