/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class FinDocsCleanupShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityReference shipmentRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCE);
        List productsRefs = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)sc);
        if (null == shipmentCtr) {
            throw Xeption.forEndUser((String)"FinDocsCleanupShipmentProcessor_noShipmentFound", (Object[])new Object[0]);
        }
        Shipment shipment = (Shipment)shipmentCtr.getEntity();
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER, (Object)shipmentCtr);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT, (Object)shipment);
        shipment.setDate(null);
        shipment.setNotes(null);
        shipment.setSupplier(null);
        shipment.setCustomer(null);
        shipment.setPayer(null);
        shipment.setContract(null);
        shipment.setAgent(null);
        for (Object itemRef : shipment.getBillingItems()) {
            BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
            for (NestedEntityReference fopRef : item.getFops()) {
                NestedEntityReference ref;
                BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                if (null == baseProduct || productsRefs.contains(ref = new NestedEntityReference(fopRef.getUid(), fopRef.getType(), baseProduct.getUid(), baseProduct.getClass(), baseProduct.toString()))) continue;
                productsRefs.add(ref);
            }
        }
        EntityContainer billingItemsList = null;
        for (Object ref : shipment.getBillingItems()) {
            EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)sc);
            if (null == billingItemsList) {
                billingItemsList = ctr;
            }
            if (ctr == null || ctr == billingItemsList) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)ctr, (EntityStorageContext)sc);
        }
        if (null != billingItemsList) {
            ((BillingItemsList)billingItemsList.getEntity()).getData().clear();
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEMS_LIST_CONTAINER, billingItemsList);
        shipment.getBillingItems().clear();
        EntityContainer paymentItemsList = null;
        for (NestedEntityReference ref : shipment.getPaymentItems()) {
            EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)sc);
            if (null == paymentItemsList) {
                paymentItemsList = ctr;
            }
            if (ctr == null || ctr == paymentItemsList) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)ctr, (EntityStorageContext)sc);
        }
        if (null != paymentItemsList) {
            ((PaymentItemsList)paymentItemsList.getEntity()).getData().clear();
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_PAYMENT_ITEMS_LIST_CONTAINER, paymentItemsList);
        shipment.getPaymentItems().clear();
        EnumSet<FinanceDocumentType> types = EnumSet.noneOf(FinanceDocumentType.class);
        Iterator iterator = shipment.getFinanceDocuments().iterator();
        while (iterator.hasNext()) {
            EntityReference ref = (EntityReference)iterator.next();
            EntityContainer financeDocumentCtr = EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)sc);
            if (financeDocumentCtr != null && ((FinanceDocument)financeDocumentCtr.getEntity()).getType() != null && !types.contains(((FinanceDocument)financeDocumentCtr.getEntity()).getType())) {
                FinanceDocument financeDocument = (FinanceDocument)financeDocumentCtr.getEntity();
                types.add(financeDocument.getType());
                financeDocument.setDate(null);
                financeDocument.setSupplier(null);
                financeDocument.setCustomer(null);
                financeDocument.setPayer(null);
                financeDocument.setAgent(null);
                financeDocument.setTemplate(null);
                financeDocument.setName(null);
                financeDocument.setSupplierBankAccount(null);
                financeDocument.setPayerBankAccount(null);
                financeDocument.setContent(null);
                financeDocument.getBillingItems().clear();
                financeDocument.getPaymentItems().clear();
                continue;
            }
            iterator.remove();
            if (financeDocumentCtr == null) continue;
            ((FinanceDocument)financeDocumentCtr.getEntity()).getRelatedShipments().remove(shipmentRef);
            if (!shipment.getFinanceDocuments().contains(ref)) {
                if (!((FinanceDocument)financeDocumentCtr.getEntity()).getRelatedShipments().isEmpty()) continue;
                EntityStorageHelper.deleteContainer((EntityContainer)financeDocumentCtr, (EntityStorageContext)sc);
                continue;
            }
            if (((FinanceDocument)financeDocumentCtr.getEntity()).getRelatedShipments().contains(shipmentRef)) continue;
            ((FinanceDocument)financeDocumentCtr.getEntity()).getRelatedShipments().add(shipmentRef);
        }
    }
}

