/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FinDocsCreateBillingItemsInShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER);
        this.log.debug(EntityStorageHelper.resolve((EntityReference)shipmentCtr.toReference(), (EntityStorageContext)sc).toString());
        EntityContainer listContainer = (EntityContainer)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEMS_LIST_CONTAINER);
        if (null == listContainer) {
            listContainer = EntityStorageHelper.createContainer(BillingItemsList.class, null, (EntityStorageContext)sc);
        }
        BillingItemsList list = (BillingItemsList)listContainer.getEntity();
        List billingItems = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEMS_LIST);
        Collections.sort(billingItems, new Comparator<BillingItem>(){

            @Override
            public int compare(BillingItem o1, BillingItem o2) {
                int type2;
                int type1 = this.getServiceTypeIndex(o1.getServiceType());
                if (type1 != (type2 = this.getServiceTypeIndex(o2.getServiceType()))) {
                    return type1 > type2 ? 1 : -1;
                }
                return TextUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)false, (boolean)true);
            }

            private int getServiceTypeIndex(ServiceType serviceType) {
                if (serviceType == null) {
                    return 5;
                }
                switch (serviceType) {
                    case TICKET: {
                        return 0;
                    }
                    case PENALTY: {
                        return 1;
                    }
                    case FEE: {
                        return 2;
                    }
                    case DISCOUNT: {
                        return 3;
                    }
                }
                return 4;
            }
        });
        list.getData().addAll(billingItems);
        for (BillingItem item : list.getData()) {
            shipment.getBillingItems().add(new NestedEntityReference(listContainer, (BaseEntity)item));
        }
    }
}

