/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.List;

public class FinDocsCreateEmptyBillingItemProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BillingItemData data = (BillingItemData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA);
        List billingItems = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEMS_LIST);
        BillingItem item = new BillingItem();
        ServiceType serviceType = null;
        int positionsCount = 0;
        if (!data.getProducts().isEmpty()) {
            positionsCount = data.getProducts().size();
            serviceType = ServiceType.TICKET;
        } else if (!data.getFees().isEmpty()) {
            positionsCount = data.getFees().size();
            serviceType = ServiceType.FEE;
        } else if (!data.getDiscounts().isEmpty()) {
            positionsCount = data.getDiscounts().size();
            serviceType = ServiceType.DISCOUNT;
        } else if (!data.getPenalties().isEmpty()) {
            positionsCount = data.getPenalties().size();
            serviceType = ServiceType.PENALTY;
        }
        item.setServiceType(serviceType);
        item.setPositionsCount(positionsCount);
        VatAmount amount = new VatAmount();
        amount.setTotalVatAmount(BigDecimal.ZERO, BigDecimal.ZERO);
        item.setAmount(amount);
        billingItems.add(item);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM, (Object)item);
    }
}

