/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FinDocsCreatePaymentItemsInShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityReference description = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityContainer listContainer = (EntityContainer)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_PAYMENT_ITEMS_LIST_CONTAINER);
        if (null == listContainer) {
            listContainer = EntityStorageHelper.createContainer(PaymentItemsList.class, null, (EntityStorageContext)sc);
        }
        PaymentItemsList list = (PaymentItemsList)listContainer.getEntity();
        HashMap<PaymentType, PaymentTypeData> payments = new HashMap<PaymentType, PaymentTypeData>();
        HashMap<Fop, PaymentTypeData> fops = new HashMap<Fop, PaymentTypeData>();
        for (NestedEntityReference nestedEntityReference : shipment.getBillingItems()) {
            BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)nestedEntityReference, (EntityStorageContext)sc);
            for (NestedEntityReference fopRef : item.getFops()) {
                Fop fop = (Fop)EntityStorageHelper.resolve((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                if (fops.get(fop) != null || fop.getType() == PaymentType.TICKET) continue;
                GeneralProductContractRelationData copyOfContractRelation = this.getCopyOfContractRelationData((NestedEntityReference<BookingFile, Fop>)fopRef, (EntityReference<ContractRelationDescription>)description, sc);
                GeneralProductFop generalProductFop = (GeneralProductFop)CollectionUtil.find((Iterable)copyOfContractRelation.getFops(), (String)fop.getUid());
                DictionaryReference currency = copyOfContractRelation.getGeneralData().getCurrency();
                BigDecimal amount = MiscUtil.nonNull((BigDecimal)generalProductFop.getEquivalentAmount());
                BaseProduct bp = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                ProductStatus status = handler.getStatus(bp);
                Money money = new Money();
                money.setCurrency(currency == null ? DictHelper.getEquivCurrency() : currency.getCode());
                money.setValue(amount);
                PaymentTypeData data = new PaymentTypeData(money);
                data.fops.add((NestedEntityReference<BookingFile, Fop>)fopRef);
                fops.put(fop, data);
            }
        }
        for (Map.Entry entry : fops.entrySet()) {
            Fop fop = (Fop)entry.getKey();
            PaymentTypeData data = (PaymentTypeData)entry.getValue();
            PaymentTypeData data2 = (PaymentTypeData)payments.get(fop.getType());
            if (data2 != null) {
                data2.money.setValue(data2.money.getValue().add(data.money.getValue()));
                data2.fops.addAll(data.fops);
                continue;
            }
            payments.put(fop.getType(), data);
        }
        for (Map.Entry entry : payments.entrySet()) {
            if (BigDecimal.ZERO.compareTo(((PaymentTypeData)entry.getValue()).money.getValue()) == 0) continue;
            PaymentItem paymentItem = new PaymentItem();
            paymentItem.setPaymentType((PaymentType)entry.getKey());
            paymentItem.setAmount(((PaymentTypeData)entry.getValue()).money);
            paymentItem.getFops().addAll(((PaymentTypeData)entry.getValue()).fops);
            list.getData().add(paymentItem);
            shipment.getPaymentItems().add(new NestedEntityReference(listContainer, (BaseEntity)paymentItem));
        }
    }

    private GeneralProductContractRelationData getCopyOfContractRelationData(NestedEntityReference<BookingFile, Fop> fopRef, EntityReference<ContractRelationDescription> descr, EntityStorageContext sc) {
        BaseProduct bp = BookingHelper.getProductByFop(fopRef, (EntityStorageContext)sc);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
        List relations = handler.getUnmodifiableContractRelations(bp);
        return (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, descr);
    }

    static class PaymentTypeData {
        final Money money;
        final List<NestedEntityReference<BookingFile, Fop>> fops = new LinkedList<NestedEntityReference<BookingFile, Fop>>();

        public PaymentTypeData(Money amount) {
            this.money = amount;
        }
    }
}

