/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

public class FinDocsDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = -1536008867847747749L;

    public void configure(Map<String, String> properties) {
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        String fileName;
        File folder = new File(Environment.getTempFolder(), "ibus-findocs/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date()));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (TextUtil.isBlank((String)(fileName = (String)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_LOG_FILENAME)))) {
            fileName = String.format("%s-%s.xml", data.getRouteId().substring(data.getRouteId().lastIndexOf(":") + 1), new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(new Date()));
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File(folder, fileName), (byte[])data.buildDebugInfo(true).getBytes());
        }
        catch (Exception e) {
            try {
                if (e instanceof FileNotFoundException) {
                    Thread.sleep(1000L);
                    FileUtils.writeByteArrayToFile((File)new File(folder, fileName), (byte[])data.buildDebugInfo(true).getBytes());
                }
            }
            catch (Exception e2) {
                LoggerFactory.getLogger(this.getClass()).error("unable to save traces to " + fileName, (Throwable)e2);
            }
        }
    }

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }
}

