/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.List;

public class FinDocsFillFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        FinanceDocumentsProperties properties = (FinanceDocumentsProperties)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_PROPERTIES);
        FinanceDocumentSettings settings = (FinanceDocumentSettings)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT_SETTINGS);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityReference payer = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PAYER_REFERENCE);
        List billingItems = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RELEVANT_BILLING_ITEMS);
        financeDocument.setAgent(shipment.getAgent());
        financeDocument.setCustomer(shipment.getCustomer());
        financeDocument.setDate(shipment.getDate());
        financeDocument.setPayer(shipment.getPayer());
        financeDocument.setSupplier(shipment.getSupplier());
        financeDocument.setTemplate(settings.getTemplate());
        financeDocument.setSupplierBankAccount(this.getBankAccount((EntityReference<? extends BaseProfile>)financeDocument.getSupplier(), sc));
        financeDocument.setPayerBankAccount(properties.getBankAccount() != null ? new NestedEntityReference(payer, (BaseEntity)properties.getBankAccount()) : null);
        String documentTitle = financeDocument.getType().toString();
        String numberPart = TextUtil.buildFullNumber((CompositeNumber)financeDocument);
        numberPart = !TextUtil.isBlank((String)numberPart) ? "\u2116" + numberPart : null;
        financeDocument.setName(TextUtil.combine((char)' ', (String[])new String[]{documentTitle, numberPart, financeDocument.getDate() != null ? "\u043e\u0442 " + new SimpleDateFormat("dd.MM.yyyy").format(financeDocument.getDate()) : null}));
        for (BillingItem billingItem : billingItems) {
            NestedEntityReference ref = null;
            for (NestedEntityReference item : shipment.getBillingItems()) {
                if (!billingItem.getUid().equals(item.getNestedEntityUid())) continue;
                ref = item;
                break;
            }
            financeDocument.getBillingItems().add(ref);
        }
    }

    private NestedEntityReference<Organization, BankAccount> getBankAccount(EntityReference<? extends BaseProfile> ref, EntityStorageContext sc) {
        if (!Organization.class.isAssignableFrom(ref.getType())) {
            return null;
        }
        EntityContainer \u0441ontainer = EntityStorageHelper.resolve(ref, (EntityStorageContext)sc);
        Organization organization = (Organization)\u0441ontainer.getEntity();
        BankAccount bankAccount = organization.getFinanceDocumentProperties().getBankAccount();
        if (bankAccount == null && !organization.getBankAccounts().isEmpty()) {
            bankAccount = (BankAccount)organization.getBankAccounts().get(0);
        }
        return bankAccount != null ? new NestedEntityReference(\u0441ontainer, (BaseEntity)bankAccount) : null;
    }
}

