/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.system.NumberGenerationType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;

public class FinDocsGenerateShipmentNumberProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        String externalNumber = (String)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_EXTERNAL_NUMBER);
        if (!TextUtil.isBlank((String)externalNumber)) {
            shipment.setNumber(externalNumber);
            return;
        }
        EntityReference shipmentRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCE);
        FinanceDocumentsProperties properties = (FinanceDocumentsProperties)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_PROPERTIES);
        NumberGenerationType numberGenerationType = NumberGenerationType.SEQUENTIAL;
        if (properties.getNumberGenerationType() != null) {
            numberGenerationType = properties.getNumberGenerationType();
        }
        HashMap<Shipment, String> numbersMap = new HashMap<Shipment, String>();
        numbersMap.put(shipment, shipment.getClass().getName());
        if (numberGenerationType == NumberGenerationType.PACKET) {
            SequenceNumberHelper.get().generateMax(numbersMap, "");
        } else {
            SequenceNumberHelper.get().generateInc(numbersMap, null);
        }
        shipmentRef.setCaption(shipment.getNumber());
    }
}

