/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class FinDocsGetAppropriateDocumentsSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        FinanceDocumentsProperties documentsProperties = (FinanceDocumentsProperties)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_PROPERTIES);
        ArrayList<FinanceDocumentSettings> documents = new ArrayList<FinanceDocumentSettings>();
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_SETTINGS_LIST, documents);
        List<FinanceDocumentType> types = this.getFinanceDocumentTypes(documentsProperties);
        for (FinanceDocumentType type : types) {
            FinanceDocumentSettings settings = FinDocsGetAppropriateDocumentsSettingsProcessor.getFinanceDocumentSettings(documentsProperties, sc, shipment, type);
            if (settings == null || settings.getTemplate() == null) continue;
            documents.add(settings);
        }
    }

    private List<FinanceDocumentType> getFinanceDocumentTypes(FinanceDocumentsProperties documentsProperties) {
        ArrayList<FinanceDocumentType> types = new ArrayList<FinanceDocumentType>();
        for (FinanceDocumentSettings settings : documentsProperties.getFinanceDocumentsSettings()) {
            if (!settings.isUseDocument() || settings.getType() == null) continue;
            types.add(settings.getType());
        }
        return types;
    }

    private static FinanceDocumentSettings getFinanceDocumentSettings(FinanceDocumentsProperties documentsProperties, EntityStorageContext sc, Shipment shipment, FinanceDocumentType type) throws Exception {
        for (FinanceDocumentSettings settings : documentsProperties.getFinanceDocumentsSettings()) {
            if (settings.getType() == null || !settings.getType().equals((Object)type)) continue;
            if (!settings.isUseSettings()) break;
            return settings;
        }
        for (NestedEntityReference billingItemRef : shipment.getBillingItems()) {
            BillingItem billingItem = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)billingItemRef, (EntityStorageContext)sc);
            block2: for (NestedEntityReference fopRef : billingItem.getFops()) {
                EntityContainer bookingFile = EntityStorageHelper.resolve((EntityReference)fopRef, (EntityStorageContext)sc);
                EntityContainer branchContainer = EntityStorage.get().resolve(BookingHelper.getBranch((BookingFile)((BookingFile)bookingFile.getEntity())));
                if (branchContainer == null) continue;
                for (FinanceDocumentSettings settings : ((Branch)branchContainer.getEntity()).getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                    if (settings.getType() == null || !settings.getType().equals((Object)type)) continue;
                    if (!settings.isUseSettings()) continue block2;
                    return settings;
                }
            }
        }
        return null;
    }
}

