/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.math.BigDecimal;

public class FinDocsGetAviaPenaltyProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT);
        BigDecimal penaltyValue = product.getPenalty();
        BigDecimal vat = AirProductHelper.getPenaltyVatAmount((Product)product);
        if (FinDocsHelper.isAppropriateMCO(product)) {
            penaltyValue = AirProductHelper.getEquivalentFare((Product)product);
            if (null == penaltyValue) {
                penaltyValue = BigDecimal.ZERO;
            }
            vat = BigDecimal.ZERO;
        }
        if (penaltyValue != null) {
            BigDecimal penalty = (BigDecimal)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_PENALTY);
            BigDecimal penaltyVat = (BigDecimal)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_PENALTY_VAT);
            penalty = penalty.add(penaltyValue);
            ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_PENALTY, (Object)penalty);
            if (null != penaltyVat) {
                penaltyVat = vat == null ? null : penaltyVat.add(vat);
                ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_PENALTY_VAT, (Object)penaltyVat);
            }
        }
    }
}

