/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemComponent;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.time.FastDateFormat;

public class FinDocsHelper {
    public static String getGroupInfo(List<BaseProduct> lst, ProductHandler<BaseProduct> handler, boolean useCyrillicTravellerName) {
        StringBuilder sb = new StringBuilder();
        for (BaseProduct product : lst) {
            String ticketNumber;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            List productNumbers = handler.getProductNumbers(product);
            Collection travellers = handler.getTravellers(product);
            Traveller traveller = travellers.isEmpty() ? null : (Traveller)travellers.iterator().next();
            String string = ticketNumber = productNumbers.isEmpty() ? null : (String)productNumbers.get(0);
            if (traveller != null) {
                sb.append(useCyrillicTravellerName ? traveller.getCyrillicName() : traveller.getName());
                if (handler.getStatus(product) == ProductStatus.BOOKING) continue;
                sb.append(": \u2116").append(productNumbers);
                continue;
            }
            if (handler.getStatus(product) == ProductStatus.BOOKING) continue;
            sb.append("\u2116 ").append(ticketNumber);
        }
        return sb.toString();
    }

    public static String buildPhone(List<Communication> communications, boolean fax) {
        Communication communication = null;
        CommunicationType type = fax ? CommunicationType.FAX : CommunicationType.WORK_PHONE;
        for (Communication comm : communications) {
            if (comm.getType() != type) continue;
            communication = comm;
            break;
        }
        if (communication == null) {
            return null;
        }
        return new CommunicationFormat("+C (T) N #I").format(communication);
    }

    public static String buildPersonPhone(List<PersonCommunication> communications, boolean fax) {
        Communication communication = null;
        CommunicationType type = fax ? CommunicationType.FAX : CommunicationType.WORK_PHONE;
        for (Communication communication2 : communications) {
            if (communication2.getType() != type) continue;
            communication = communication2;
            break;
        }
        if (communication == null) {
            return null;
        }
        return new CommunicationFormat("+C (T) N #I").format(communication);
    }

    public static String getFullLegalForm(DictionaryReference<LegalForm> legalForm, Locale loc) {
        Locale locale;
        LegalForm form = (LegalForm)DictionaryCache.get().resolveReference(legalForm);
        if (form == null || form.getTranslations().isEmpty()) {
            return null;
        }
        Locale locale2 = locale = loc != null ? loc : LocaleManager.get().getCurrentLocale();
        if (form.getTranslations().containsKey(locale)) {
            return (String)form.getTranslations().get(locale);
        }
        return (String)form.getTranslations().values().iterator().next();
    }

    public static String buildAddress(List<Address> addresses, AddressType addressType) {
        for (Address address : addresses) {
            if (address.getAddressType() != addressType) continue;
            return ProfileHelper.buildFullAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        }
        return null;
    }

    public static String buildPersonAddress(List<PersonAddress> addresses, AddressType addressType) {
        for (Address address : addresses) {
            if (address.getAddressType() != addressType) continue;
            return ProfileHelper.buildFullAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        }
        return null;
    }

    public static String buildOrganizationFullName(String legalForm, L10nString fullName, String inn, String kpp, List<Address> addresses, AddressType addressType, List<BankAccount> accounts, Locale locale, boolean strict) {
        String bankAccounts;
        String address;
        StringBuilder sb = new StringBuilder();
        String name = FinDocsHelper.buildOrganizationName(legalForm, fullName, locale, strict);
        if (!TextUtil.isBlank((String)name)) {
            sb.append(name);
        }
        if (!TextUtil.isBlank((String)(address = FinDocsHelper.buildAddress(addresses, addressType)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(address);
        }
        if (!TextUtil.isBlank((String)inn) && !TextUtil.isBlank((String)kpp)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(String.format("\u0418\u041d\u041d/\u041a\u041f\u041f %s/%s", inn.trim(), kpp.trim()));
        }
        if (!TextUtil.isBlank((String)(bankAccounts = FinDocsHelper.buildBankAccounts(accounts)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bankAccounts);
        }
        return sb.toString();
    }

    public static String buildPersonFullName(Person person, List<PersonAddress> addresses, AddressType addressType, List<BankAccount> accounts, Locale locale, boolean strict) {
        String bankAccounts;
        String address;
        StringBuilder sb = new StringBuilder();
        String name = ProfileHelper.getFullName((Person)person, (Locale)locale, (boolean)strict);
        if (!TextUtil.isBlank((String)name)) {
            sb.append(name);
        }
        if (!TextUtil.isBlank((String)(address = FinDocsHelper.buildPersonAddress(addresses, addressType)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(address);
        }
        if (!TextUtil.isBlank((String)(bankAccounts = FinDocsHelper.buildBankAccounts(accounts)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bankAccounts);
        }
        return sb.toString();
    }

    public static String buildOrganizationName(String legalForm, L10nString fullName, Locale locale, boolean strict) {
        String fullNameString;
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)legalForm)) {
            sb.append(legalForm);
        }
        if (!TextUtil.isBlank((String)(fullNameString = L10nStringHelper.getValue((L10nString)fullName, (Locale)locale, (boolean)strict)))) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(fullNameString.trim());
        }
        return sb.toString();
    }

    public static String buildBankAccounts(List<BankAccount> bankAccounts) {
        if (bankAccounts.isEmpty()) {
            return null;
        }
        BankAccount account = bankAccounts.get(0);
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank((String)account.getBankName())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(account.getBankName());
        }
        if (!TextUtil.isBlank((String)account.getSettlementAccount())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u0440\u0430\u0441\u0447.\u0441\u0447\u0435\u0442:").append(account.getSettlementAccount());
        }
        if (!TextUtil.isBlank((String)account.getBik())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u0411\u0418\u041a:").append(account.getBik());
        }
        if (!TextUtil.isBlank((String)account.getCorrespondentAccount())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u043a\u043e\u0440.\u0441\u0447\u0435\u0442:").append(account.getCorrespondentAccount());
        }
        return result.toString();
    }

    public static String getMoneyStr(BigDecimal totalPrice, Locale loc, String currency, boolean shortName) {
        Number2WordsConverter number2WordsConverter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(loc, currency);
        if (number2WordsConverter != null) {
            try {
                return TextUtil.capitalize((String)number2WordsConverter.toCurrencyWords(totalPrice, currency, false, false, false, shortName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getDateInWords(Date date, Locale locale) {
        FastDateFormat formater = FastDateFormat.getInstance((String)"dd MMMM yyyy", (Locale)locale);
        String str = formater.format(date);
        return FinDocsHelper.correntMonth(str, date, locale);
    }

    public static String getMonthInWords(Date date, Locale locale) {
        FastDateFormat formater = FastDateFormat.getInstance((String)"MMMM", (Locale)locale);
        String str = formater.format(date);
        return FinDocsHelper.correntMonth(str, date, locale);
    }

    private static String correntMonth(String str, Date date, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (calendar.get(2)) {
            case 0: {
                return str.replaceAll("(?i)\u042f\u043d\u0432\u0430\u0440\u044c", "\u042f\u043d\u0432\u0430\u0440\u044f");
            }
            case 1: {
                return str.replaceAll("(?i)\u0424\u0435\u0432\u0440\u0430\u043b\u044c", "\u0424\u0435\u0432\u0440\u0430\u043b\u044f");
            }
            case 2: {
                return str.replaceAll("(?i)\u041c\u0430\u0440\u0442", "\u041c\u0430\u0440\u0442\u0430");
            }
            case 3: {
                return str.replaceAll("(?i)\u0410\u043f\u0440\u0435\u043b\u044c", "\u0410\u043f\u0440\u0435\u043b\u044f");
            }
            case 4: {
                return str.replaceAll("(?i)\u041c\u0430\u0439", "\u041c\u0430\u044f");
            }
            case 5: {
                return str.replaceAll("(?i)\u0418\u044e\u043d\u044c", "\u0418\u044e\u043d\u044f");
            }
            case 6: {
                return str.replaceAll("(?i)\u0418\u044e\u043b\u044c", "\u0418\u044e\u043b\u044f");
            }
            case 7: {
                return str.replaceAll("(?i)\u0410\u0432\u0433\u0443\u0441\u0442", "\u0410\u0432\u0433\u0443\u0441\u0442\u0430");
            }
            case 8: {
                return str.replaceAll("(?i)\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044f");
            }
            case 9: {
                return str.replaceAll("(?i)\u041e\u043a\u0442\u044f\u0431\u0440\u044c", "\u041e\u043a\u0442\u044f\u0431\u0440\u044f");
            }
            case 10: {
                return str.replaceAll("(?i)\u041d\u043e\u044f\u0431\u0440\u044c", "\u041d\u043e\u044f\u0431\u0440\u044f");
            }
            case 11: {
                return str.replaceAll("(?i)\u0414\u0435\u043a\u0430\u0431\u0440\u044c", "\u0414\u0435\u043a\u0430\u0431\u0440\u044f");
            }
        }
        return str;
    }

    public static <E extends BaseCommissionProperties> String getFinanceName(EntityReference<E> propRef) {
        EntityContainer ctr = EntityStorage.get().resolve(propRef);
        if (ctr == null) {
            return null;
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        if (prop instanceof FeeProperties) {
            return ((FeeProperties)prop).getFinanceName();
        }
        if (prop instanceof DiscountProperties) {
            return ((DiscountProperties)prop).getFinanceName();
        }
        if (prop instanceof PaymentFeeProperties) {
            return ((PaymentFeeProperties)prop).getFinanceName();
        }
        return null;
    }

    public static <E extends BaseCommissionProperties> boolean isFeeForRefund(EntityReference<E> propRef) {
        EntityContainer ctr = EntityStorage.get().resolve(propRef);
        if (ctr == null) {
            return false;
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        if (prop instanceof FeeProperties) {
            return ((FeeProperties)prop).getOperation() == Operation.REFUND;
        }
        return false;
    }

    public static String getProductNumbersSplitValue(BaseProduct product) {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        return CollectionUtil.collectionToString((Iterable)handler.getProductNumbers(product), (String)"_", (boolean)true);
    }

    public static String buildLogFileName(String base, Collection<?> numbers, String postfix) {
        String str = numbers.size() > 5 ? numbers.size() + "-qt" : CollectionUtil.collectionToString(numbers, (String)"-", (boolean)true);
        return String.format(base, str, postfix);
    }

    public static boolean isAppropriateMCO(Product product) {
        return FinDocsHelper.isAppropriateMCO(product.getMcoCategory());
    }

    public static boolean isAppropriateMCO(MCOCategory m\u0441oCategory) {
        return MCOCategory.PENALTY == m\u0441oCategory || MCOCategory.REBOOKING == m\u0441oCategory || MCOCategory.INFORMATION == m\u0441oCategory || MCOCategory.EXCESS_LUGGAGE == m\u0441oCategory || MCOCategory.SPECIAL_FOOD == m\u0441oCategory || MCOCategory.SEAT_RESERVATION == m\u0441oCategory || MCOCategory.ADDITIONAL_SERVICES == m\u0441oCategory;
    }

    public static VatAmount getVatAmount(Collection<BillingItemComponent> components) {
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal vatAmount = null;
        Double rate = null;
        for (BillingItemComponent item : components) {
            total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, item.getAmount().getTotal()});
            if (item.getAmount().getVatAmount() == null) continue;
            vatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vatAmount, item.getAmount().getVatAmount()});
            if (item.getAmount().getVat() == null) continue;
            rate = item.getAmount().getVat();
        }
        VatAmount result = new VatAmount();
        if (vatAmount == null) {
            result.setTotalNoVat(total);
            return result;
        }
        if (total.compareTo(BigDecimal.ZERO) == 0) {
            if (rate == null) {
                result.setTotalNoVat(total);
                return result;
            }
            result.setTotalVat(total, rate.doubleValue());
            return result;
        }
        result.setTotalVatAmount(total, vatAmount);
        return result;
    }
}

