/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class FinDocsInitializeCashOrderTotalsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String moneyCode;
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        String currency = moneyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        BigDecimal totalCashOrder = BigDecimal.ZERO;
        HashSet<String> returnedTicketNumbers = new HashSet<String>();
        HashSet<EntityReference> returnedBlankOwners = new HashSet<EntityReference>();
        for (NestedEntityReference itemRef : financeDocument.getBillingItems()) {
            BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
            if (item.getAmount() == null || item.getAmount().getTotal() == null) continue;
            for (NestedEntityReference fopRef : item.getFops()) {
                BaseTicketProduct baseTicketProduct;
                BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                if (!(baseProduct instanceof BaseTicketProduct) || (baseTicketProduct = (BaseTicketProduct)baseProduct).getStatus() != ProductStatus.REFUND) continue;
                if (baseTicketProduct.getBlankOwnerRef() != null) {
                    returnedBlankOwners.add(baseTicketProduct.getBlankOwnerRef());
                }
                if (TextUtil.isBlank((String)baseTicketProduct.getSystemNumber())) continue;
                returnedTicketNumbers.add(baseTicketProduct.getSystemNumber());
            }
            totalCashOrder = totalCashOrder.subtract(item.getAmount().getTotal());
        }
        parameters.put(FinanceDocumentParametersKey.CASH_ORDER_TOTAL.name(), totalCashOrder);
        parameters.put(FinanceDocumentParametersKey.CASH_ORDER_TOTAL_STRING.name(), FinDocsHelper.getMoneyStr(totalCashOrder, locale, currency, false));
        parameters.put(FinanceDocumentParametersKey.CASH_ORDER_TOTAL_STRING_SHORT.name(), FinDocsHelper.getMoneyStr(totalCashOrder, locale, currency, true));
        StringBuilder sb = new StringBuilder("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432");
        if (!returnedBlankOwners.isEmpty()) {
            sb.append(" ");
        }
        boolean first = true;
        for (EntityReference bo : returnedBlankOwners) {
            sb.append(first ? " " : ", ");
            sb.append(bo.toString());
            first = false;
        }
        first = true;
        for (String tn : returnedTicketNumbers) {
            sb.append(first ? " " : ", ");
            sb.append(tn);
            first = false;
        }
        parameters.put(FinanceDocumentParametersKey.CASH_ORDER_SUBJECT.name(), sb.toString());
    }
}

