/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FinDocsInitializeCustomerParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        EntityReference customerRef = financeDocument.getCustomer();
        EntityContainer customerContainer = EntityStorageHelper.resolve((EntityReference)customerRef, (EntityStorageContext)sc);
        Organization customer = (Organization)customerContainer.getEntity();
        List customerAddresses = ProfileHelper.getOrganizationAddresses((Organization)customer, (Date)shipment.getDate());
        parameters.put(FinanceDocumentParametersKey.CUSTOMER.name(), ProfileHelper.getFullName((String)customer.getCode(), (L10nString)customer.getShortName(), (L10nString)customer.getFullName(), (DictionaryReference)customer.getLegalForm(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_NAME.name(), ProfileHelper.getFullName((String)customer.getCode(), (L10nString)customer.getShortName(), (L10nString)customer.getFullName(), null, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_FULLNAME.name(), FinDocsHelper.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)customer.getLegalForm(), (Locale)locale), customer.getFullName(), (String)HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)shipment.getDate()), (String)HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)shipment.getDate()), customerAddresses, AddressType.LEGAL, customer.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_ADDRESS.name(), FinDocsHelper.buildAddress(customerAddresses, AddressType.LEGAL));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_PHONE.name(), FinDocsHelper.buildPhone(customer.getCommunications(), false));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_FAX.name(), FinDocsHelper.buildPhone(customer.getCommunications(), true));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_INN.name(), HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)shipment.getDate()));
        parameters.put(FinanceDocumentParametersKey.CUSTOMER_KPP.name(), HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)shipment.getDate()));
        BankAccount customerBankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)financeDocument.getPayerBankAccount(), (EntityStorageContext)sc);
        if (customerBankAccount != null) {
            parameters.put(FinanceDocumentParametersKey.CUSTOMER_BANK_NAME.name(), customerBankAccount.getBankName());
            parameters.put(FinanceDocumentParametersKey.CUSTOMER_BANK_BIK.name(), customerBankAccount.getBik());
            parameters.put(FinanceDocumentParametersKey.CUSTOMER_BANK_CITY.name(), customerBankAccount.getCity() != null ? customerBankAccount.getCity().toString() : null);
            parameters.put(FinanceDocumentParametersKey.CUSTOMER_BANK_LORO_ACCOUNT.name(), customerBankAccount.getCorrespondentAccount());
            parameters.put(FinanceDocumentParametersKey.CUSTOMER_BANK_SETTLEMENT_ACCOUNT.name(), customerBankAccount.getSettlementAccount());
        }
        List employees = ProfileDao.getEmployees((EntityReference)customerRef, (ManagerType[])new ManagerType[]{ManagerType.DIRECTOR}, (Date)new Date());
        for (Person employee : employees) {
            String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            Set positions = ProfileHelper.getPositions((List)employee.getEmployments(), (EntityReference)customerRef);
            for (PersonPosition position : positions) {
                if (!ManagerType.DIRECTOR.name().equals(position.getCode())) continue;
                parameters.put(FinanceDocumentParametersKey.CUSTOMER_DIRECTOR.name(), fullName);
                parameters.put(FinanceDocumentParametersKey.CUSTOMER_DIRECTOR_POSITION.name(), DictHelper.getTranslation((BaseDictionary)position, (Locale)locale, (boolean)true));
            }
        }
    }
}

