/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MoneyUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.util.Locale;
import java.util.Map;

public class FinDocsInitializeGeneralDocumentParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        parameters.put(FinanceDocumentParametersKey.FIN_DOC_NUMBER.name(), TextUtil.buildFullNumber((CompositeNumber)financeDocument));
        parameters.put(FinanceDocumentParametersKey.FIN_DOC_DATE.name(), financeDocument.getDate());
        parameters.put(FinanceDocumentParametersKey.FIN_DOC_DATE_IN_WORDS.name(), FinDocsHelper.getDateInWords(financeDocument.getDate(), locale));
        parameters.put(FinanceDocumentParametersKey.FIN_DOC_DATE_MONTH_IN_WORDS.name(), FinDocsHelper.getMonthInWords(financeDocument.getDate(), locale));
        parameters.put(FinanceDocumentParametersKey.TOTAL_COUNT_STRING.name(), MoneyUtil.intToString((int)financeDocument.getBillingItems().size(), (Locale)locale, (String)"M"));
    }
}

