/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;

public class FinDocsInitializeGeneralShipmentParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String moneyCode;
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        Boolean refund = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_REFUND_DOCUMENTS_FLAG);
        parameters.put(FinanceDocumentParametersKey.IS_REFUND.name(), refund);
        parameters.put(FinanceDocumentParametersKey.DATE.name(), shipment.getDate());
        String number = TextUtil.buildFullNumber((CompositeNumber)shipment);
        parameters.put(FinanceDocumentParametersKey.NUMBER.name(), number);
        parameters.put(FinanceDocumentParametersKey.SHIPMENT_DATE.name(), shipment.getDate());
        parameters.put(FinanceDocumentParametersKey.SHIPMENT_NUMBER.name(), number);
        parameters.put(FinanceDocumentParametersKey.SHIPMENT_DATE.name(), shipment.getDate());
        parameters.put(FinanceDocumentParametersKey.SHIPMENT_DATE_IN_WORDS.name(), FinDocsHelper.getDateInWords(shipment.getDate(), locale));
        parameters.put(FinanceDocumentParametersKey.SHIPMENT_DATE_MONTH_IN_WORDS.name(), FinDocsHelper.getMonthInWords(shipment.getDate(), locale));
        ContractCustomerInfo info = (ContractCustomerInfo)EntityStorageHelper.resolve((NestedEntityReference)shipment.getContract(), (EntityStorageContext)sc);
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        parameters.put(FinanceDocumentParametersKey.CONTRACT_NUMBER.name(), info != null ? info.getNumber() : null);
        parameters.put(FinanceDocumentParametersKey.CONTRACT_DATE.name(), info != null ? info.getIssueDate() : null);
        parameters.put(FinanceDocumentParametersKey.CONTRACT_START_DATE.name(), info != null && info.getStartDate() != null ? df.format(info.getStartDate()) : null);
        parameters.put(FinanceDocumentParametersKey.CONTRACT_END_DATE.name(), info != null && info.getEndDate() != null ? df.format(info.getEndDate()) : null);
        String currency = moneyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        parameters.put(FinanceDocumentParametersKey.MONEY_CODE.name(), moneyCode);
        parameters.put(FinanceDocumentParametersKey.MONEY_SYMBOL.name(), currency != null ? MiscUtil.getCurrencySymbol((String)currency) : null);
    }
}

