/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FinDocsInitializePayerParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        EntityContainer payerContainer = EntityStorageHelper.resolve((EntityReference)financeDocument.getPayer(), (EntityStorageContext)sc);
        BaseProfile payer = (BaseProfile)payerContainer.getEntity();
        if (payer instanceof Organization) {
            this.populatePayerParameters((Map<String, Object>)parameters, (Organization)payer, shipment, locale);
            parameters.put(FinanceDocumentParametersKey.PAYER_IS_RETAIL.name(), ProfileHelper.isRetailProfile((EntityReference)shipment.getPayer()));
        } else if (payer instanceof Person) {
            this.populatePayerParameters((Map<String, Object>)parameters, (Person)payer, shipment, locale);
            parameters.put(FinanceDocumentParametersKey.PAYER_IS_RETAIL.name(), true);
        } else {
            parameters.put(FinanceDocumentParametersKey.PAYER_IS_RETAIL.name(), false);
        }
        BankAccount bankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)financeDocument.getPayerBankAccount(), (EntityStorageContext)sc);
        if (bankAccount != null) {
            parameters.put(FinanceDocumentParametersKey.PAYER_BANK_NAME.name(), bankAccount.getBankName());
            parameters.put(FinanceDocumentParametersKey.PAYER_BANK_BIK.name(), bankAccount.getBik());
            parameters.put(FinanceDocumentParametersKey.PAYER_BANK_CITY.name(), bankAccount.getCity() != null ? bankAccount.getCity().toString() : null);
            parameters.put(FinanceDocumentParametersKey.PAYER_BANK_LORO_ACCOUNT.name(), bankAccount.getCorrespondentAccount());
            parameters.put(FinanceDocumentParametersKey.PAYER_BANK_SETTLEMENT_ACCOUNT.name(), bankAccount.getSettlementAccount());
        }
    }

    private void populatePayerParameters(Map<String, Object> parameters, Organization payer, Shipment shipment, Locale locale) {
        List payerAddresses = ProfileHelper.getOrganizationAddresses((Organization)payer, (Date)shipment.getDate());
        parameters.put(FinanceDocumentParametersKey.PAYER.name(), ProfileHelper.getFullName((String)payer.getCode(), (L10nString)payer.getShortName(), (L10nString)payer.getFullName(), (DictionaryReference)payer.getLegalForm(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.PAYER_NAME.name(), ProfileHelper.getFullName((String)payer.getCode(), (L10nString)payer.getShortName(), (L10nString)payer.getFullName(), null, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.PAYER_FULLNAME.name(), FinDocsHelper.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)payer.getLegalForm(), (Locale)locale), payer.getFullName(), (String)HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)shipment.getDate()), (String)HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)shipment.getDate()), payerAddresses, AddressType.LEGAL, payer.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.PAYER_FULLNAME_FACTUAL.name(), FinDocsHelper.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)payer.getLegalForm(), (Locale)locale), payer.getFullName(), (String)HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)shipment.getDate()), (String)HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)shipment.getDate()), payerAddresses, AddressType.FACTUAL, payer.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.PAYER_ADDRESS.name(), FinDocsHelper.buildAddress(payerAddresses, AddressType.LEGAL));
        parameters.put(FinanceDocumentParametersKey.PAYER_PHONE.name(), FinDocsHelper.buildPhone(payer.getCommunications(), false));
        parameters.put(FinanceDocumentParametersKey.PAYER_FAX.name(), FinDocsHelper.buildPhone(payer.getCommunications(), true));
        parameters.put(FinanceDocumentParametersKey.PAYER_INN.name(), HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)shipment.getDate()));
        parameters.put(FinanceDocumentParametersKey.PAYER_KPP.name(), HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)shipment.getDate()));
    }

    private void populatePayerParameters(Map<String, Object> parameters, Person payer, Shipment shipment, Locale locale) {
        parameters.put(FinanceDocumentParametersKey.PAYER.name(), ProfileHelper.getFullName((Person)payer, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.PAYER_NAME.name(), ProfileHelper.getFullName((Person)payer, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.PAYER_FULLNAME.name(), FinDocsHelper.buildPersonFullName(payer, payer.getAddresses(), AddressType.LEGAL, payer.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.PAYER_FULLNAME_FACTUAL.name(), FinDocsHelper.buildPersonFullName(payer, payer.getAddresses(), AddressType.FACTUAL, payer.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.PAYER_ADDRESS.name(), FinDocsHelper.buildPersonAddress(payer.getAddresses(), AddressType.LEGAL));
        parameters.put(FinanceDocumentParametersKey.PAYER_PHONE.name(), FinDocsHelper.buildPersonPhone(payer.getCommunications(), false));
        parameters.put(FinanceDocumentParametersKey.PAYER_FAX.name(), FinDocsHelper.buildPersonPhone(payer.getCommunications(), true));
    }
}

