/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;

public class FinDocsInitializeSignatureParametersProcessor
extends BaseProcessor {
    private static final PersonalLocalizableNameFormatter nameFormatter = new PersonalLocalizableNameFormatter("L f m");

    public void process(MessageContext ctx) throws Exception {
        String title;
        Signature signature = (Signature)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SIGNATURE);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        FinanceDocumentSettings fds = (FinanceDocumentSettings)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT_SETTINGS);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        if (signature.getPosition() == null) {
            return;
        }
        EntityContainer signerContainer = EntityStorage.get().resolve(signature.isUseAgent() ? financeDocument.getAgent() : signature.getSigner());
        if (signerContainer != null) {
            String name = nameFormatter.format((PersonalLocalizableName)signerContainer.getEntity(), LocaleHelper.getCurrentLocale(), false);
            if (!TextUtil.isBlank((String)signature.getComment())) {
                name = name + " " + signature.getComment();
            }
            parameters.put(String.format("AGENCY_%s_NAME", signature.getPosition().getCode()), name);
        }
        if (TextUtil.isBlank((String)(title = signature.getTitle().toString()))) {
            title = signature.getPosition().toString();
        }
        parameters.put(String.format("AGENCY_%s_TITLE", signature.getPosition().getCode()), title);
        parameters.put(String.format("AGENCY_%s_COMMENT", signature.getPosition().getCode()), signature.getComment());
        if (fds.isUseFacsimile()) {
            ImageData signatureImageData = new ImageData(signature.getSignature());
            if (signature.getSignature() != null) {
                parameters.put(String.format("AGENCY_%s_SIGNATURE", signature.getPosition().getCode()), new ByteArrayInputStream(signature.getSignature()));
                parameters.put(String.format("AGENCY_%s_SIGNATURE_WIDTH", signature.getPosition().getCode()), signatureImageData.getWidth());
                parameters.put(String.format("AGENCY_%s_SIGNATURE_HEIGHT", signature.getPosition().getCode()), signatureImageData.getWidth());
            }
        }
    }

    private static class ImageData {
        private final InputStream data;
        private final int width;
        private final int height;

        public ImageData(byte[] data) {
            ByteArrayInputStream is = null;
            BufferedImage image = null;
            if (data != null) {
                is = new ByteArrayInputStream(data);
                try {
                    image = ImageIO.read(is);
                    ((InputStream)is).reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.data = is;
            this.width = image != null ? image.getWidth() : 0;
            this.height = image != null ? image.getHeight() : 0;
        }

        public InputStream getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

