/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FinDocsInitializeStandardTotalsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String moneyCode;
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        boolean isSimpleTaxed = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SIMPLE_TAXES_FLAG);
        FinanceDocumentSettings fds = (FinanceDocumentSettings)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT_SETTINGS);
        EntityReference relationDescriptionRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        String currency = moneyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal totalVat = BigDecimal.ZERO;
        BigDecimal totalCommission = BigDecimal.ZERO;
        PaymentType paymentType = null;
        for (NestedEntityReference itemRef : financeDocument.getBillingItems()) {
            BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
            if (item.getAmount() == null || item.getAmount().getTotal() == null) continue;
            if (null == paymentType) {
                paymentType = this.getPaymentType(item, sc);
            }
            BillingItemSettings bis = fds != null ? FinanceDocumentsHelper.getBillingItemSettings((List)fds.getBillingItemsSettings(), (ServiceType)item.getServiceType()) : null;
            totalPrice = totalPrice.add(item.getAmount().getTotal());
            if (item.getServiceType() == ServiceType.TICKET) {
                totalCommission = totalCommission.add(this.getTotalCommission(item, (EntityReference<ContractRelationDescription>)relationDescriptionRef, sc));
            }
            if (item.getAmount().getVatAmount() == null || (item.getServiceType() != ServiceType.FEE || isSimpleTaxed) && bis != null && !bis.isIncludeVat()) continue;
            totalVat = totalVat.add(item.getAmount().getVatAmount());
        }
        parameters.put(FinanceDocumentParametersKey.TOTAL_PRICE.name(), totalPrice);
        parameters.put(FinanceDocumentParametersKey.TOTAL_VAT.name(), totalVat);
        parameters.put(FinanceDocumentParametersKey.TOTAL_PRICE_STRING.name(), FinDocsHelper.getMoneyStr(totalPrice.abs(), locale, currency, false));
        parameters.put(FinanceDocumentParametersKey.TOTAL_PRICE_STRING_SHORT.name(), FinDocsHelper.getMoneyStr(totalPrice.abs(), locale, currency, true));
        parameters.put(FinanceDocumentParametersKey.TOTAL_VAT_STRING.name(), FinDocsHelper.getMoneyStr(totalVat.abs(), locale, currency, false));
        parameters.put(FinanceDocumentParametersKey.TOTAL_VAT_STRING_SHORT.name(), FinDocsHelper.getMoneyStr(totalVat.abs(), locale, currency, true));
        parameters.put(FinanceDocumentParametersKey.TOTAL_COMMISSION_STRING.name(), FinDocsHelper.getMoneyStr(totalCommission.abs(), locale, currency, false));
        parameters.put(FinanceDocumentParametersKey.TOTAL_COMMISSION_STRING_SHORT.name(), FinDocsHelper.getMoneyStr(totalCommission.abs(), locale, currency, true));
        parameters.put(FinanceDocumentParametersKey.PAYMENT_TYPE.name(), this.getEnumDisplayName((Enum<?>)paymentType, locale));
    }

    private String getEnumDisplayName(Enum<?> e, Locale locale) {
        if (null == e) {
            return null;
        }
        if (null == locale) {
            return e.toString();
        }
        EnumType et = (EnumType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEnums().get(e.getClass().getName());
        if (et == null) {
            return e.name();
        }
        EnumItem ei = (EnumItem)et.getItems().get(e.name());
        return ei == null ? e.name() : ei.getDisplayName(locale);
    }

    private PaymentType getPaymentType(BillingItem item, EntityStorageContext sc) {
        for (NestedEntityReference fopRef : item.getFops()) {
            Fop fop = (Fop)EntityStorageHelper.resolve((NestedEntityReference)fopRef, (EntityStorageContext)sc);
            if (null == fop || fop.getType() == null) continue;
            return fop.getType();
        }
        return null;
    }

    private BigDecimal getTotalCommission(BillingItem item, EntityReference<ContractRelationDescription> descr, EntityStorageContext sc) throws Exception {
        BigDecimal result = BigDecimal.ZERO;
        for (NestedEntityReference fopRef : item.getFops()) {
            BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
            ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            List data = productHandler.getUnmodifiableContractRelations(baseProduct);
            BigDecimal commissionValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)((GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)data, descr)).getCommissions(), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null));
            commissionValue = commissionValue.setScale(2, RoundingMode.HALF_UP);
            ProductStatus status = productHandler.getStatus(baseProduct);
            result = ProductStatus.REFUND == status || ProductStatus.EXCHANGE == status ? result.subtract(commissionValue) : result.add(commissionValue);
        }
        return result;
    }
}

