/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentParametersKey;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FinDocsInitializeSupplierParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT);
        Locale locale = (Locale)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCALE);
        Map parameters = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_PARAMETERS_MAP);
        EntityReference supplierRef = financeDocument.getSupplier();
        EntityContainer supplierContainer = EntityStorageHelper.resolve((EntityReference)supplierRef, (EntityStorageContext)sc);
        Organization supplier = (Organization)supplierContainer.getEntity();
        List supplierAddresses = ProfileHelper.getOrganizationAddresses((Organization)supplier, (Date)shipment.getDate());
        parameters.put(FinanceDocumentParametersKey.AGENCY.name(), ProfileHelper.getFullName((String)supplier.getCode(), (L10nString)supplier.getShortName(), (L10nString)supplier.getFullName(), (DictionaryReference)supplier.getLegalForm(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.AGENCY_NAME.name(), ProfileHelper.getFullName((String)supplier.getCode(), (L10nString)supplier.getShortName(), (L10nString)supplier.getFullName(), null, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        parameters.put(FinanceDocumentParametersKey.AGENCY_FULL_LEGAL_FORM.name(), FinDocsHelper.getFullLegalForm((DictionaryReference<LegalForm>)supplier.getLegalForm(), locale));
        parameters.put(FinanceDocumentParametersKey.AGENCY_FULLNAME.name(), FinDocsHelper.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)supplier.getLegalForm(), (Locale)locale), supplier.getFullName(), (String)HistoricalValueHelper.getValue((List)supplier.getRegistrationIdHistory(), (Date)shipment.getDate()), (String)HistoricalValueHelper.getValue((List)supplier.getKppHistory(), (Date)shipment.getDate()), supplierAddresses, AddressType.LEGAL, supplier.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.AGENCY_FULLNAME_FACTUAL.name(), FinDocsHelper.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference)supplier.getLegalForm(), (Locale)locale), supplier.getFullName(), (String)HistoricalValueHelper.getValue((List)supplier.getRegistrationIdHistory(), (Date)shipment.getDate()), (String)HistoricalValueHelper.getValue((List)supplier.getKppHistory(), (Date)shipment.getDate()), supplierAddresses, AddressType.FACTUAL, supplier.getBankAccounts(), LocaleHelper.getCurrentLocale(), false));
        parameters.put(FinanceDocumentParametersKey.AGENCY_ADDRESS.name(), FinDocsHelper.buildAddress(supplierAddresses, AddressType.LEGAL));
        parameters.put(FinanceDocumentParametersKey.AGENCY_PHONE.name(), FinDocsHelper.buildPhone(supplier.getCommunications(), false));
        parameters.put(FinanceDocumentParametersKey.AGENCY_FAX.name(), FinDocsHelper.buildPhone(supplier.getCommunications(), true));
        parameters.put(FinanceDocumentParametersKey.AGENCY_INN.name(), HistoricalValueHelper.getValue((List)supplier.getRegistrationIdHistory(), (Date)shipment.getDate()));
        parameters.put(FinanceDocumentParametersKey.AGENCY_KPP.name(), HistoricalValueHelper.getValue((List)supplier.getKppHistory(), (Date)shipment.getDate()));
        BankAccount bankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)financeDocument.getSupplierBankAccount(), (EntityStorageContext)sc);
        if (bankAccount != null) {
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_NAME.name(), bankAccount.getBankName());
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_BIK.name(), bankAccount.getBik());
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_CITY.name(), bankAccount.getCity() != null ? bankAccount.getCity().toString() : null);
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_LORO_ACCOUNT.name(), bankAccount.getCorrespondentAccount());
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_SETTLEMENT_ACCOUNT.name(), bankAccount.getSettlementAccount());
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_LORO_ACCAUNT.name(), bankAccount.getCorrespondentAccount());
            parameters.put(FinanceDocumentParametersKey.AGENCY_BANK_SETTLEMENT_ACCAUNT.name(), bankAccount.getSettlementAccount());
        }
        List employees = ProfileDao.getEmployees((EntityReference)supplierRef, (ManagerType[])new ManagerType[]{ManagerType.DIRECTOR, ManagerType.CHIEF_ACCOUNTANT, ManagerType.CHIEF_MUTUAL, ManagerType.TRAVEL_MANAGER, ManagerType.CASHIER}, (Date)new Date());
        for (Person employee : employees) {
            String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            Set positions = ProfileHelper.getPositions((List)employee.getEmployments(), (EntityReference)supplierRef);
            for (PersonPosition position : positions) {
                if (ManagerType.DIRECTOR.name().equals(position.getCode())) {
                    parameters.put(FinanceDocumentParametersKey.DIRECTOR.name(), fullName);
                    parameters.put(FinanceDocumentParametersKey.DIRECTOR_POSITION.name(), DictHelper.getTranslation((BaseDictionary)position, (Locale)locale, (boolean)true));
                    continue;
                }
                if (ManagerType.CHIEF_ACCOUNTANT.name().equals(position.getCode())) {
                    parameters.put(FinanceDocumentParametersKey.ACCOUNTANT.name(), fullName);
                    parameters.put(FinanceDocumentParametersKey.ACCOUNTANT_POSITION.name(), DictHelper.getTranslation((BaseDictionary)position, (Locale)locale, (boolean)true));
                    continue;
                }
                if (ManagerType.CHIEF_MUTUAL.name().equals(position.getCode())) {
                    parameters.put(FinanceDocumentParametersKey.CHIEF_MUTUAL.name(), fullName);
                    parameters.put(FinanceDocumentParametersKey.CHIEF_MUTUAL_POSITION.name(), DictHelper.getTranslation((BaseDictionary)position, (Locale)locale, (boolean)true));
                    continue;
                }
                if (ManagerType.TRAVEL_MANAGER.name().equals(position.getCode())) {
                    parameters.put(FinanceDocumentParametersKey.TRAVEL_MANAGER.name(), fullName);
                    parameters.put(FinanceDocumentParametersKey.TRAVEL_MANAGER_POSITION.name(), DictHelper.getTranslation((BaseDictionary)position, (Locale)locale, (boolean)true));
                    continue;
                }
                if (!ManagerType.CASHIER.name().equals(position.getCode())) continue;
                parameters.put(FinanceDocumentParametersKey.AGENCY_CASHIER.name(), fullName);
                parameters.put(FinanceDocumentParametersKey.AGENCY_CASHIER_POSITION.name(), DictHelper.getTranslation((BaseDictionary)position, (Locale)locale, (boolean)true));
            }
        }
    }
}

