/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FinDocsLockEntitiesAdvice
extends BaseAdvice {
    private static Comparator<EntityContainer<?>> CONTAINERS_COMPARATOR = Comparator.comparing(BaseIdentity::getUid);

    public void before(MessageContext ctx) throws Exception {
        List lst = (List)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA_LIST);
        if (lst == null) {
            this.log.error("FINDOCS_SHIPMENT_DATA_LIST parameter is missing");
            return;
        }
        EntityStorageContext sc = (EntityStorageContext)ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ArrayList<Object> lockObjects = new ArrayList<Object>();
        for (ShipmentOperationProductBatch batch : lst) {
            EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)batch.getShipment(), (EntityStorageContext)sc);
            if (shipmentCtr != null && !lockObjects.contains(shipmentCtr)) {
                lockObjects.add(shipmentCtr);
            }
            for (NestedEntityReference nestedEntityReference : batch.getProducts()) {
                EntityContainer bookingCtr = EntityStorageHelper.resolve((EntityReference)new EntityReference(nestedEntityReference.getUid(), BookingFile.class, null), (EntityStorageContext)sc);
                if (bookingCtr == null || lockObjects.contains(bookingCtr)) continue;
                lockObjects.add(bookingCtr);
            }
        }
        lockObjects.sort(CONTAINERS_COMPARATOR);
        ArrayList<NamedLock> locks = new ArrayList<NamedLock>();
        boolean canProcess = true;
        String objectTitle = null;
        for (EntityContainer entityContainer : lockObjects) {
            objectTitle = entityContainer.getEntity().toString();
            try {
                NamedLock lock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey((EntityContainer)entityContainer), TimeUnit.MINUTES.toMillis(10L));
                locks.add(lock);
                if (lock.tryLock(10L, TimeUnit.SECONDS)) {
                    this.log.debug("successfully obtained lock " + objectTitle);
                    EntityContainer existingContainer = EntityStorage.get().resolve(entityContainer.toReference());
                    if (existingContainer == null || !SystemHelper.isModifiedByThirdPartyProcess((VersionInfo)existingContainer.getVersionInfo(), (VersionInfo)entityContainer.getVersionInfo())) continue;
                    canProcess = false;
                    this.log.debug(String.format("object %s was modified by background process %s", objectTitle, existingContainer.getModifiedBy()));
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0431\u044a\u0435\u043a\u0442 {0} \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0444\u043e\u043d\u043e\u0432\u044b\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c {1}", (Object[])new Object[]{objectTitle, existingContainer.getModifiedBy()}));
                    break;
                }
                this.log.debug(String.format("unable to get lock for booking %s", objectTitle));
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 {0}", (Object[])new Object[]{objectTitle}));
                canProcess = false;
            }
            catch (Exception e) {
                this.log.error("unable to get lock on " + objectTitle, (Throwable)e);
                canProcess = false;
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 {0}", (Throwable)e, (Object[])new Object[]{objectTitle}));
            }
            break;
        }
        if (!canProcess) {
            ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_LOCK_ERROR_OCCURED, (Object)Boolean.TRUE);
            this.unlock(locks);
            throw Xeption.forEndUser((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u0437\u044f\u0442\u044c \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 {0}, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0437\u0436\u0435", (Object[])new Object[]{objectTitle});
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_ENTITIES_LOCKS_LIST, locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(List<NamedLock> locks) {
        for (NamedLock lock : locks) {
            try {
                if (!lock.isLocked()) continue;
                lock.unlock();
            }
            catch (Exception e) {
                try {
                    this.log.error("unable to unlock " + lock.getName(), (Throwable)e);
                }
                catch (Exception e1) {
                    this.log.error("unable to get name for lock" + lock);
                }
            }
            finally {
                try {
                    lock.close();
                }
                catch (Exception e) {
                    try {
                        this.log.error("unable to close " + lock.getName(), (Throwable)e);
                    }
                    catch (Exception e1) {
                        this.log.error("unable to get name for lock" + lock);
                    }
                }
            }
        }
    }

    public void after(MessageContext ctx) throws Exception {
        List locks = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_ENTITIES_LOCKS_LIST);
        this.unlock(locks);
    }
}

