/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentDataSourceField;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;

public class FinDocsPutDataSourceEntryProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List list = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_DATA_SOURCE_LIST);
        BillingItem item = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        FinanceDocumentSettings fds = (FinanceDocumentSettings)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENT_SETTINGS);
        boolean noVat = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SIMPLE_TAXES_FLAG);
        HashMap<String, Object> record = new HashMap<String, Object>();
        BillingItemSettings bis = FinanceDocumentsHelper.getBillingItemSettings((List)fds.getBillingItemsSettings(), (ServiceType)item.getServiceType());
        record.put(FinanceDocumentDataSourceField.NUMBER.name(), list.size() + 1);
        int size = item.getPositionsCount();
        record.put(FinanceDocumentDataSourceField.COUNT.name(), size);
        record.put(FinanceDocumentDataSourceField.IS_SERVICE.name(), item.getServiceType() != ServiceType.TICKET && item.getServiceType() != ServiceType.PENALTY);
        record.put(FinanceDocumentDataSourceField.NAME.name(), item.getName());
        VatAmount grandTotal = new VatAmount();
        if (item.getAmount() != null) {
            grandTotal.setTotalVatAmount(item.getAmount().getTotal(), item.getAmount().getVatAmount());
        }
        record.put(FinanceDocumentDataSourceField.GRAND_TOTAL.name(), grandTotal);
        if (grandTotal.getTotal() != null) {
            record.put(FinanceDocumentDataSourceField.TOTAL.name(), grandTotal.getTotal().divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP));
        }
        if (bis == null || bis.isIncludeVat() || item.getServiceType() == ServiceType.FEE && !noVat) {
            Double vat;
            record.put(FinanceDocumentDataSourceField.GRAND_VAT.name(), grandTotal.getVatAmount());
            if (grandTotal.getVatAmount() != null) {
                record.put(FinanceDocumentDataSourceField.VAT.name(), grandTotal.getVatAmount().divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP));
            }
            if ((vat = grandTotal.getVat()) != null) {
                vat = BigDecimal.valueOf(vat).divide(BigDecimal.ONE, 1, RoundingMode.HALF_UP).doubleValue();
            }
            record.put(FinanceDocumentDataSourceField.VAT_PERCENT.name(), vat);
        }
        list.add(record);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_DATA_SOURCE_ITEM, record);
    }
}

