/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Iterator;

public class FinDocsPutFeeForRefundFlagProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItem billingItem = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        boolean isFeeForRefund = false;
        block0: for (NestedEntityReference fopRef : billingItem.getFops()) {
            BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
            ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            for (GeneralProductContractRelationData data : productHandler.getUnmodifiableContractRelations(baseProduct)) {
                Iterator iterator = data.getCommissions().iterator();
                if (!iterator.hasNext()) continue;
                GeneralProductCommission commission = (GeneralProductCommission)iterator.next();
                isFeeForRefund = BookingHelper.isFeeForRefund((EntityReference)commission.getCommissionProperties());
                break block0;
            }
        }
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_FEE_FOR_REFUND_FLAG, (Object)isFeeForRefund);
    }
}

