/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class FinDocsPutRefundDocumentsFlagProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List productsRefs = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        boolean isRefund = FinDocsPutRefundDocumentsFlagProcessor.isRefund(productsRefs, sc);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_REFUND_DOCUMENTS_FLAG, (Object)isRefund);
    }

    public static boolean isRefund(List<NestedEntityReference<BookingFile, BaseProduct>> productsRefs, EntityStorageContext sc) {
        for (NestedEntityReference<BookingFile, BaseProduct> productRef : productsRefs) {
            ProductHandler handler;
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve(productRef, (EntityStorageContext)sc);
            if (product == null || (handler = HandlersRegistry.get().findProductHandler(product.getClass())) == null || handler.getStatus(product) != ProductStatus.REFUND) continue;
            return true;
        }
        return false;
    }
}

