/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

public class FinDocsRebuildShipmentsPrepareShipmentBatchesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection shipmentRefs = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCES);
        HashMap<EntityReference, ShipmentOperationProductBatch> shipments = new HashMap<EntityReference, ShipmentOperationProductBatch>();
        for (EntityReference shipmentRef : shipmentRefs) {
            EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)sc);
            if (null == shipmentCtr) continue;
            Shipment shipment = (Shipment)shipmentCtr.getEntity();
            ShipmentOperationProductBatch hub = (ShipmentOperationProductBatch)shipments.get(shipmentRef);
            if (null == hub) {
                hub = new ShipmentOperationProductBatch();
                hub.setShipment(shipmentRef);
                shipments.put(shipmentRef, hub);
            }
            for (NestedEntityReference itemRef : shipment.getBillingItems()) {
                BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
                for (NestedEntityReference fopRef : item.getFops()) {
                    BaseProduct product2 = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                    if (null == product2) {
                        product2 = this.getSimulateProduct((NestedEntityReference<BookingFile, Fop>)fopRef, sc);
                    }
                    if (null == product2) {
                        if (Boolean.TRUE.equals(ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_IGNORE_BROKEN_FOPS))) continue;
                        throw Xeption.forEndUser((String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object[])new Object[0]);
                    }
                    NestedEntityReference product2Ref = new NestedEntityReference((EntityReference)fopRef, (BaseEntity)product2);
                    if (hub.getProducts().contains(product2Ref)) continue;
                    hub.getProducts().add(product2Ref);
                }
            }
        }
        LinkedList shipmentList = new LinkedList(shipments.values());
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_LOG_FILENAME, (Object)FinDocsHelper.buildLogFileName("rebuild-products-%s-%s.xml", shipmentRefs, new SimpleDateFormat("HH-mm-ss").format(new Date())));
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA_LIST, shipmentList);
    }

    private BaseProduct getSimulateProduct(NestedEntityReference<BookingFile, Fop> fopRef, EntityStorageContext sc) {
        EntityContainer bookingFileCtr = EntityStorageHelper.resolve(fopRef, (EntityStorageContext)sc);
        if (null == bookingFileCtr) {
            return null;
        }
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        if (bookingFile.getReservations().size() != 1 || ((Reservation)bookingFile.getReservations().get(0)).getProducts().size() != 1) {
            return null;
        }
        return (BaseProduct)((Reservation)bookingFile.getReservations().get(0)).getProducts().get(0);
    }
}

