/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class FinDocsUSCleanupShipmentContextProcessor
extends BaseProcessor {
    protected static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");

    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ShipmentOperationProductBatch data = (ShipmentOperationProductBatch)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA);
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER);
        this.forget((EntityContainer<Shipment>)shipmentCtr, sc);
        EntityReference newShipmentRef = data.getShipment();
        if (newShipmentRef != null) {
            EntityContainer newShipmentCtr = EntityStorageHelper.resolve((EntityReference)newShipmentRef, (EntityStorageContext)sc);
            Shipment newShipment = (Shipment)newShipmentCtr.getEntity();
            ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER, (Object)newShipmentCtr);
            ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCE, (Object)newShipmentRef);
            ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT, (Object)newShipment);
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] shipment {0} is not changed"), (Object[])new Object[]{newShipmentRef}));
        } else {
            this.log.error("newShipmentRef is null");
        }
    }

    private void forget(EntityContainer<Shipment> shipmentCtr, EntityStorageContext sc) {
        EntityStorageHelper.forget(shipmentCtr, (EntityStorageContext)sc);
        Shipment shipment = (Shipment)shipmentCtr.getEntity();
        for (NestedEntityReference itemRef : shipment.getBillingItems()) {
            EntityStorageHelper.forget((EntityReference)itemRef, (EntityStorageContext)sc);
        }
        for (NestedEntityReference itemRef : shipment.getPaymentItems()) {
            EntityStorageHelper.forget((EntityReference)itemRef, (EntityStorageContext)sc);
        }
        for (NestedEntityReference itemRef : shipment.getFinanceDocuments()) {
            EntityStorageHelper.forget((EntityReference)itemRef, (EntityStorageContext)sc);
        }
    }
}

