/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.finance.ShipmentsChangeData;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;

public class FinDocsUSDeleteShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference newShipmentRef;
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ShipmentOperationProductBatch data = (ShipmentOperationProductBatch)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA);
        EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)data.getShipment(), (EntityStorageContext)sc);
        if (shipmentCtr != null) {
            this.forget((EntityContainer<Shipment>)shipmentCtr, sc);
        }
        if ((newShipmentRef = data.getShipment()) != null) {
            EntityContainer newShipmentCtr = EntityStorageHelper.resolve((EntityReference)newShipmentRef, (EntityStorageContext)sc);
            this.delete((EntityContainer<Shipment>)newShipmentCtr, (EntityReference<Shipment>)newShipmentRef, sc);
        }
        ShipmentsChangeData changeData = (ShipmentsChangeData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENTS_CHANGE_DATA);
        changeData.getDeleted().add(newShipmentRef);
        ctx.removeObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER);
        ctx.removeObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCE);
        ctx.removeObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"shipment {0} deleted", (Object[])new Object[]{newShipmentRef}));
    }

    private void delete(EntityContainer<Shipment> shipmentCtr, EntityReference<Shipment> shipmentRef, EntityStorageContext sc) {
        BillingItem item;
        EntityStorageHelper.deleteContainer(shipmentCtr, (EntityStorageContext)sc);
        Shipment shipment = (Shipment)shipmentCtr.getEntity();
        HashSet<BaseEntity> bookingFiles = new HashSet<BaseEntity>();
        HashSet<EntityContainer> bils = new HashSet<EntityContainer>();
        for (NestedEntityReference nestedEntityReference : shipment.getBillingItems()) {
            EntityContainer billingItemsList = EntityStorageHelper.resolve((EntityReference)nestedEntityReference, (EntityStorageContext)sc);
            if (null == billingItemsList) continue;
            bils.add(billingItemsList);
            item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)nestedEntityReference, (EntityStorageContext)sc);
            if (item == null) continue;
            for (NestedEntityReference fopRef : item.getFops()) {
                EntityContainer bookingFile = EntityStorageHelper.resolve((EntityReference)fopRef, (EntityStorageContext)sc);
                if (bookingFile == null) continue;
                bookingFiles.add(bookingFile.getEntity());
            }
            ((BillingItemsList)billingItemsList.getEntity()).getData().remove(item);
        }
        for (EntityContainer entityContainer : bils) {
            if (!((BillingItemsList)entityContainer.getEntity()).getData().isEmpty()) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)entityContainer, (EntityStorageContext)sc);
        }
        for (BookingFile bookingFile : bookingFiles) {
            bookingFile.getShipments().remove(shipmentRef);
        }
        HashSet<EntityContainer> pils = new HashSet<EntityContainer>();
        for (NestedEntityReference itemRef : shipment.getPaymentItems()) {
            EntityContainer paymentItemsList = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
            if (null == paymentItemsList) continue;
            pils.add(paymentItemsList);
            PaymentItem item3 = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
            if (item3 == null) continue;
            ((PaymentItemsList)paymentItemsList.getEntity()).getData().remove(item3);
        }
        for (EntityContainer item4 : pils) {
            if (!((PaymentItemsList)item4.getEntity()).getData().isEmpty()) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)item4, (EntityStorageContext)sc);
        }
        for (NestedEntityReference itemRef : shipment.getFinanceDocuments()) {
            item = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
            if (null == item) continue;
            FinanceDocument document = (FinanceDocument)item.getEntity();
            document.getRelatedShipments().remove(shipmentRef);
            if (!document.getRelatedShipments().isEmpty()) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)item, (EntityStorageContext)sc);
        }
    }

    private void forget(EntityContainer<Shipment> shipmentCtr, EntityStorageContext sc) {
        EntityStorageHelper.forget(shipmentCtr, (EntityStorageContext)sc);
        Shipment shipment = (Shipment)shipmentCtr.getEntity();
        for (NestedEntityReference itemRef : shipment.getBillingItems()) {
            EntityStorageHelper.forget((EntityReference)itemRef, (EntityStorageContext)sc);
        }
        for (NestedEntityReference itemRef : shipment.getPaymentItems()) {
            EntityStorageHelper.forget((EntityReference)itemRef, (EntityStorageContext)sc);
        }
        for (NestedEntityReference itemRef : shipment.getFinanceDocuments()) {
            EntityStorageHelper.forget((EntityReference)itemRef, (EntityStorageContext)sc);
        }
    }
}

