/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FindocOperationType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class FinDocsUSShipmentChangedRoutingKeyProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        ShipmentOperationProductBatch data = (ShipmentOperationProductBatch)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA);
        EntityReference oldShipmentRef = data.getShipment();
        if (null == oldShipmentRef) {
            return "YES";
        }
        FindocOperationType operationType = (FindocOperationType)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_OPERATION_TYPE);
        if (operationType == FindocOperationType.REBUILD_SHIPMENTS) {
            return "YES";
        }
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        List billingItems = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEMS_LIST);
        EntityContainer oldShipmentCtr = EntityStorageHelper.resolve((EntityReference)oldShipmentRef, (EntityStorageContext)sc);
        if (null == oldShipmentCtr) {
            return "YES";
        }
        Shipment oldShipment = (Shipment)oldShipmentCtr.getEntity();
        if (!(MiscUtil.equals((Object)shipment.getSupplier(), (Object)oldShipment.getSupplier()) && MiscUtil.equals((Object)shipment.getCustomer(), (Object)oldShipment.getCustomer()) && MiscUtil.equals((Object)shipment.getPayer(), (Object)oldShipment.getPayer()) && shipment.getDate() != null && oldShipment.getDate() != null && MiscUtil.isSameDay((Date)shipment.getDate(), (Date)oldShipment.getDate()) && MiscUtil.equals((Object)shipment.getAgent(), (Object)oldShipment.getAgent()))) {
            return "YES";
        }
        if (billingItems.size() != oldShipment.getBillingItems().size()) {
            return "YES";
        }
        HashSet bils = new HashSet(billingItems);
        block0: for (NestedEntityReference itemRef : oldShipment.getBillingItems()) {
            BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
            if (null == item) {
                return "YES";
            }
            for (BillingItem item2 : bils) {
                if (!MiscUtil.equals((Object)item.getName(), (Object)item2.getName()) || !MiscUtil.equals((Object)item.getServiceType(), (Object)item2.getServiceType()) || item.getPositionsCount() != item2.getPositionsCount() || !MiscUtil.equals((Object)item.getAmount(), (Object)item2.getAmount()) || !CollectionUtil.equals((Collection)item.getFops(), (Collection)item2.getFops(), (boolean)true)) continue;
                bils.remove(item2);
                continue block0;
            }
            return "YES";
        }
        return "NO";
    }
}

