/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.finance.ShipmentsChangeData;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class FinDocsUSSwapShipmentsContextProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ShipmentOperationProductBatch data = (ShipmentOperationProductBatch)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER);
        if (data.getShipment() == null) {
            ShipmentsChangeData changeData = (ShipmentsChangeData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENTS_CHANGE_DATA);
            changeData.getChanged().add(shipmentCtr.toReference());
            return;
        }
        EntityReference newShipmentRef = data.getShipment();
        EntityContainer newShipmentCtr = EntityStorageHelper.resolve((EntityReference)newShipmentRef, (EntityStorageContext)sc);
        Shipment newShipment = (Shipment)newShipmentCtr.getEntity();
        this.copy(newShipment, shipment, (EntityReference<Shipment>)newShipmentRef, sc);
        EntityStorageHelper.forget((EntityContainer)shipmentCtr, (EntityStorageContext)sc);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_CONTAINER, (Object)newShipmentCtr);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCE, (Object)newShipmentRef);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT, (Object)newShipment);
        ShipmentsChangeData changeData = (ShipmentsChangeData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENTS_CHANGE_DATA);
        changeData.getChanged().add(newShipmentRef);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"shipment {0} is changed", (Object[])new Object[]{newShipmentRef}));
    }

    private void copy(Shipment toShipment, Shipment fromShipment, EntityReference<Shipment> toShipmentRef, EntityStorageContext sc) throws Exception {
        EntityContainer list;
        BillingItem item;
        EntityContainer billingItemsListCtr = null;
        for (Object itemRef : toShipment.getBillingItems()) {
            EntityContainer billingItemsListCtr2 = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
            if (null == billingItemsListCtr2) continue;
            if (null == billingItemsListCtr) {
                billingItemsListCtr = billingItemsListCtr2;
                continue;
            }
            if (billingItemsListCtr2 == billingItemsListCtr) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)billingItemsListCtr2, (EntityStorageContext)sc);
        }
        EntityContainer paymentItemsListCtr = null;
        for (NestedEntityReference itemRef : toShipment.getPaymentItems()) {
            EntityContainer paymentItemsListCtr2 = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
            if (null == paymentItemsListCtr2) continue;
            if (null == paymentItemsListCtr) {
                paymentItemsListCtr = paymentItemsListCtr2;
                continue;
            }
            if (paymentItemsListCtr2 == paymentItemsListCtr) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)paymentItemsListCtr2, (EntityStorageContext)sc);
        }
        for (NestedEntityReference itemRef : toShipment.getFinanceDocuments()) {
            EntityContainer item2 = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
            if (null == item2) continue;
            FinanceDocument document = (FinanceDocument)item2.getEntity();
            document.getRelatedShipments().remove(toShipmentRef);
            if (!document.getRelatedShipments().isEmpty()) continue;
            EntityStorageHelper.deleteContainer((EntityContainer)item2, (EntityStorageContext)sc);
        }
        String number = toShipment.getNumber();
        String numberPrefix = toShipment.getNumberPrefix();
        String numberSuffix = toShipment.getNumberSuffix();
        XCloneModelHelper.copy((BaseEntity)fromShipment, (BaseEntity)toShipment);
        toShipment.setNumber(number);
        toShipment.setNumberPrefix(numberPrefix);
        toShipment.setNumberSuffix(numberSuffix);
        if (billingItemsListCtr != null) {
            BillingItemsList billingItemsList = (BillingItemsList)billingItemsListCtr.getEntity();
            billingItemsList.getData().clear();
            toShipment.getBillingItems().clear();
            for (NestedEntityReference itemRef : fromShipment.getBillingItems()) {
                item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
                list = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
                ((BillingItemsList)list.getEntity()).getData().remove(item);
                billingItemsList.getData().add(item);
                EntityStorageHelper.forget((EntityContainer)list, (EntityStorageContext)sc);
            }
        }
        if (paymentItemsListCtr != null) {
            PaymentItemsList paymentItemsList = (PaymentItemsList)paymentItemsListCtr.getEntity();
            paymentItemsList.getData().clear();
            toShipment.getPaymentItems().clear();
            for (NestedEntityReference itemRef : fromShipment.getPaymentItems()) {
                item = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
                list = EntityStorageHelper.resolve((EntityReference)itemRef, (EntityStorageContext)sc);
                ((PaymentItemsList)list.getEntity()).getData().remove(item);
                paymentItemsList.getData().add(item);
                EntityStorageHelper.forget((EntityContainer)list, (EntityStorageContext)sc);
            }
        }
    }
}

