/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;

public class FinDocsUpdateBookingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityReference shipmentRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_REFERENCE);
        HashSet<BookingFile> bookingFileList = new HashSet<BookingFile>();
        for (NestedEntityReference itemRef : shipment.getBillingItems()) {
            BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
            for (NestedEntityReference fopRef : item.getFops()) {
                BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                bookingFileList.add(baseProduct.getReservation().getBookingFile());
            }
        }
        for (BookingFile bookingFile : bookingFileList) {
            if (bookingFile.getShipments().contains(shipmentRef)) continue;
            bookingFile.getShipments().add(shipmentRef);
        }
    }
}

