/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;

public class FinDocsUpdateDataSourceEntryWithCostCodesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItem item = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        Map record = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_RENDERING_DATA_SOURCE_ITEM);
        HashMap<String, String> costCodeVaues = new HashMap<String, String>();
        for (NestedEntityReference nestedEntityReference : item.getFops()) {
            StatisticalData statisticalData;
            BaseProduct baseProduct = BookingHelper.getProductByFop((NestedEntityReference)nestedEntityReference, (EntityStorageContext)sc);
            if (!(baseProduct instanceof Product) || null == (statisticalData = ((Product)baseProduct).getStatisticalData())) continue;
            for (CostCode costCode : StatisticsHelper.getAllCostCodes((StatisticalData)statisticalData)) {
                CostCodeProperties costCodeProperties = costCode.getCostCodeProperties();
                String costCodeValue = costCode.getValue();
                if (costCodeProperties == null || costCodeProperties.getType() == null || costCodeValue == null) continue;
                costCodeVaues.put(costCodeProperties.getType().name(), costCodeValue);
            }
        }
        for (Map.Entry entry : costCodeVaues.entrySet()) {
            record.put(entry.getKey(), entry.getValue());
        }
    }
}

