/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsCommissionData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class FinDocsUpdateDiscountsBillingItemsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference relationDescription = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItemData biData = (BillingItemData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA);
        if (biData.getDiscounts().isEmpty()) {
            return;
        }
        boolean isSimpleTaxed = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SIMPLE_TAXES_FLAG);
        BillingItem item = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>();
        for (FinanceDocumentsCommissionData data : biData.getDiscounts()) {
            BaseProduct bp = data.getProduct();
            if (!products.contains(bp)) {
                products.add(bp);
            }
            EntityContainer ctr = (EntityContainer)EntityStorageHelper.findParentEntity((BaseEntity)data.getProduct(), EntityContainer.class, (EntityStorageContext)context);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)handler.getUnmodifiableContractRelations(bp), (EntityReference)relationDescription);
            for (GeneralProductFop fop : relation.getFops()) {
                if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) continue;
                item.getFops().add(new NestedEntityReference(ctr.toReference(), fop.getUid(), Fop.class, fop.toString()));
            }
        }
        BaseProduct bp = (BaseProduct)products.get(0);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
        ProductStatus status = handler.getStatus(bp);
        BigDecimal total = BigDecimal.ZERO;
        for (FinanceDocumentsCommissionData data : biData.getDiscounts()) {
            BigDecimal ec = data.getEquivalentAmount();
            if (ec == null) continue;
            total = total.subtract(ec);
        }
        if (status == ProductStatus.REFUND) {
            total = total.negate();
        }
        VatAmount hAmount = new VatAmount();
        hAmount.setTotalVat(total, isSimpleTaxed ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        item.getAmount().setTotalVatAmount(item.getAmount().getTotal().add(hAmount.getTotal()), item.getAmount().getVatAmount().add(hAmount.getVatAmount()));
    }
}

