/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentOperationProductBatch;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class FinDocsUpdateExistingShipmentsPrepareShipmentBatchesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List productRefs = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        HashMap<EntityReference, ShipmentOperationProductBatch> shipments = new HashMap<EntityReference, ShipmentOperationProductBatch>();
        LinkedHashSet<String> productNumbers = new LinkedHashSet<String>();
        for (NestedEntityReference productRef : productRefs) {
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)sc);
            if (null == product) continue;
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            productNumbers.add(CollectionUtil.collectionToString((Iterable)handler.getProductNumbers(product), (String)"-", (boolean)true));
            BookingFile bookingFile = product.getReservation().getBookingFile();
            for (EntityReference shipmentRef : bookingFile.getShipments()) {
                EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)sc);
                if (null == shipmentCtr) continue;
                Shipment shipment = (Shipment)shipmentCtr.getEntity();
                boolean found = false;
                block2: for (NestedEntityReference itemRef : shipment.getBillingItems()) {
                    BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
                    for (NestedEntityReference fopRef : item.getFops()) {
                        BaseProduct product2 = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                        if (!product.equals((Object)product2)) continue;
                        found = true;
                        break block2;
                    }
                }
                if (!found) continue;
                ShipmentOperationProductBatch hub = (ShipmentOperationProductBatch)shipments.get(shipmentRef);
                if (null == hub) {
                    hub = new ShipmentOperationProductBatch();
                    hub.setShipment(shipmentRef);
                    shipments.put(shipmentRef, hub);
                }
                for (NestedEntityReference itemRef : shipment.getBillingItems()) {
                    BillingItem item = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)sc);
                    for (NestedEntityReference fopRef : item.getFops()) {
                        BaseProduct product2 = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)sc);
                        NestedEntityReference product2Ref = new NestedEntityReference((EntityReference)fopRef, (BaseEntity)product2);
                        if (hub.getProducts().contains(product2Ref)) continue;
                        hub.getProducts().add(product2Ref);
                    }
                }
            }
        }
        LinkedList shipmentList = new LinkedList(shipments.values());
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT_DATA_LIST, shipmentList);
        ctx.putObject((Enum)IBusFinanceContextKeys.FINDOCS_LOG_FILENAME, (Object)FinDocsHelper.buildLogFileName("update-shipments-%s-%s.xml", productNumbers, new SimpleDateFormat("HH-mm-ss").format(new Date())));
    }
}

